/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion.averaging;

import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.analytical.EcksteinHechlerPropagator;
import org.orekit.propagation.conversion.averaging.AbstractHarmonicsBasedOrbitalState;
import org.orekit.propagation.conversion.averaging.elements.AveragedCircularWithMeanAngle;
import org.orekit.time.AbsoluteDate;

public class EcksteinHechlerOrbitalState
extends AbstractHarmonicsBasedOrbitalState {
    private final AveragedCircularWithMeanAngle averagedElements;

    public EcksteinHechlerOrbitalState(AbsoluteDate date, AveragedCircularWithMeanAngle elements, Frame frame, UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        super(date, frame, harmonicsProvider);
        this.averagedElements = elements;
    }

    @Override
    public OrbitType getOrbitType() {
        return OrbitType.CIRCULAR;
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return PositionAngleType.MEAN;
    }

    @Override
    public AveragedCircularWithMeanAngle getAveragedElements() {
        return this.averagedElements;
    }

    @Override
    public Orbit toOsculatingOrbit() {
        EcksteinHechlerPropagator propagator = this.createPropagator();
        return propagator.propagateOrbit(this.getDate());
    }

    private EcksteinHechlerPropagator createPropagator() {
        CircularOrbit orekitOrbit = this.createOrekitOrbit();
        return new EcksteinHechlerPropagator((Orbit)orekitOrbit, this.getHarmonicsProvider(), PropagationType.MEAN);
    }

    private CircularOrbit createOrekitOrbit() {
        return new CircularOrbit(this.averagedElements.getAveragedSemiMajorAxis(), this.averagedElements.getAveragedCircularEx(), this.averagedElements.getAveragedCircularEy(), this.averagedElements.getAveragedInclination(), this.averagedElements.getAveragedRightAscensionOfTheAscendingNode(), this.averagedElements.getAveragedMeanLatitudeArgument(), this.getPositionAngleType(), this.getFrame(), this.getDate(), this.getMu());
    }
}

