/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion.averaging;

import java.util.ArrayList;
import java.util.Collection;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.averaging.AbstractHarmonicsBasedOrbitalState;
import org.orekit.propagation.conversion.averaging.elements.AveragedEquinoctialWithMeanAngle;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTZonal;
import org.orekit.time.AbsoluteDate;

public class DSST6X0OrbitalState
extends AbstractHarmonicsBasedOrbitalState {
    private final AveragedEquinoctialWithMeanAngle averagedElements;

    public DSST6X0OrbitalState(AbsoluteDate date, AveragedEquinoctialWithMeanAngle elements, Frame frame, UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        super(date, frame, harmonicsProvider);
        this.averagedElements = elements;
    }

    public static Collection<DSSTForceModel> createForces(UnnormalizedSphericalHarmonicsProvider provider) {
        ArrayList<DSSTForceModel> forceModels = new ArrayList<DSSTForceModel>();
        DSSTZonal zonal = new DSSTZonal(provider);
        forceModels.add(zonal);
        return forceModels;
    }

    @Override
    public OrbitType getOrbitType() {
        return OrbitType.EQUINOCTIAL;
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return PositionAngleType.MEAN;
    }

    @Override
    public AveragedEquinoctialWithMeanAngle getAveragedElements() {
        return this.averagedElements;
    }

    @Override
    public Orbit toOsculatingOrbit() {
        EquinoctialOrbit orekitOrbit = this.createOrekitOrbit();
        Collection<DSSTForceModel> forceModels = DSST6X0OrbitalState.createForces(this.getHarmonicsProvider());
        SpacecraftState osculatingState = DSSTPropagator.computeOsculatingState(new SpacecraftState(orekitOrbit), null, forceModels);
        return osculatingState.getOrbit();
    }

    private EquinoctialOrbit createOrekitOrbit() {
        return new EquinoctialOrbit(this.averagedElements.getAveragedSemiMajorAxis(), this.averagedElements.getAveragedEquinoctialEx(), this.averagedElements.getAveragedEquinoctialEy(), this.averagedElements.getAveragedHx(), this.averagedElements.getAveragedHy(), this.averagedElements.getAveragedMeanLongitudeArgument(), this.getPositionAngleType(), this.getFrame(), this.getDate(), this.getMu());
    }
}

