/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion.averaging;

import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.analytical.BrouwerLyddanePropagator;
import org.orekit.propagation.conversion.averaging.AbstractHarmonicsBasedOrbitalState;
import org.orekit.propagation.conversion.averaging.elements.AveragedKeplerianWithMeanAngle;
import org.orekit.time.AbsoluteDate;

public class BrouwerLyddaneOrbitalState
extends AbstractHarmonicsBasedOrbitalState {
    private static final double M2 = 0.0;
    private final AveragedKeplerianWithMeanAngle averagedElements;

    public BrouwerLyddaneOrbitalState(AbsoluteDate date, AveragedKeplerianWithMeanAngle elements, Frame frame, UnnormalizedSphericalHarmonicsProvider harmonicsProvider) {
        super(date, frame, harmonicsProvider);
        this.averagedElements = elements;
    }

    @Override
    public OrbitType getOrbitType() {
        return OrbitType.KEPLERIAN;
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return PositionAngleType.MEAN;
    }

    @Override
    public AveragedKeplerianWithMeanAngle getAveragedElements() {
        return this.averagedElements;
    }

    @Override
    public Orbit toOsculatingOrbit() {
        BrouwerLyddanePropagator propagator = this.createPropagator();
        return propagator.propagateOrbit(this.getDate());
    }

    private BrouwerLyddanePropagator createPropagator() {
        KeplerianOrbit orekitOrbit = this.createOrekitOrbit();
        return new BrouwerLyddanePropagator((Orbit)orekitOrbit, this.getHarmonicsProvider(), PropagationType.MEAN, 0.0);
    }

    private KeplerianOrbit createOrekitOrbit() {
        return new KeplerianOrbit(this.averagedElements.getAveragedSemiMajorAxis(), this.averagedElements.getAveragedEccentricity(), this.averagedElements.getAveragedInclination(), this.averagedElements.getAveragedPerigeeArgument(), this.averagedElements.getAveragedRightAscensionOfTheAscendingNode(), this.averagedElements.getAveragedMeanAnomaly(), this.getPositionAngleType(), this.getFrame(), this.getDate(), this.getMu());
    }
}

