/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.List;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.analytical.tle.generation.TleGenerationAlgorithm;
import org.orekit.propagation.conversion.AbstractAnalyticalPropagatorBuilder;
import org.orekit.utils.ParameterDriver;

public class TLEPropagatorBuilder
extends AbstractAnalyticalPropagatorBuilder {
    private final DataContext dataContext;
    private final TLE templateTLE;
    private final TleGenerationAlgorithm generationAlgorithm;

    @DefaultDataContext
    public TLEPropagatorBuilder(TLE templateTLE, PositionAngleType positionAngleType, double positionScale, TleGenerationAlgorithm generationAlgorithm) {
        this(templateTLE, positionAngleType, positionScale, DataContext.getDefault(), generationAlgorithm);
    }

    public TLEPropagatorBuilder(TLE templateTLE, PositionAngleType positionAngleType, double positionScale, DataContext dataContext, TleGenerationAlgorithm generationAlgorithm) {
        this(templateTLE, positionAngleType, positionScale, dataContext, generationAlgorithm, FrameAlignedProvider.of(dataContext.getFrames().getTEME()));
    }

    public TLEPropagatorBuilder(TLE templateTLE, PositionAngleType positionAngleType, double positionScale, DataContext dataContext, TleGenerationAlgorithm generationAlgorithm, AttitudeProvider attitudeProvider) {
        super(TLEPropagator.selectExtrapolator(templateTLE, dataContext.getFrames().getTEME(), attitudeProvider).getInitialState().getOrbit(), positionAngleType, positionScale, false, attitudeProvider, 1000.0);
        this.addSupportedParameters(templateTLE.getParametersDrivers());
        this.templateTLE = templateTLE;
        this.dataContext = dataContext;
        this.generationAlgorithm = generationAlgorithm;
    }

    @Override
    @Deprecated
    public TLEPropagatorBuilder copy() {
        TLEPropagatorBuilder builder = new TLEPropagatorBuilder(this.templateTLE, this.getPositionAngleType(), this.getPositionScale(), this.dataContext, this.generationAlgorithm, this.getAttitudeProvider());
        builder.setMass(this.getMass());
        return builder;
    }

    @Override
    public TLEPropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        Orbit orbit = this.createInitialOrbit();
        SpacecraftState state = new SpacecraftState(orbit);
        FactoryManagedFrame teme = this.dataContext.getFrames().getTEME();
        TLE tle = this.generationAlgorithm.generate(state, this.templateTLE);
        List<ParameterDriver> drivers = this.templateTLE.getParametersDrivers();
        for (int index = 0; index < drivers.size(); ++index) {
            if (!drivers.get(index).isSelected()) continue;
            tle.getParametersDrivers().get(index).setSelected(true);
        }
        TLEPropagator propagator = TLEPropagator.selectExtrapolator(tle, this.getAttitudeProvider(), this.getMass(), teme);
        this.getImpulseManeuvers().forEach(propagator::addEventDetector);
        return propagator;
    }

    public TLE getTemplateTLE() {
        return this.templateTLE;
    }
}

