/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.ode.ODEIntegrator;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.estimation.leastsquares.BatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.forces.maneuvers.ImpulseManeuver;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriversList;

public class NumericalPropagatorBuilder
extends AbstractPropagatorBuilder {
    private final ODEIntegratorBuilder builder;
    private final List<ForceModel> forceModels;
    private final List<ImpulseManeuver> impulseManeuvers;

    public NumericalPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, PositionAngleType positionAngleType, double positionScale) {
        this(referenceOrbit, builder, positionAngleType, positionScale, FrameAlignedProvider.of(referenceOrbit.getFrame()));
    }

    public NumericalPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, PositionAngleType positionAngleType, double positionScale, AttitudeProvider attitudeProvider) {
        super(referenceOrbit, positionAngleType, positionScale, true, attitudeProvider, 1000.0);
        this.builder = builder;
        this.forceModels = new ArrayList<ForceModel>();
        this.impulseManeuvers = new ArrayList<ImpulseManeuver>();
    }

    public void addImpulseManeuver(ImpulseManeuver impulseManeuver) {
        this.impulseManeuvers.add(impulseManeuver);
    }

    public void clearImpulseManeuvers() {
        this.impulseManeuvers.clear();
    }

    @Override
    @Deprecated
    public NumericalPropagatorBuilder copy() {
        NumericalPropagatorBuilder copyBuilder = new NumericalPropagatorBuilder(this.createInitialOrbit(), this.builder, this.getPositionAngleType(), this.getPositionScale(), this.getAttitudeProvider());
        copyBuilder.setMass(this.getMass());
        for (ForceModel model : this.forceModels) {
            copyBuilder.addForceModel(model);
        }
        this.impulseManeuvers.forEach(copyBuilder::addImpulseManeuver);
        return copyBuilder;
    }

    public ODEIntegratorBuilder getIntegratorBuilder() {
        return this.builder;
    }

    public List<ForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    public void addForceModel(ForceModel model) {
        if (model instanceof NewtonianAttraction) {
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, model);
            } else {
                this.forceModels.add(model);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, model);
        } else {
            this.forceModels.add(model);
        }
        this.addSupportedParameters(model.getParametersDrivers());
    }

    @Override
    public NumericalPropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        Orbit orbit = this.createInitialOrbit();
        Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, orbit.getDate(), this.getFrame());
        SpacecraftState state = new SpacecraftState(orbit, attitude, this.getMass());
        NumericalPropagator propagator = new NumericalPropagator((ODEIntegrator)this.builder.buildIntegrator(orbit, this.getOrbitType()), this.getAttitudeProvider());
        propagator.setOrbitType(this.getOrbitType());
        propagator.setPositionAngleType(this.getPositionAngleType());
        if (!this.hasNewtonianAttraction()) {
            this.addForceModel(new NewtonianAttraction(orbit.getMu()));
        }
        for (ForceModel model : this.forceModels) {
            propagator.addForceModel(model);
        }
        this.impulseManeuvers.forEach(propagator::addEventDetector);
        propagator.resetInitialState(state);
        for (AdditionalDerivativesProvider provider : this.getAdditionalDerivativesProviders()) {
            propagator.addAdditionalDerivativesProvider(provider);
        }
        return propagator;
    }

    @Override
    public BatchLSModel buildLeastSquaresModel(PropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new BatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof NewtonianAttraction;
    }
}

