/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.KeplerianPropagator;
import org.orekit.propagation.conversion.AbstractAnalyticalPropagatorBuilder;

public class KeplerianPropagatorBuilder
extends AbstractAnalyticalPropagatorBuilder {
    public KeplerianPropagatorBuilder(Orbit templateOrbit, PositionAngleType positionAngleType, double positionScale) {
        this(templateOrbit, positionAngleType, positionScale, FrameAlignedProvider.of(templateOrbit.getFrame()));
    }

    public KeplerianPropagatorBuilder(Orbit templateOrbit, PositionAngleType positionAngleType, double positionScale, AttitudeProvider attitudeProvider) {
        super(templateOrbit, positionAngleType, positionScale, true, attitudeProvider, 1000.0);
    }

    @Override
    @Deprecated
    public KeplerianPropagatorBuilder copy() {
        KeplerianPropagatorBuilder builder = new KeplerianPropagatorBuilder(this.createInitialOrbit(), this.getPositionAngleType(), this.getPositionScale(), this.getAttitudeProvider());
        builder.setMass(this.getMass());
        return builder;
    }

    @Override
    public Propagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        KeplerianPropagator propagator = new KeplerianPropagator(this.createInitialOrbit(), this.getAttitudeProvider(), this.getMu(), this.getMass());
        this.getImpulseManeuvers().forEach(propagator::addEventDetector);
        return propagator;
    }
}

