/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.ode.AbstractIntegrator;
import org.hipparchus.ode.nonstiff.HighamHall54Integrator;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.AbstractVariableStepIntegratorBuilder;

public class HighamHall54IntegratorBuilder
extends AbstractVariableStepIntegratorBuilder {
    public HighamHall54IntegratorBuilder(double minStep, double maxStep, double dP) {
        super(minStep, maxStep, dP);
    }

    public HighamHall54IntegratorBuilder(double minStep, double maxStep, double dP, double dV) {
        super(minStep, maxStep, dP, dV);
    }

    @Override
    public AbstractIntegrator buildIntegrator(Orbit orbit, OrbitType orbitType) {
        double[][] tol = this.getTolerances(orbit, orbitType);
        return new HighamHall54Integrator(this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

