/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.List;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.BatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.SpacecraftStateInterpolator;
import org.orekit.propagation.StateCovariance;
import org.orekit.propagation.analytical.Ephemeris;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.time.TimeInterpolator;
import org.orekit.time.TimeStampedPair;
import org.orekit.utils.ParameterDriversList;

public class EphemerisPropagatorBuilder
extends AbstractPropagatorBuilder {
    private static final double DEFAULT_SCALE = 10.0;
    private final List<SpacecraftState> states;
    private final List<StateCovariance> covariances;
    private final TimeInterpolator<SpacecraftState> stateInterpolator;
    private final TimeInterpolator<TimeStampedPair<Orbit, StateCovariance>> covarianceInterpolator;
    private final AttitudeProvider provider;

    public EphemerisPropagatorBuilder(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator) {
        this(states, stateInterpolator, states.isEmpty() ? null : new FrameAlignedProvider(states.get(0).getFrame()));
    }

    public EphemerisPropagatorBuilder(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator, AttitudeProvider attitudeProvider) {
        this(states, stateInterpolator, new ArrayList<StateCovariance>(), null, attitudeProvider);
    }

    public EphemerisPropagatorBuilder(List<SpacecraftState> states, int interpolationPoints, double extrapolationThreshold, AttitudeProvider attitudeProvider) {
        this(states, new SpacecraftStateInterpolator(interpolationPoints, extrapolationThreshold, states.get(0).getFrame(), states.get(0).getFrame()), attitudeProvider);
    }

    public EphemerisPropagatorBuilder(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator, List<StateCovariance> covariances, TimeInterpolator<TimeStampedPair<Orbit, StateCovariance>> covarianceInterpolator) {
        this(states, stateInterpolator, covariances, covarianceInterpolator, (AttitudeProvider)(states.isEmpty() ? null : new FrameAlignedProvider(states.get(0).getFrame())));
    }

    public EphemerisPropagatorBuilder(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator, List<StateCovariance> covariances, TimeInterpolator<TimeStampedPair<Orbit, StateCovariance>> covarianceInterpolator, AttitudeProvider attitudeProvider) {
        super(states.get(0).getOrbit(), PositionAngleType.TRUE, 10.0, false, attitudeProvider);
        this.deselectDynamicParameters();
        Ephemeris.checkInputConsistency(states, stateInterpolator, covariances, covarianceInterpolator);
        this.states = states;
        this.stateInterpolator = stateInterpolator;
        this.covariances = covariances == null ? new ArrayList() : covariances;
        this.covarianceInterpolator = covarianceInterpolator;
        this.provider = attitudeProvider;
    }

    @Override
    @Deprecated
    public EphemerisPropagatorBuilder copy() {
        return new EphemerisPropagatorBuilder(this.states, this.stateInterpolator, this.covariances, this.covarianceInterpolator, this.provider);
    }

    @Override
    public Propagator buildPropagator(double[] normalizedParameters) {
        if (!this.covariances.isEmpty() && this.covarianceInterpolator != null) {
            return new Ephemeris(this.states, this.stateInterpolator, this.covariances, this.covarianceInterpolator, this.provider);
        }
        return new Ephemeris(this.states, this.stateInterpolator, this.provider);
    }

    @Override
    public AbstractBatchLSModel buildLeastSquaresModel(PropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new BatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer);
    }
}

