/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.analytical.EcksteinHechlerPropagator;
import org.orekit.propagation.conversion.AbstractAnalyticalPropagatorBuilder;

public class EcksteinHechlerPropagatorBuilder
extends AbstractAnalyticalPropagatorBuilder {
    private final UnnormalizedSphericalHarmonicsProvider provider;

    public EcksteinHechlerPropagatorBuilder(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngleType positionAngleType, double positionScale) {
        this(templateOrbit, provider, positionAngleType, positionScale, FrameAlignedProvider.of(templateOrbit.getFrame()));
    }

    public EcksteinHechlerPropagatorBuilder(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngleType positionAngleType, double positionScale, AttitudeProvider attitudeProvider) {
        super(EcksteinHechlerPropagatorBuilder.overrideMu(templateOrbit, provider, positionAngleType), positionAngleType, positionScale, true, attitudeProvider, 1000.0);
        this.provider = provider;
    }

    public EcksteinHechlerPropagatorBuilder(Orbit templateOrbit, double referenceRadius, double mu, TideSystem tideSystem, double c20, double c30, double c40, double c50, double c60, OrbitType orbitType, PositionAngleType positionAngleType, double positionScale) {
        this(templateOrbit, GravityFieldFactory.getUnnormalizedProvider(referenceRadius, mu, tideSystem, new double[][]{{0.0}, {0.0}, {c20}, {c30}, {c40}, {c50}, {c60}}, new double[][]{{0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}}), positionAngleType, positionScale);
    }

    private static Orbit overrideMu(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngleType positionAngleType) {
        double[] parameters = new double[6];
        double[] parametersDot = templateOrbit.hasDerivatives() ? new double[6] : null;
        templateOrbit.getType().mapOrbitToArray(templateOrbit, positionAngleType, parameters, parametersDot);
        return templateOrbit.getType().mapArrayToOrbit(parameters, parametersDot, positionAngleType, templateOrbit.getDate(), provider.getMu(), templateOrbit.getFrame());
    }

    @Override
    public Propagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        EcksteinHechlerPropagator propagator = new EcksteinHechlerPropagator(this.createInitialOrbit(), this.getAttitudeProvider(), this.getMass(), this.provider);
        this.getImpulseManeuvers().forEach(propagator::addEventDetector);
        return propagator;
    }

    @Override
    @Deprecated
    public EcksteinHechlerPropagatorBuilder copy() {
        EcksteinHechlerPropagatorBuilder builder = new EcksteinHechlerPropagatorBuilder(this.createInitialOrbit(), this.provider, this.getPositionAngleType(), this.getPositionScale(), this.getAttitudeProvider());
        builder.setMass(this.getMass());
        return builder;
    }
}

