/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.AbstractFieldIntegrator;
import org.hipparchus.ode.nonstiff.DormandPrince54FieldIntegrator;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.AbstractVariableStepFieldIntegratorBuilder;

public class DormandPrince54FieldIntegratorBuilder<T extends CalculusFieldElement<T>>
extends AbstractVariableStepFieldIntegratorBuilder<T> {
    public DormandPrince54FieldIntegratorBuilder(double minStep, double maxStep, double dP) {
        super(minStep, maxStep, dP);
    }

    public DormandPrince54FieldIntegratorBuilder(double minStep, double maxStep, double dP, double dV) {
        super(minStep, maxStep, dP, dV);
    }

    @Override
    public AbstractFieldIntegrator<T> buildIntegrator(Field<T> field, Orbit orbit, OrbitType orbitType) {
        double[][] tol = this.getTolerances(orbit, orbitType);
        return new DormandPrince54FieldIntegrator(field, this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

