/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.Collections;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.TideSystem;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.analytical.BrouwerLyddanePropagator;
import org.orekit.propagation.conversion.AbstractAnalyticalPropagatorBuilder;
import org.orekit.utils.ParameterDriver;

public class BrouwerLyddanePropagatorBuilder
extends AbstractAnalyticalPropagatorBuilder {
    private static final double SCALE = FastMath.scalb((double)1.0, (int)-32);
    private final UnnormalizedSphericalHarmonicsProvider provider;

    public BrouwerLyddanePropagatorBuilder(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngleType positionAngleType, double positionScale, double M2) {
        this(templateOrbit, provider, positionAngleType, positionScale, FrameAlignedProvider.of(templateOrbit.getFrame()), M2);
    }

    public BrouwerLyddanePropagatorBuilder(Orbit templateOrbit, double referenceRadius, double mu, TideSystem tideSystem, double c20, double c30, double c40, double c50, OrbitType orbitType, PositionAngleType positionAngleType, double positionScale, double M2) {
        this(templateOrbit, GravityFieldFactory.getUnnormalizedProvider(referenceRadius, mu, tideSystem, new double[][]{{0.0}, {0.0}, {c20}, {c30}, {c40}, {c50}}, new double[][]{{0.0}, {0.0}, {0.0}, {0.0}, {0.0}, {0.0}}), positionAngleType, positionScale, M2);
    }

    public BrouwerLyddanePropagatorBuilder(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngleType positionAngleType, double positionScale, AttitudeProvider attitudeProvider, double M2) {
        super(BrouwerLyddanePropagatorBuilder.overrideMu(templateOrbit, provider, positionAngleType), positionAngleType, positionScale, true, attitudeProvider, 1000.0);
        this.provider = provider;
        ParameterDriver M2Driver = new ParameterDriver("M2", M2, SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.addSupportedParameters(Collections.singletonList(M2Driver));
    }

    private static Orbit overrideMu(Orbit templateOrbit, UnnormalizedSphericalHarmonicsProvider provider, PositionAngleType positionAngleType) {
        double[] parameters = new double[6];
        double[] parametersDot = templateOrbit.hasDerivatives() ? new double[6] : null;
        templateOrbit.getType().mapOrbitToArray(templateOrbit, positionAngleType, parameters, parametersDot);
        return templateOrbit.getType().mapArrayToOrbit(parameters, parametersDot, positionAngleType, templateOrbit.getDate(), provider.getMu(), templateOrbit.getFrame());
    }

    @Override
    @Deprecated
    public BrouwerLyddanePropagatorBuilder copy() {
        double m2 = 0.0;
        for (ParameterDriver parameterDriver : this.getPropagationParametersDrivers().getDrivers()) {
            if (!"M2".equals(parameterDriver.getName())) continue;
            m2 = parameterDriver.getValue();
        }
        BrouwerLyddanePropagatorBuilder builder = new BrouwerLyddanePropagatorBuilder(this.createInitialOrbit(), this.provider, this.getPositionAngleType(), this.getPositionScale(), this.getAttitudeProvider(), m2);
        builder.setMass(this.getMass());
        return builder;
    }

    @Override
    public BrouwerLyddanePropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        double newM2 = 0.0;
        boolean isSelected = false;
        for (ParameterDriver parameterDriver : this.getPropagationParametersDrivers().getDrivers()) {
            if (!"M2".equals(parameterDriver.getName())) continue;
            newM2 = parameterDriver.getValue();
            isSelected = parameterDriver.isSelected();
        }
        BrouwerLyddanePropagator propagator = new BrouwerLyddanePropagator(this.createInitialOrbit(), this.getAttitudeProvider(), this.getMass(), this.provider, newM2);
        propagator.getParametersDrivers().get(0).setSelected(isSelected);
        this.getImpulseManeuvers().forEach(propagator::addEventDetector);
        return propagator;
    }

    public double getM2Value() {
        double m2 = 0.0;
        for (ParameterDriver parameterDriver : this.getPropagationParametersDrivers().getDrivers()) {
            if (!"M2".equals(parameterDriver.getName())) continue;
            m2 = parameterDriver.getValue();
        }
        return m2;
    }
}

