/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.ode.AbstractIntegrator;
import org.hipparchus.ode.nonstiff.AdamsMoultonIntegrator;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.AbstractVariableStepIntegratorBuilder;

public class AdamsMoultonIntegratorBuilder
extends AbstractVariableStepIntegratorBuilder {
    private final int nSteps;

    public AdamsMoultonIntegratorBuilder(int nSteps, double minStep, double maxStep, double dP) {
        super(minStep, maxStep, dP);
        this.nSteps = nSteps;
    }

    public AdamsMoultonIntegratorBuilder(int nSteps, double minStep, double maxStep, double dP, double dV) {
        super(minStep, maxStep, dP, dV);
        this.nSteps = nSteps;
    }

    @Override
    public AbstractIntegrator buildIntegrator(Orbit orbit, OrbitType orbitType) {
        double[][] tol = this.getTolerances(orbit, orbitType);
        return new AdamsMoultonIntegrator(this.nSteps, this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

