/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.AbstractFieldIntegrator;
import org.hipparchus.ode.nonstiff.AdamsBashforthFieldIntegrator;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.AbstractLimitedVariableStepFieldIntegratorBuilder;

public class AdamsBashforthFieldIntegratorBuilder<T extends CalculusFieldElement<T>>
extends AbstractLimitedVariableStepFieldIntegratorBuilder<T> {
    public AdamsBashforthFieldIntegratorBuilder(int nSteps, double minStep, double maxStep, double dP) {
        super(nSteps, minStep, maxStep, dP);
    }

    public AdamsBashforthFieldIntegratorBuilder(int nSteps, double minStep, double maxStep, double dP, double dV) {
        super(nSteps, minStep, maxStep, dP, dV);
    }

    @Override
    public AbstractFieldIntegrator<T> buildIntegrator(Field<T> field, Orbit orbit, OrbitType orbitType) {
        double[][] tol = this.getTolerances(orbit, orbitType);
        return new AdamsBashforthFieldIntegrator(field, this.nSteps, this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

