/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;

public abstract class AbstractVariableStepIntegratorBuilder
implements ODEIntegratorBuilder {
    protected final double minStep;
    protected final double maxStep;
    protected final double dP;
    protected final double dV;

    protected AbstractVariableStepIntegratorBuilder(double minStep, double maxStep, double dP) {
        this(minStep, maxStep, dP, Double.NaN);
    }

    protected AbstractVariableStepIntegratorBuilder(double minStep, double maxStep, double dP, double dV) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.dP = dP;
        this.dV = dV;
    }

    protected double[][] getTolerances(Orbit orbit, OrbitType orbitType) {
        if (Double.isNaN(this.dV)) {
            return NumericalPropagator.tolerances(this.dP, orbit, orbitType);
        }
        return NumericalPropagator.tolerances(this.dP, this.dV, orbit, orbitType);
    }
}

