/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.CalculusFieldElement;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.AbstractFieldIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;

public abstract class AbstractVariableStepFieldIntegratorBuilder<T extends CalculusFieldElement<T>>
extends AbstractFieldIntegratorBuilder<T> {
    protected final double minStep;
    protected final double maxStep;
    protected final double dP;
    protected final double dV;

    AbstractVariableStepFieldIntegratorBuilder(double minStep, double maxStep, double dP) {
        this(minStep, maxStep, dP, Double.NaN);
    }

    AbstractVariableStepFieldIntegratorBuilder(double minStep, double maxStep, double dP, double dV) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.dP = dP;
        this.dV = dV;
    }

    protected double[][] getTolerances(Orbit orbit, OrbitType orbitType) {
        if (Double.isNaN(this.dV)) {
            return NumericalPropagator.tolerances(this.dP, orbit, orbitType);
        }
        return NumericalPropagator.tolerances(this.dP, this.dV, orbit, orbitType);
    }
}

