/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeSpanMap;

public abstract class AbstractPropagatorBuilder
implements PropagatorBuilder {
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private AbsoluteDate initialOrbitDate;
    private final Frame frame;
    private double mu;
    private double mass;
    private final ParameterDriversList orbitalDrivers;
    private ParameterDriversList propagationDrivers;
    private final OrbitType orbitType;
    private final PositionAngleType positionAngleType;
    private final double positionScale;
    private AttitudeProvider attitudeProvider;
    private List<AdditionalDerivativesProvider> additionalDerivativesProviders;

    protected AbstractPropagatorBuilder(Orbit templateOrbit, PositionAngleType positionAngleType, double positionScale, boolean addDriverForCentralAttraction) {
        this(templateOrbit, positionAngleType, positionScale, addDriverForCentralAttraction, new FrameAlignedProvider(templateOrbit.getFrame()), 1000.0);
    }

    protected AbstractPropagatorBuilder(Orbit templateOrbit, PositionAngleType positionAngleType, double positionScale, boolean addDriverForCentralAttraction, AttitudeProvider attitudeProvider) {
        this(templateOrbit, positionAngleType, positionScale, addDriverForCentralAttraction, attitudeProvider, 1000.0);
    }

    protected AbstractPropagatorBuilder(Orbit templateOrbit, PositionAngleType positionAngleType, double positionScale, boolean addDriverForCentralAttraction, AttitudeProvider attitudeProvider, double initialMass) {
        this.initialOrbitDate = templateOrbit.getDate();
        this.frame = templateOrbit.getFrame();
        this.mu = templateOrbit.getMu();
        this.propagationDrivers = new ParameterDriversList();
        this.orbitType = templateOrbit.getType();
        this.positionAngleType = positionAngleType;
        this.positionScale = positionScale;
        this.orbitalDrivers = this.orbitType.getDrivers(positionScale, templateOrbit, positionAngleType);
        this.attitudeProvider = attitudeProvider;
        this.mass = initialMass;
        for (ParameterDriversList.DelegatingDriver driver : this.orbitalDrivers.getDrivers()) {
            driver.setSelected(true);
        }
        this.additionalDerivativesProviders = new ArrayList<AdditionalDerivativesProvider>();
        if (addDriverForCentralAttraction) {
            ParameterDriver muDriver = new ParameterDriver("central attraction coefficient", this.mu, MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
            muDriver.addObserver(new ParameterObserver(){

                @Override
                public void valueChanged(double previousValue, ParameterDriver driver, AbsoluteDate date) {
                    AbstractPropagatorBuilder.this.mu = driver.getValue();
                }

                @Override
                public void valueSpanMapChanged(TimeSpanMap<Double> previousValueSpanMap, ParameterDriver driver) {
                    AbstractPropagatorBuilder.this.mu = driver.getValue();
                }
            });
            this.propagationDrivers.add(muDriver);
        }
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    @Override
    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return this.positionAngleType;
    }

    @Override
    public AbsoluteDate getInitialOrbitDate() {
        return this.initialOrbitDate;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public ParameterDriversList getOrbitalParametersDrivers() {
        return this.orbitalDrivers;
    }

    @Override
    public ParameterDriversList getPropagationParametersDrivers() {
        return this.propagationDrivers;
    }

    public AbstractPropagatorBuilder clone() {
        try {
            return (AbstractPropagatorBuilder)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new OrekitException((Localizable)OrekitMessages.PROPAGATOR_BUILDER_NOT_CLONEABLE, new Object[0]);
        }
    }

    public AttitudeProvider getAttitudeProvider() {
        return this.attitudeProvider;
    }

    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attitudeProvider = attitudeProvider;
    }

    public double getPositionScale() {
        return this.positionScale;
    }

    @Override
    public double getMu() {
        return this.mu;
    }

    private int getNbValuesForSelected() {
        int count = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            count += parameterDriver.getNbOfValues();
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            count += parameterDriver.getNbOfValues();
        }
        return count;
    }

    @Override
    public double[] getSelectedNormalizedParameters() {
        int spanNumber;
        double[] selected = new double[this.getNbValuesForSelected()];
        int index = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            for (spanNumber = 0; spanNumber < parameterDriver.getNbOfValues(); ++spanNumber) {
                selected[index++] = parameterDriver.getNormalizedValue(AbsoluteDate.ARBITRARY_EPOCH);
            }
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            for (spanNumber = 0; spanNumber < parameterDriver.getNbOfValues(); ++spanNumber) {
                selected[index++] = parameterDriver.getNormalizedValue(AbsoluteDate.ARBITRARY_EPOCH);
            }
        }
        return selected;
    }

    protected Orbit createInitialOrbit() {
        double[] unNormalized = new double[this.orbitalDrivers.getNbParams()];
        for (int i = 0; i < unNormalized.length; ++i) {
            unNormalized[i] = this.orbitalDrivers.getDrivers().get(i).getValue(this.initialOrbitDate);
        }
        return this.getOrbitType().mapArrayToOrbit(unNormalized, null, this.positionAngleType, this.initialOrbitDate, this.mu, this.frame);
    }

    protected void setParameters(double[] normalizedParameters) {
        TimeSpanMap.Span<Double> span;
        if (normalizedParameters.length != this.getNbValuesForSelected()) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, normalizedParameters.length, this.getNbValuesForSelected());
        }
        int index = 0;
        for (ParameterDriver parameterDriver : this.orbitalDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            if (parameterDriver.getNbOfValues() == 1) {
                parameterDriver.setNormalizedValue(normalizedParameters[index++], null);
                continue;
            }
            for (span = parameterDriver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDriver.setNormalizedValue(normalizedParameters[index++], span.getStart());
            }
        }
        for (ParameterDriver parameterDriver : this.propagationDrivers.getDrivers()) {
            if (!parameterDriver.isSelected()) continue;
            for (span = parameterDriver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterDriver.setNormalizedValue(normalizedParameters[index++], span.getStart());
            }
        }
    }

    protected void addSupportedParameters(List<ParameterDriver> drivers) {
        drivers.forEach(this.propagationDrivers::add);
        this.propagationDrivers.sort();
    }

    @Override
    public void resetOrbit(Orbit newOrbit) {
        double[] orbitArray = new double[6];
        this.orbitType.mapOrbitToArray(newOrbit, this.getPositionAngleType(), orbitArray, null);
        List<ParameterDriversList.DelegatingDriver> orbitalDriversList = this.getOrbitalParametersDrivers().getDrivers();
        int i = 0;
        for (ParameterDriversList.DelegatingDriver driver : orbitalDriversList) {
            driver.setReferenceValue(orbitArray[i]);
            driver.setValue(orbitArray[i++], newOrbit.getDate());
        }
        this.initialOrbitDate = newOrbit.getDate();
    }

    public void addAdditionalDerivativesProvider(AdditionalDerivativesProvider provider) {
        this.additionalDerivativesProviders.add(provider);
    }

    protected List<AdditionalDerivativesProvider> getAdditionalDerivativesProviders() {
        return this.additionalDerivativesProviders;
    }

    public void deselectDynamicParameters() {
        for (ParameterDriver parameterDriver : this.getPropagationParametersDrivers().getDrivers()) {
            parameterDriver.setSelected(false);
        }
        for (ParameterDriver parameterDriver : this.getOrbitalParametersDrivers().getDrivers()) {
            parameterDriver.setSelected(false);
        }
    }
}

