/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.orekit.propagation.conversion.AbstractFieldIntegratorBuilder;

public abstract class AbstractFixedStepFieldIntegratorBuilder<T extends CalculusFieldElement<T>>
extends AbstractFieldIntegratorBuilder<T> {
    private double step;
    private T fieldStep;

    AbstractFixedStepFieldIntegratorBuilder(double step) {
        this.checkStep(step);
        this.step = step;
    }

    AbstractFixedStepFieldIntegratorBuilder(T step) {
        this.checkStep(step.getReal());
        this.fieldStep = step;
    }

    protected void checkStep(double stepToCheck) {
        if (stepToCheck == 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.ZERO_NOT_ALLOWED, new Object[]{stepToCheck});
        }
    }

    protected T getFieldStep(Field<T> field) {
        return (T)(this.fieldStep != null ? this.fieldStep : (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(this.step));
    }
}

