/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.List;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.estimation.leastsquares.AbstractBatchLSModel;
import org.orekit.estimation.leastsquares.BatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.forces.maneuvers.ImpulseManeuver;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.utils.ParameterDriversList;

public abstract class AbstractAnalyticalPropagatorBuilder
extends AbstractPropagatorBuilder {
    private final List<ImpulseManeuver> impulseManeuvers = new ArrayList<ImpulseManeuver>();

    protected AbstractAnalyticalPropagatorBuilder(Orbit templateOrbit, PositionAngleType positionAngleType, double positionScale, boolean addDriverForCentralAttraction, AttitudeProvider attitudeProvider, double initialMass) {
        super(templateOrbit, positionAngleType, positionScale, addDriverForCentralAttraction, attitudeProvider, initialMass);
    }

    protected List<ImpulseManeuver> getImpulseManeuvers() {
        return new ArrayList<ImpulseManeuver>(this.impulseManeuvers);
    }

    public void addImpulseManeuver(ImpulseManeuver impulseManeuver) {
        this.impulseManeuvers.add(impulseManeuver);
    }

    public void clearImpulseManeuvers() {
        this.impulseManeuvers.clear();
    }

    @Override
    public AbstractBatchLSModel buildLeastSquaresModel(PropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new BatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer);
    }
}

