/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle.generation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;

public final class TleGenerationUtil {
    private TleGenerationUtil() {
    }

    public static TLE newTLE(KeplerianOrbit keplerianOrbit, TLE templateTLE, double bStar, TimeScale utc) {
        double meanMotion = keplerianOrbit.getKeplerianMeanMotion();
        double e = keplerianOrbit.getE();
        double i = keplerianOrbit.getI();
        double raan = keplerianOrbit.getRightAscensionOfAscendingNode();
        double pa = keplerianOrbit.getPerigeeArgument();
        double meanAnomaly = keplerianOrbit.getMeanAnomaly();
        AbsoluteDate epoch = keplerianOrbit.getDate();
        int satelliteNumber = templateTLE.getSatelliteNumber();
        char classification = templateTLE.getClassification();
        int launchYear = templateTLE.getLaunchYear();
        int launchNumber = templateTLE.getLaunchNumber();
        String launchPiece = templateTLE.getLaunchPiece();
        int ephemerisType = templateTLE.getEphemerisType();
        int elementNumber = templateTLE.getElementNumber();
        int revolutionNumberAtEpoch = templateTLE.getRevolutionNumberAtEpoch();
        double dt = epoch.durationFrom(templateTLE.getDate());
        int newRevolutionNumberAtEpoch = (int)((double)revolutionNumberAtEpoch + FastMath.floor((double)((MathUtils.normalizeAngle((double)meanAnomaly, (double)Math.PI) + dt * meanMotion) / (Math.PI * 2))));
        double meanMotionFirstDerivative = templateTLE.getMeanMotionFirstDerivative();
        double meanMotionSecondDerivative = templateTLE.getMeanMotionSecondDerivative();
        return new TLE(satelliteNumber, classification, launchYear, launchNumber, launchPiece, ephemerisType, elementNumber, epoch, meanMotion, meanMotionFirstDerivative, meanMotionSecondDerivative, e, i, pa, raan, meanAnomaly, newRevolutionNumberAtEpoch, bStar, utc);
    }

    public static <T extends CalculusFieldElement<T>> FieldTLE<T> newTLE(FieldKeplerianOrbit<T> keplerianOrbit, FieldTLE<T> templateTLE, T bStar, TimeScale utc) {
        Object meanMotion = keplerianOrbit.getKeplerianMeanMotion();
        T e = keplerianOrbit.getE();
        T i = keplerianOrbit.getI();
        T raan = keplerianOrbit.getRightAscensionOfAscendingNode();
        T pa = keplerianOrbit.getPerigeeArgument();
        T meanAnomaly = keplerianOrbit.getMeanAnomaly();
        FieldAbsoluteDate<T> epoch = keplerianOrbit.getDate();
        int satelliteNumber = templateTLE.getSatelliteNumber();
        char classification = templateTLE.getClassification();
        int launchYear = templateTLE.getLaunchYear();
        int launchNumber = templateTLE.getLaunchNumber();
        String launchPiece = templateTLE.getLaunchPiece();
        int ephemerisType = templateTLE.getEphemerisType();
        int elementNumber = templateTLE.getElementNumber();
        int revolutionNumberAtEpoch = templateTLE.getRevolutionNumberAtEpoch();
        Object dt = epoch.durationFrom(templateTLE.getDate());
        int newRevolutionNumberAtEpoch = (int)((double)revolutionNumberAtEpoch + FastMath.floor((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)MathUtils.normalizeAngle(meanAnomaly, (CalculusFieldElement)((CalculusFieldElement)e.getPi())).add((FieldElement)((CalculusFieldElement)dt.multiply(meanMotion)))).divide(Math.PI * 2))).getReal());
        T meanMotionFirstDerivative = templateTLE.getMeanMotionFirstDerivative();
        T meanMotionSecondDerivative = templateTLE.getMeanMotionSecondDerivative();
        return new FieldTLE(satelliteNumber, classification, launchYear, launchNumber, launchPiece, ephemerisType, elementNumber, epoch, meanMotion, meanMotionFirstDerivative, meanMotionSecondDerivative, e, i, pa, raan, meanAnomaly, newRevolutionNumberAtEpoch, bStar.getReal(), utc);
    }
}

