/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle.generation;

import java.util.function.UnaryOperator;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.DiagonalMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresBuilder;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LevenbergMarquardtOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.util.Pair;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.propagation.analytical.tle.FieldTLEPropagator;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.analytical.tle.generation.TleGenerationAlgorithm;
import org.orekit.propagation.analytical.tle.generation.TleGenerationUtil;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;

public class LeastSquaresTleGenerationAlgorithm
implements TleGenerationAlgorithm {
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    private final TimeScale utc;
    private final Frame teme;
    private final int maxIterations;
    private double rms;

    @DefaultDataContext
    public LeastSquaresTleGenerationAlgorithm() {
        this(1000);
    }

    @DefaultDataContext
    public LeastSquaresTleGenerationAlgorithm(int maxIterations) {
        this(maxIterations, DataContext.getDefault().getTimeScales().getUTC(), DataContext.getDefault().getFrames().getTEME());
    }

    public LeastSquaresTleGenerationAlgorithm(int maxIterations, TimeScale utc, Frame teme) {
        this.maxIterations = maxIterations;
        this.utc = utc;
        this.teme = teme;
        this.rms = Double.MAX_VALUE;
    }

    @Override
    public TLE generate(SpacecraftState state, TLE templateTLE) {
        AbsoluteDate epoch = state.getDate();
        RealVector stateVector = MatrixUtils.createRealVector((int)6);
        Vector3D position = state.getPVCoordinates().getPosition();
        Vector3D velocity = state.getPVCoordinates().getVelocity();
        stateVector.setEntry(0, position.getX());
        stateVector.setEntry(1, position.getY());
        stateVector.setEntry(2, position.getZ());
        stateVector.setEntry(3, velocity.getX());
        stateVector.setEntry(4, velocity.getY());
        stateVector.setEntry(5, velocity.getZ());
        RealVector startState = MatrixUtils.createRealVector((int)7);
        startState.setSubVector(0, stateVector.getSubVector(0, 6));
        double[] weights = new double[6];
        double velocityWeight = state.getPVCoordinates().getVelocity().getNorm() * state.getPosition().getNormSq() / state.getMu();
        for (int i = 0; i < 3; ++i) {
            weights[i] = 1.0;
            weights[i + 3] = velocityWeight;
        }
        double dt = state.getDate().durationFrom(templateTLE.getDate());
        LeastSquaresProblem problem = new LeastSquaresBuilder().maxIterations(this.maxIterations).maxEvaluations(this.maxIterations).model((MultivariateJacobianFunction)new ObjectiveFunction(templateTLE, dt)).target(stateVector).weight((RealMatrix)new DiagonalMatrix(weights)).start(startState).build();
        LevenbergMarquardtOptimizer optimizer = new LevenbergMarquardtOptimizer();
        LeastSquaresOptimizer.Optimum optimum = optimizer.optimize(problem);
        this.rms = optimum.getRMS();
        Vector3D positionEstimated = new Vector3D(optimum.getPoint().getSubVector(0, 3).toArray());
        Vector3D velocityEstimated = new Vector3D(optimum.getPoint().getSubVector(3, 3).toArray());
        PVCoordinates pvCoordinates = new PVCoordinates(positionEstimated, velocityEstimated);
        KeplerianOrbit orbit = new KeplerianOrbit(pvCoordinates, this.teme, epoch, state.getMu());
        TLE generated = TleGenerationUtil.newTLE(orbit, templateTLE, templateTLE.getBStar(), this.utc);
        for (ParameterDriver templateDrivers : templateTLE.getParametersDrivers()) {
            if (!templateDrivers.isSelected()) continue;
            generated.getParameterDriver(templateDrivers.getName()).setSelected(true);
        }
        return generated;
    }

    public double getRms() {
        return this.rms;
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTLE<T> generate(FieldSpacecraftState<T> state, FieldTLE<T> templateTLE) {
        throw new UnsupportedOperationException();
    }

    private class ObjectiveFunction
    implements MultivariateJacobianFunction {
        private final FieldTLE<Gradient> templateTLE;
        private final double dt;

        ObjectiveFunction(TLE templateTLE, double dt) {
            this.dt = dt;
            GradientField field = GradientField.getField((int)7);
            this.templateTLE = new FieldTLE(field, templateTLE.getLine1(), templateTLE.getLine2(), LeastSquaresTleGenerationAlgorithm.this.utc);
        }

        public Pair<RealVector, RealMatrix> value(RealVector point) {
            RealVector objectiveOscState = MatrixUtils.createRealVector((int)6);
            RealMatrix objectiveJacobian = MatrixUtils.createRealMatrix((int)6, (int)7);
            this.getTransformedAndJacobian(state -> this.meanStateToPV((FieldVector<Gradient>)state), point, objectiveOscState, objectiveJacobian);
            return new Pair((Object)objectiveOscState, (Object)objectiveJacobian);
        }

        private void getTransformedAndJacobian(UnaryOperator<FieldVector<Gradient>> operator, RealVector state, RealVector transformed, RealMatrix jacobian) {
            int stateDim = state.getDimension();
            GradientField field = GradientField.getField((int)stateDim);
            FieldVector fieldState = MatrixUtils.createFieldVector((Field)field, (int)stateDim);
            for (int i = 0; i < stateDim; ++i) {
                fieldState.setEntry(i, (FieldElement)Gradient.variable((int)stateDim, (int)i, (double)state.getEntry(i)));
            }
            FieldVector fieldTransformed = (FieldVector)operator.apply(fieldState);
            int outDim = fieldTransformed.getDimension();
            for (int i = 0; i < outDim; ++i) {
                transformed.setEntry(i, ((Gradient)fieldTransformed.getEntry(i)).getReal());
                jacobian.setRow(i, ((Gradient)fieldTransformed.getEntry(i)).getGradient());
            }
        }

        private FieldVector<Gradient> meanStateToPV(FieldVector<Gradient> state) {
            FieldAbsoluteDate<Gradient> epoch = this.templateTLE.getDate();
            Gradient[] bStar = (Gradient[])state.getSubVector(6, 1).toArray();
            Field<Gradient> field = epoch.getField();
            FieldVector3D position = new FieldVector3D((CalculusFieldElement[])((Gradient[])state.getSubVector(0, 3).toArray()));
            FieldVector3D velocity = new FieldVector3D((CalculusFieldElement[])((Gradient[])state.getSubVector(3, 3).toArray()));
            FieldPVCoordinates pvCoordinates = new FieldPVCoordinates(position, velocity);
            FieldKeplerianOrbit<Gradient> orbit = new FieldKeplerianOrbit<Gradient>(pvCoordinates, LeastSquaresTleGenerationAlgorithm.this.teme, epoch, ((Gradient)field.getZero()).newInstance(TLEPropagator.getMU()));
            FieldTLE<Gradient> tle = TleGenerationUtil.newTLE(orbit, this.templateTLE, bStar[0], LeastSquaresTleGenerationAlgorithm.this.utc);
            FieldPVCoordinates propagatedCoordinates = FieldTLEPropagator.selectExtrapolator(tle, (Frame)LeastSquaresTleGenerationAlgorithm.this.teme, (CalculusFieldElement[])bStar).getPVCoordinates((FieldAbsoluteDate)epoch.shiftedBy(this.dt), (CalculusFieldElement[])bStar);
            FieldVector osculating = MatrixUtils.createFieldVector(field, (int)6);
            osculating.setEntry(0, (FieldElement)((Gradient)propagatedCoordinates.getPosition().getX()));
            osculating.setEntry(1, (FieldElement)((Gradient)propagatedCoordinates.getPosition().getY()));
            osculating.setEntry(2, (FieldElement)((Gradient)propagatedCoordinates.getPosition().getZ()));
            osculating.setEntry(3, (FieldElement)((Gradient)propagatedCoordinates.getVelocity().getX()));
            osculating.setEntry(4, (FieldElement)((Gradient)propagatedCoordinates.getVelocity().getY()));
            osculating.setEntry(5, (FieldElement)((Gradient)propagatedCoordinates.getVelocity().getZ()));
            return osculating;
        }
    }
}

