/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle.generation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.propagation.analytical.tle.FieldTLEPropagator;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.analytical.tle.generation.TleGenerationAlgorithm;
import org.orekit.propagation.analytical.tle.generation.TleGenerationUtil;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;

public class FixedPointTleGenerationAlgorithm
implements TleGenerationAlgorithm {
    public static final double EPSILON_DEFAULT = 1.0E-10;
    public static final int MAX_ITERATIONS_DEFAULT = 100;
    public static final double SCALE_DEFAULT = 1.0;
    private final double epsilon;
    private final int maxIterations;
    private final double scale;
    private final TimeScale utc;
    private final Frame teme;

    @DefaultDataContext
    public FixedPointTleGenerationAlgorithm() {
        this(1.0E-10, 100, 1.0);
    }

    @DefaultDataContext
    public FixedPointTleGenerationAlgorithm(double epsilon, int maxIterations, double scale) {
        this(epsilon, maxIterations, scale, DataContext.getDefault().getTimeScales().getUTC(), DataContext.getDefault().getFrames().getTEME());
    }

    public FixedPointTleGenerationAlgorithm(double epsilon, int maxIterations, double scale, TimeScale utc, Frame teme) {
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
        this.scale = scale;
        this.utc = utc;
        this.teme = teme;
    }

    @Override
    public TLE generate(SpacecraftState state, TLE templateTLE) {
        AbsoluteDate epoch = state.getDate();
        EquinoctialOrbit equinoctialOrbit = this.convert(state.getOrbit());
        double sma = equinoctialOrbit.getA();
        double ex = equinoctialOrbit.getEquinoctialEx();
        double ey = equinoctialOrbit.getEquinoctialEy();
        double hx = equinoctialOrbit.getHx();
        double hy = equinoctialOrbit.getHy();
        double lv = equinoctialOrbit.getLv();
        KeplerianOrbit keplerianOrbit = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(equinoctialOrbit);
        TLE current = TleGenerationUtil.newTLE(keplerianOrbit, templateTLE, templateTLE.getBStar(epoch), this.utc);
        double thrA = this.epsilon * (1.0 + sma);
        double thrE = this.epsilon * (1.0 + FastMath.hypot((double)ex, (double)ey));
        double thrH = this.epsilon * (1.0 + FastMath.hypot((double)hx, (double)hy));
        double thrV = this.epsilon * Math.PI;
        int k = 0;
        while (k++ < this.maxIterations) {
            TLEPropagator propagator = TLEPropagator.selectExtrapolator(current, new FrameAlignedProvider(Rotation.IDENTITY, this.teme), state.getMass(), this.teme);
            Orbit recoveredOrbit = propagator.getInitialState().getOrbit();
            EquinoctialOrbit recoveredEquiOrbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(recoveredOrbit);
            double deltaSma = equinoctialOrbit.getA() - recoveredEquiOrbit.getA();
            double deltaEx = equinoctialOrbit.getEquinoctialEx() - recoveredEquiOrbit.getEquinoctialEx();
            double deltaEy = equinoctialOrbit.getEquinoctialEy() - recoveredEquiOrbit.getEquinoctialEy();
            double deltaHx = equinoctialOrbit.getHx() - recoveredEquiOrbit.getHx();
            double deltaHy = equinoctialOrbit.getHy() - recoveredEquiOrbit.getHy();
            double deltaLv = MathUtils.normalizeAngle((double)(equinoctialOrbit.getLv() - recoveredEquiOrbit.getLv()), (double)0.0);
            if (FastMath.abs((double)deltaSma) < thrA && FastMath.abs((double)deltaEx) < thrE && FastMath.abs((double)deltaEy) < thrE && FastMath.abs((double)deltaHx) < thrH && FastMath.abs((double)deltaHy) < thrH && FastMath.abs((double)deltaLv) < thrV) {
                for (ParameterDriver templateDrivers : templateTLE.getParametersDrivers()) {
                    if (!templateDrivers.isSelected()) continue;
                    current.getParameterDriver(templateDrivers.getName()).setSelected(true);
                }
                return current;
            }
            EquinoctialOrbit newEquinoctialOrbit = new EquinoctialOrbit(sma += this.scale * deltaSma, ex += this.scale * deltaEx, ey += this.scale * deltaEy, hx += this.scale * deltaHx, hy += this.scale * deltaHy, lv += this.scale * deltaLv, PositionAngleType.TRUE, equinoctialOrbit.getFrame(), equinoctialOrbit.getDate(), equinoctialOrbit.getMu());
            KeplerianOrbit newKeplerianOrbit = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(newEquinoctialOrbit);
            current = TleGenerationUtil.newTLE(newKeplerianOrbit, templateTLE, templateTLE.getBStar(epoch), this.utc);
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_TLE, k);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTLE<T> generate(FieldSpacecraftState<T> state, FieldTLE<T> templateTLE) {
        FieldEquinoctialOrbit<T> equinoctialOrbit = this.convert(state.getOrbit());
        Object sma = equinoctialOrbit.getA();
        Object ex = equinoctialOrbit.getEquinoctialEx();
        Object ey = equinoctialOrbit.getEquinoctialEy();
        Object hx = equinoctialOrbit.getHx();
        Object hy = equinoctialOrbit.getHy();
        Object lv = equinoctialOrbit.getLv();
        CalculusFieldElement bStar = (CalculusFieldElement)((CalculusFieldElement)state.getA().getField().getZero()).newInstance(templateTLE.getBStar());
        FieldKeplerianOrbit keplerianOrbit = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(equinoctialOrbit);
        FieldTLE<CalculusFieldElement> current = TleGenerationUtil.newTLE(keplerianOrbit, templateTLE, bStar, this.utc);
        Field<T> field = state.getDate().getField();
        CalculusFieldElement thrA = (CalculusFieldElement)((CalculusFieldElement)sma.add(1.0)).multiply(this.epsilon);
        CalculusFieldElement thrE = (CalculusFieldElement)((CalculusFieldElement)FastMath.hypot(ex, ey).add(1.0)).multiply(this.epsilon);
        CalculusFieldElement thrH = (CalculusFieldElement)((CalculusFieldElement)FastMath.hypot(hx, hy).add(1.0)).multiply(this.epsilon);
        CalculusFieldElement thrV = (CalculusFieldElement)((CalculusFieldElement)sma.getPi()).multiply(this.epsilon);
        int k = 0;
        while (k++ < this.maxIterations) {
            FieldTLEPropagator propagator = FieldTLEPropagator.selectExtrapolator(current, (AttitudeProvider)new FrameAlignedProvider(Rotation.IDENTITY, this.teme), state.getMass(), (Frame)this.teme, (CalculusFieldElement[])templateTLE.getParameters(field));
            FieldOrbit recoveredOrbit = propagator.getInitialState().getOrbit();
            FieldEquinoctialOrbit recoveredEquinoctialOrbit = (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(recoveredOrbit);
            CalculusFieldElement deltaSma = (CalculusFieldElement)equinoctialOrbit.getA().subtract(recoveredEquinoctialOrbit.getA());
            CalculusFieldElement deltaEx = (CalculusFieldElement)equinoctialOrbit.getEquinoctialEx().subtract(recoveredEquinoctialOrbit.getEquinoctialEx());
            CalculusFieldElement deltaEy = (CalculusFieldElement)equinoctialOrbit.getEquinoctialEy().subtract(recoveredEquinoctialOrbit.getEquinoctialEy());
            CalculusFieldElement deltaHx = (CalculusFieldElement)equinoctialOrbit.getHx().subtract(recoveredEquinoctialOrbit.getHx());
            CalculusFieldElement deltaHy = (CalculusFieldElement)equinoctialOrbit.getHy().subtract(recoveredEquinoctialOrbit.getHy());
            CalculusFieldElement deltaLv = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)equinoctialOrbit.getLv().subtract(recoveredEquinoctialOrbit.getLv())), (CalculusFieldElement)((CalculusFieldElement)field.getZero()));
            if (FastMath.abs((double)deltaSma.getReal()) < thrA.getReal() && FastMath.abs((double)deltaEx.getReal()) < thrE.getReal() && FastMath.abs((double)deltaEy.getReal()) < thrE.getReal() && FastMath.abs((double)deltaHx.getReal()) < thrH.getReal() && FastMath.abs((double)deltaHy.getReal()) < thrH.getReal() && FastMath.abs((double)deltaLv.getReal()) < thrV.getReal()) {
                return current;
            }
            sma = (CalculusFieldElement)sma.add((FieldElement)((CalculusFieldElement)deltaSma.multiply(this.scale)));
            ex = (CalculusFieldElement)ex.add((FieldElement)((CalculusFieldElement)deltaEx.multiply(this.scale)));
            ey = (CalculusFieldElement)ey.add((FieldElement)((CalculusFieldElement)deltaEy.multiply(this.scale)));
            hx = (CalculusFieldElement)hx.add((FieldElement)((CalculusFieldElement)deltaHx.multiply(this.scale)));
            hy = (CalculusFieldElement)hy.add((FieldElement)((CalculusFieldElement)deltaHy.multiply(this.scale)));
            lv = (CalculusFieldElement)lv.add((FieldElement)((CalculusFieldElement)deltaLv.multiply(this.scale)));
            FieldEquinoctialOrbit<T> newEquinoctialOrbit = new FieldEquinoctialOrbit<T>(sma, ex, ey, hx, hy, lv, PositionAngleType.TRUE, equinoctialOrbit.getFrame(), equinoctialOrbit.getDate(), equinoctialOrbit.getMu());
            FieldKeplerianOrbit newKeplerianOrbit = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(newEquinoctialOrbit);
            current = TleGenerationUtil.newTLE(newKeplerianOrbit, templateTLE, bStar, this.utc);
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_TLE, k);
    }

    private EquinoctialOrbit convert(Orbit orbitIn) {
        return new EquinoctialOrbit(orbitIn.getPVCoordinates(this.teme), this.teme, 3.9860079999999994E14);
    }

    private <T extends CalculusFieldElement<T>> FieldEquinoctialOrbit<T> convert(FieldOrbit<T> orbitIn) {
        return new FieldEquinoctialOrbit<CalculusFieldElement>(orbitIn.getPVCoordinates(this.teme), this.teme, (CalculusFieldElement)orbitIn.getMu().newInstance(3.9860079999999994E14));
    }
}

