/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Pair;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.tle.FieldDeepSDP4;
import org.orekit.propagation.analytical.tle.FieldSGP4;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.propagation.analytical.tle.generation.TleGenerationAlgorithm;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public abstract class FieldTLEPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    protected FieldTLE<T> tle;
    protected final TimeScale utc;
    protected T xnode;
    protected T a;
    protected T e;
    protected T i;
    protected T omega;
    protected T xl;
    protected T a0dp;
    protected T xn0dp;
    protected T cosi0;
    protected T theta2;
    protected T sini0;
    protected T xmdot;
    protected T omgdot;
    protected T xnodot;
    protected T e0sq;
    protected T beta02;
    protected T beta0;
    protected T perige;
    protected T etasq;
    protected T eeta;
    protected T s4;
    protected T tsi;
    protected T eta;
    protected T coef;
    protected T coef1;
    protected T c1;
    protected T c2;
    protected T c4;
    protected T xnodcf;
    protected T t2cof;
    private final Frame teme;
    private TimeSpanMap<Pair<FieldTLE<T>, T>> tlesAndMasses;

    @DefaultDataContext
    protected FieldTLEPropagator(FieldTLE<T> initialTLE, AttitudeProvider attitudeProvider, T mass, T[] parameters) {
        this(initialTLE, attitudeProvider, (CalculusFieldElement)mass, DataContext.getDefault().getFrames().getTEME(), (CalculusFieldElement[])parameters);
    }

    protected FieldTLEPropagator(FieldTLE<T> initialTLE, AttitudeProvider attitudeProvider, T mass, Frame teme, T[] parameters) {
        super(initialTLE.getE().getField(), attitudeProvider);
        this.setStartDate(initialTLE.getDate());
        this.utc = initialTLE.getUtc();
        this.initializeTle(initialTLE);
        this.teme = teme;
        this.tlesAndMasses = new TimeSpanMap<Pair>(new Pair(this.tle, mass));
        this.initializeCommons((CalculusFieldElement[])parameters);
        this.sxpInitialize((CalculusFieldElement[])parameters);
        FieldOrbit orbit = this.propagateOrbit(initialTLE.getDate(), (CalculusFieldElement[])parameters);
        FieldAttitude attitude = attitudeProvider.getAttitude(orbit, orbit.getDate(), orbit.getFrame());
        super.resetInitialState(new FieldSpacecraftState(orbit, attitude, mass));
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldTLEPropagator<T> selectExtrapolator(FieldTLE<T> tle, T[] parameters) {
        return FieldTLEPropagator.selectExtrapolator(tle, (Frame)DataContext.getDefault().getFrames().getTEME(), parameters);
    }

    public static <T extends CalculusFieldElement<T>> FieldTLEPropagator<T> selectExtrapolator(FieldTLE<T> tle, Frame teme, T[] parameters) {
        return FieldTLEPropagator.selectExtrapolator(tle, (AttitudeProvider)FrameAlignedProvider.of(teme), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tle.getE().getField().getZero()).newInstance(1000.0)), (Frame)teme, parameters);
    }

    @DefaultDataContext
    public static <T extends CalculusFieldElement<T>> FieldTLEPropagator<T> selectExtrapolator(FieldTLE<T> tle, AttitudeProvider attitudeProvider, T mass, T[] parameters) {
        return FieldTLEPropagator.selectExtrapolator(tle, (AttitudeProvider)attitudeProvider, mass, (Frame)DataContext.getDefault().getFrames().getTEME(), parameters);
    }

    public static <T extends CalculusFieldElement<T>> FieldTLEPropagator<T> selectExtrapolator(FieldTLE<T> tle, AttitudeProvider attitudeProvider, T mass, Frame teme, T[] parameters) {
        CalculusFieldElement a1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tle.getMeanMotion().multiply(60.0)).reciprocal()).multiply(0.07436691613317341)).pow(0.6666666666666666);
        CalculusFieldElement cosi0 = FastMath.cos(tle.getI());
        CalculusFieldElement temp1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosi0.multiply((FieldElement)((CalculusFieldElement)cosi0.multiply(3.0)))).subtract(1.0)).multiply(8.119620000000001E-4);
        CalculusFieldElement temp2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tle.getE().multiply(tle.getE())).negate()).add(1.0)).pow(-1.5);
        CalculusFieldElement temp = (CalculusFieldElement)temp1.multiply((FieldElement)temp2);
        CalculusFieldElement delta1 = (CalculusFieldElement)temp.divide((FieldElement)((CalculusFieldElement)a1.multiply((FieldElement)a1)));
        CalculusFieldElement a0 = (CalculusFieldElement)a1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)delta1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)delta1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)delta1.multiply(1.654320987654321)).add(1.0)))).add(0.3333333333333333)))).negate()).add(1.0)));
        CalculusFieldElement delta0 = (CalculusFieldElement)temp.divide((FieldElement)((CalculusFieldElement)a0.multiply((FieldElement)a0)));
        CalculusFieldElement xn0dp = (CalculusFieldElement)((CalculusFieldElement)tle.getMeanMotion().multiply(60.0)).divide((FieldElement)((CalculusFieldElement)delta0.add(1.0)));
        if (Math.PI * 2 / ((CalculusFieldElement)xn0dp.multiply(1440.0)).getReal() >= 0.15625) {
            return new FieldDeepSDP4(tle, attitudeProvider, mass, teme, parameters);
        }
        return new FieldSGP4(tle, attitudeProvider, mass, teme, parameters);
    }

    public static double getMU() {
        return 3.9860079999999994E14;
    }

    public FieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, T[] parameters) {
        this.sxpPropagate((CalculusFieldElement)date.durationFrom(this.tle.getDate()).divide(60.0), (CalculusFieldElement[])parameters);
        return this.computePVCoordinates();
    }

    private void initializeCommons(T[] parameters) {
        CalculusFieldElement zero = (CalculusFieldElement)this.tle.getDate().getField().getZero();
        T bStar = parameters[0];
        CalculusFieldElement a1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getMeanMotion().multiply(60.0)).reciprocal()).multiply(0.07436691613317341)).pow(0.6666666666666666);
        this.cosi0 = FastMath.cos(this.tle.getI());
        this.theta2 = (CalculusFieldElement)this.cosi0.multiply(this.cosi0);
        CalculusFieldElement x3thm1 = (CalculusFieldElement)((CalculusFieldElement)this.theta2.multiply(3.0)).subtract(1.0);
        this.e0sq = (CalculusFieldElement)this.tle.getE().square();
        this.beta02 = (CalculusFieldElement)((CalculusFieldElement)this.e0sq.negate()).add(1.0);
        this.beta0 = FastMath.sqrt(this.beta02);
        CalculusFieldElement tval = (CalculusFieldElement)((CalculusFieldElement)x3thm1.multiply(8.119620000000001E-4)).divide((FieldElement)((CalculusFieldElement)this.beta0.multiply(this.beta02)));
        CalculusFieldElement delta1 = (CalculusFieldElement)tval.divide((FieldElement)((CalculusFieldElement)a1.multiply((FieldElement)a1)));
        CalculusFieldElement a0 = (CalculusFieldElement)a1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)delta1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)delta1.multiply(1.654320987654321)).add(1.0)).multiply((FieldElement)delta1)).add(0.3333333333333333)))).negate()).add(1.0)));
        CalculusFieldElement delta0 = (CalculusFieldElement)tval.divide((FieldElement)((CalculusFieldElement)a0.multiply((FieldElement)a0)));
        this.xn0dp = (CalculusFieldElement)((CalculusFieldElement)this.tle.getMeanMotion().multiply(60.0)).divide((FieldElement)((CalculusFieldElement)delta0.add(1.0)));
        this.a0dp = (CalculusFieldElement)a0.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)delta0.negate()).add(1.0)));
        this.s4 = (CalculusFieldElement)zero.newInstance(1.0122292801892716);
        CalculusFieldElement q0ms24 = (CalculusFieldElement)zero.newInstance(1.8802791590152705E-9);
        this.perige = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a0dp.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().negate()).add(1.0)))).subtract(1.0)).multiply(6378.135);
        if (this.perige.getReal() < 156.0) {
            this.s4 = this.perige.getReal() <= 98.0 ? (CalculusFieldElement)zero.newInstance(20.0) : (CalculusFieldElement)this.perige.subtract(78.0);
            CalculusFieldElement temp_val = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.s4.negate()).add(120.0)).multiply(1.5678564345220037E-4);
            CalculusFieldElement temp_val_squared = (CalculusFieldElement)temp_val.multiply((FieldElement)temp_val);
            q0ms24 = (CalculusFieldElement)temp_val_squared.square();
            this.s4 = (CalculusFieldElement)((CalculusFieldElement)this.s4.divide(6378.135)).add(1.0);
        }
        CalculusFieldElement pinv = (CalculusFieldElement)((CalculusFieldElement)this.a0dp.multiply(this.beta02)).reciprocal();
        CalculusFieldElement pinvsq = (CalculusFieldElement)pinv.square();
        this.tsi = (CalculusFieldElement)((CalculusFieldElement)this.a0dp.subtract(this.s4)).reciprocal();
        this.eta = (CalculusFieldElement)((CalculusFieldElement)this.a0dp.multiply(this.tle.getE())).multiply(this.tsi);
        this.etasq = (CalculusFieldElement)this.eta.square();
        this.eeta = (CalculusFieldElement)this.tle.getE().multiply(this.eta);
        CalculusFieldElement psisq = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.etasq.negate()).add(1.0)).abs();
        CalculusFieldElement tsi_squared = (CalculusFieldElement)this.tsi.multiply(this.tsi);
        this.coef = (CalculusFieldElement)q0ms24.multiply((FieldElement)((CalculusFieldElement)tsi_squared.square()));
        this.coef1 = (CalculusFieldElement)this.coef.divide((FieldElement)((CalculusFieldElement)psisq.pow(3.5)));
        this.c2 = (CalculusFieldElement)((CalculusFieldElement)this.coef1.multiply(this.xn0dp)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a0dp.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.etasq.multiply(1.5)).add((FieldElement)((CalculusFieldElement)this.eeta.multiply((FieldElement)((CalculusFieldElement)this.etasq.add(4.0)))))).add(1.0)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tsi.divide((FieldElement)psisq)).multiply((FieldElement)x3thm1)).multiply(4.0598100000000003E-4)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.etasq.multiply((FieldElement)((CalculusFieldElement)this.etasq.add(8.0)))).multiply(3.0)).add(8.0)))))));
        this.c1 = (CalculusFieldElement)bStar.multiply(this.c2);
        this.sini0 = FastMath.sin(this.tle.getI());
        CalculusFieldElement x1mth2 = (CalculusFieldElement)((CalculusFieldElement)this.theta2.negate()).add(1.0);
        this.c4 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xn0dp.multiply(this.coef1)).multiply(this.a0dp)).multiply(2.0)).multiply(this.beta02)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.eta.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.etasq.multiply(0.5)).add(2.0)))).add((FieldElement)((CalculusFieldElement)this.tle.getE().multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.etasq.multiply(2.0)).add(0.5)))))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tsi.divide((FieldElement)((CalculusFieldElement)this.a0dp.multiply((FieldElement)psisq)))).multiply(0.001082616)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x3thm1.multiply(-3)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.etasq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.eeta.multiply(-0.5)).add(1.5)))).add((FieldElement)((CalculusFieldElement)this.eeta.multiply(-2.0)))).add(1.0)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x1mth2.multiply(0.75)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.etasq.multiply(2.0)).subtract((FieldElement)((CalculusFieldElement)this.eeta.multiply((FieldElement)((CalculusFieldElement)this.etasq.add(1.0)))))))).multiply((FieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)this.tle.getPerigeeArgument().multiply(2.0))))))))))));
        CalculusFieldElement theta4 = (CalculusFieldElement)this.theta2.multiply(this.theta2);
        CalculusFieldElement temp1 = (CalculusFieldElement)((CalculusFieldElement)pinvsq.multiply(this.xn0dp)).multiply(0.0016239240000000001);
        CalculusFieldElement temp2 = (CalculusFieldElement)((CalculusFieldElement)temp1.multiply((FieldElement)pinvsq)).multiply(5.41308E-4);
        CalculusFieldElement temp3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)pinvsq.multiply((FieldElement)pinvsq)).multiply(this.xn0dp)).multiply(7.762359374999998E-7);
        this.xmdot = (CalculusFieldElement)((CalculusFieldElement)this.xn0dp.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp1.multiply(0.5)).multiply(this.beta0)).multiply((FieldElement)x3thm1)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp2.multiply(0.0625)).multiply(this.beta0)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.theta2.multiply(78.0)).negate()).add(13.0)).add((FieldElement)((CalculusFieldElement)theta4.multiply(137.0)))))));
        CalculusFieldElement x1m5th = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.theta2.multiply(5.0)).negate()).add(1.0);
        this.omgdot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp1.multiply(-0.5)).multiply((FieldElement)x1m5th)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)temp2.multiply(0.0625)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.theta2.multiply(114.0)).negate()).add((FieldElement)((CalculusFieldElement)theta4.multiply(395.0)))).add(7.0)))))).add((FieldElement)((CalculusFieldElement)temp3.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.theta2.multiply(36.0)).negate()).add((FieldElement)((CalculusFieldElement)theta4.multiply(49.0)))).add(3.0)))));
        CalculusFieldElement xhdot1 = (CalculusFieldElement)((CalculusFieldElement)temp1.negate()).multiply(this.cosi0);
        this.xnodot = (CalculusFieldElement)xhdot1.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp2.multiply(0.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.theta2.multiply(19.0)).negate()).add(4.0)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)temp3.multiply(2.0)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.theta2.multiply(7.0)).negate()).add(3.0)))))).multiply(this.cosi0)));
        this.xnodcf = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.beta02.multiply((FieldElement)xhdot1)).multiply(this.c1)).multiply(3.5);
        this.t2cof = (CalculusFieldElement)this.c1.multiply(1.5);
    }

    private FieldPVCoordinates<T> computePVCoordinates() {
        CalculusFieldElement capu;
        CalculusFieldElement zero = (CalculusFieldElement)this.tle.getDate().getField().getZero();
        CalculusFieldElement axn = (CalculusFieldElement)this.e.multiply((FieldElement)FastMath.cos(this.omega));
        CalculusFieldElement temp = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply(this.e)).negate()).add(1.0)))).reciprocal();
        CalculusFieldElement xlcof = (CalculusFieldElement)((CalculusFieldElement)this.sini0.multiply(5.86267430002882E-4)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(5.0)).add(3.0)).divide((FieldElement)((CalculusFieldElement)this.cosi0.add(1.0)))));
        CalculusFieldElement aycof = (CalculusFieldElement)this.sini0.multiply(0.001172534860005764);
        CalculusFieldElement xll = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)xlcof)).multiply((FieldElement)axn);
        CalculusFieldElement aynl = (CalculusFieldElement)temp.multiply((FieldElement)aycof);
        CalculusFieldElement xlt = (CalculusFieldElement)this.xl.add((FieldElement)xll);
        CalculusFieldElement ayn = (CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)FastMath.sin(this.omega))).add((FieldElement)aynl);
        CalculusFieldElement elsq = (CalculusFieldElement)((CalculusFieldElement)axn.square()).add((FieldElement)((CalculusFieldElement)ayn.square()));
        CalculusFieldElement epw = capu = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)xlt.subtract(this.xnode)), (CalculusFieldElement)((CalculusFieldElement)zero.getPi()));
        CalculusFieldElement ecosE = zero;
        CalculusFieldElement esinE = zero;
        CalculusFieldElement sinEPW = zero;
        CalculusFieldElement cosEPW = zero;
        CalculusFieldElement cosi0Sq = (CalculusFieldElement)this.cosi0.square();
        CalculusFieldElement x3thm1 = (CalculusFieldElement)((CalculusFieldElement)cosi0Sq.multiply(3.0)).subtract(1.0);
        CalculusFieldElement x1mth2 = (CalculusFieldElement)((CalculusFieldElement)cosi0Sq.negate()).add(1.0);
        CalculusFieldElement x7thm1 = (CalculusFieldElement)((CalculusFieldElement)cosi0Sq.multiply(7.0)).subtract(1.0);
        if (this.e.getReal() > 0.999999) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, this.e);
        }
        double newtonRaphsonEpsilon = 1.0E-12;
        for (int j = 0; j < 10; ++j) {
            boolean doSecondOrderNewtonRaphson = true;
            sinEPW = FastMath.sin((CalculusFieldElement)epw);
            cosEPW = FastMath.cos((CalculusFieldElement)epw);
            ecosE = (CalculusFieldElement)((CalculusFieldElement)axn.multiply((FieldElement)cosEPW)).add((FieldElement)((CalculusFieldElement)ayn.multiply((FieldElement)sinEPW)));
            esinE = (CalculusFieldElement)((CalculusFieldElement)axn.multiply((FieldElement)sinEPW)).subtract((FieldElement)((CalculusFieldElement)ayn.multiply((FieldElement)cosEPW)));
            CalculusFieldElement f = (CalculusFieldElement)((CalculusFieldElement)capu.subtract((FieldElement)epw)).add((FieldElement)esinE);
            if (FastMath.abs((double)f.getReal()) < 1.0E-12) break;
            CalculusFieldElement fdot = (CalculusFieldElement)((CalculusFieldElement)ecosE.negate()).add(1.0);
            CalculusFieldElement delta_epw = (CalculusFieldElement)f.divide((FieldElement)fdot);
            if (j == 0) {
                CalculusFieldElement maxNewtonRaphson = (CalculusFieldElement)((CalculusFieldElement)this.e.abs()).multiply(1.25);
                doSecondOrderNewtonRaphson = false;
                if (delta_epw.getReal() > maxNewtonRaphson.getReal()) {
                    delta_epw = maxNewtonRaphson;
                } else if (delta_epw.getReal() < -maxNewtonRaphson.getReal()) {
                    delta_epw = (CalculusFieldElement)maxNewtonRaphson.negate();
                } else {
                    doSecondOrderNewtonRaphson = true;
                }
            }
            if (doSecondOrderNewtonRaphson) {
                delta_epw = (CalculusFieldElement)f.divide((FieldElement)((CalculusFieldElement)fdot.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)esinE.multiply(0.5)).multiply((FieldElement)delta_epw)))));
            }
            epw = (CalculusFieldElement)epw.add((FieldElement)delta_epw);
        }
        temp = (CalculusFieldElement)((CalculusFieldElement)elsq.negate()).add(1.0);
        CalculusFieldElement pl = (CalculusFieldElement)this.a.multiply((FieldElement)temp);
        CalculusFieldElement r = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ecosE.negate()).add(1.0)));
        CalculusFieldElement temp2 = (CalculusFieldElement)this.a.divide((FieldElement)r);
        CalculusFieldElement betal = FastMath.sqrt((CalculusFieldElement)temp);
        temp = (CalculusFieldElement)esinE.divide((FieldElement)((CalculusFieldElement)betal.add(1.0)));
        CalculusFieldElement cosu = (CalculusFieldElement)temp2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cosEPW.subtract((FieldElement)axn)).add((FieldElement)((CalculusFieldElement)ayn.multiply((FieldElement)temp)))));
        CalculusFieldElement sinu = (CalculusFieldElement)temp2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinEPW.subtract((FieldElement)ayn)).subtract((FieldElement)((CalculusFieldElement)axn.multiply((FieldElement)temp)))));
        CalculusFieldElement u = FastMath.atan2((CalculusFieldElement)sinu, (CalculusFieldElement)cosu);
        CalculusFieldElement sin2u = (CalculusFieldElement)((CalculusFieldElement)sinu.multiply((FieldElement)cosu)).multiply(2.0);
        CalculusFieldElement cos2u = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosu.multiply((FieldElement)cosu)).multiply(2.0)).subtract(1.0);
        CalculusFieldElement temp1 = (CalculusFieldElement)((CalculusFieldElement)pl.reciprocal()).multiply(5.41308E-4);
        temp2 = (CalculusFieldElement)temp1.divide((FieldElement)pl);
        CalculusFieldElement rk = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp2.multiply((FieldElement)betal)).multiply((FieldElement)x3thm1)).multiply(-1.5)).add(1.0)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp1.multiply((FieldElement)x1mth2)).multiply((FieldElement)cos2u)).multiply(0.5)));
        CalculusFieldElement uk = (CalculusFieldElement)u.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp2.multiply((FieldElement)x7thm1)).multiply((FieldElement)sin2u)).multiply(0.25)));
        CalculusFieldElement xnodek = (CalculusFieldElement)this.xnode.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp2.multiply(this.cosi0)).multiply((FieldElement)sin2u)).multiply(1.5)));
        CalculusFieldElement xinck = (CalculusFieldElement)this.i.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp2.multiply(this.cosi0)).multiply(this.sini0)).multiply((FieldElement)cos2u)).multiply(1.5)));
        CalculusFieldElement sinuk = FastMath.sin((CalculusFieldElement)uk);
        CalculusFieldElement cosuk = FastMath.cos((CalculusFieldElement)uk);
        CalculusFieldElement sinik = FastMath.sin((CalculusFieldElement)xinck);
        CalculusFieldElement cosik = FastMath.cos((CalculusFieldElement)xinck);
        CalculusFieldElement sinnok = FastMath.sin((CalculusFieldElement)xnodek);
        CalculusFieldElement cosnok = FastMath.cos((CalculusFieldElement)xnodek);
        CalculusFieldElement xmx = (CalculusFieldElement)((CalculusFieldElement)sinnok.negate()).multiply((FieldElement)cosik);
        CalculusFieldElement xmy = (CalculusFieldElement)cosnok.multiply((FieldElement)cosik);
        CalculusFieldElement ux = (CalculusFieldElement)((CalculusFieldElement)xmx.multiply((FieldElement)sinuk)).add((FieldElement)((CalculusFieldElement)cosnok.multiply((FieldElement)cosuk)));
        CalculusFieldElement uy = (CalculusFieldElement)((CalculusFieldElement)xmy.multiply((FieldElement)sinuk)).add((FieldElement)((CalculusFieldElement)sinnok.multiply((FieldElement)cosuk)));
        CalculusFieldElement uz = (CalculusFieldElement)sinik.multiply((FieldElement)sinuk);
        CalculusFieldElement cr = (CalculusFieldElement)rk.multiply(6378135.0);
        FieldVector3D pos = new FieldVector3D((CalculusFieldElement)cr.multiply((FieldElement)ux), (CalculusFieldElement)cr.multiply((FieldElement)uy), (CalculusFieldElement)cr.multiply((FieldElement)uz));
        CalculusFieldElement sqrtA = FastMath.sqrt(this.a);
        CalculusFieldElement rdot = (CalculusFieldElement)((CalculusFieldElement)sqrtA.multiply((FieldElement)((CalculusFieldElement)esinE.divide((FieldElement)r)))).multiply(0.07436691613317341);
        CalculusFieldElement rfdot = (CalculusFieldElement)((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)pl).divide((FieldElement)r)).multiply(0.07436691613317341);
        CalculusFieldElement xn = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)sqrtA)).reciprocal()).multiply(0.07436691613317341);
        CalculusFieldElement rdotk = (CalculusFieldElement)rdot.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xn.multiply((FieldElement)temp1)).multiply((FieldElement)x1mth2)).multiply((FieldElement)sin2u)));
        CalculusFieldElement rfdotk = (CalculusFieldElement)rfdot.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)xn.multiply((FieldElement)temp1)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x1mth2.multiply((FieldElement)cos2u)).add((FieldElement)((CalculusFieldElement)x3thm1.multiply(1.5)))))));
        CalculusFieldElement vx = (CalculusFieldElement)((CalculusFieldElement)xmx.multiply((FieldElement)cosuk)).subtract((FieldElement)((CalculusFieldElement)cosnok.multiply((FieldElement)sinuk)));
        CalculusFieldElement vy = (CalculusFieldElement)((CalculusFieldElement)xmy.multiply((FieldElement)cosuk)).subtract((FieldElement)((CalculusFieldElement)sinnok.multiply((FieldElement)sinuk)));
        CalculusFieldElement vz = (CalculusFieldElement)sinik.multiply((FieldElement)cosuk);
        double cv = 106302.25;
        FieldVector3D vel = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rdotk.multiply((FieldElement)ux)).add((FieldElement)((CalculusFieldElement)rfdotk.multiply((FieldElement)vx)))).multiply(106302.25), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rdotk.multiply((FieldElement)uy)).add((FieldElement)((CalculusFieldElement)rfdotk.multiply((FieldElement)vy)))).multiply(106302.25), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rdotk.multiply((FieldElement)uz)).add((FieldElement)((CalculusFieldElement)rfdotk.multiply((FieldElement)vz)))).multiply(106302.25));
        return new FieldPVCoordinates(pos, vel);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tle.getParametersDrivers();
    }

    protected abstract void sxpInitialize(T[] var1);

    protected abstract void sxpPropagate(T var1, T[] var2);

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        super.resetInitialState(state);
        this.resetTle(state);
        this.tlesAndMasses = new TimeSpanMap<Pair>(new Pair(this.tle, state.getMass()));
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        this.resetTle(state);
        Pair tleAndMass = new Pair(this.tle, state.getMass());
        if (forward) {
            this.tlesAndMasses.addValidAfter(tleAndMass, state.getDate().toAbsoluteDate(), false);
        } else {
            this.tlesAndMasses.addValidBefore(tleAndMass, state.getDate().toAbsoluteDate(), false);
        }
        this.stateChanged(state);
    }

    private void resetTle(FieldSpacecraftState<T> state) {
        TleGenerationAlgorithm algorithm = TLEPropagator.getDefaultTleGenerationAlgorithm(this.utc, this.teme);
        FieldTLE<T> newTle = algorithm.generate(state, this.tle);
        this.initializeTle(newTle);
    }

    private void initializeTle(FieldTLE<T> newTle) {
        this.tle = newTle;
        CalculusFieldElement[] parameters = this.tle.getParameters(this.tle.getDate().getField());
        this.initializeCommons(parameters);
        this.sxpInitialize(parameters);
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return (T)((CalculusFieldElement)this.tlesAndMasses.get(date.toAbsoluteDate()).getValue());
    }

    @Override
    public FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date, T[] parameters) {
        FieldTLE closestTle = (FieldTLE)this.tlesAndMasses.get(date.toAbsoluteDate()).getKey();
        if (!this.tle.equals(closestTle)) {
            this.initializeTle(closestTle);
        }
        CalculusFieldElement mu = (CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(3.9860079999999994E14);
        return new FieldCartesianOrbit<CalculusFieldElement>(this.getPVCoordinates(date, (CalculusFieldElement[])parameters), this.teme, date, mu);
    }

    public FieldTLE<T> getTLE() {
        return this.tle;
    }

    @Override
    public Frame getFrame() {
        return this.teme;
    }
}

