/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.propagation.analytical.tle.FieldTLEPropagator;

public class FieldSGP4<T extends CalculusFieldElement<T>>
extends FieldTLEPropagator<T> {
    private boolean lessThan220;
    private T delM0;
    private T d2;
    private T d3;
    private T d4;
    private T t3cof;
    private T t4cof;
    private T t5cof;
    private T sinM0;
    private T omgcof;
    private T xmcof;
    private T c5;

    @DefaultDataContext
    public FieldSGP4(FieldTLE<T> initialTLE, AttitudeProvider attitudeProvider, T mass, T[] parameters) {
        this(initialTLE, attitudeProvider, (CalculusFieldElement)mass, DataContext.getDefault().getFrames().getTEME(), (CalculusFieldElement[])parameters);
    }

    public FieldSGP4(FieldTLE<T> initialTLE, AttitudeProvider attitudeProvider, T mass, Frame teme, T[] parameters) {
        super(initialTLE, attitudeProvider, mass, teme, parameters);
    }

    @Override
    protected void sxpInitialize(T[] parameters) {
        T bStar = parameters[0];
        boolean bl = this.lessThan220 = this.perige.getReal() < 220.0;
        if (!this.lessThan220) {
            FieldSinCos scM0 = FastMath.sinCos(this.tle.getMeanAnomaly());
            CalculusFieldElement c1sq = (CalculusFieldElement)this.c1.square();
            this.delM0 = (CalculusFieldElement)((CalculusFieldElement)this.eta.multiply((FieldElement)((CalculusFieldElement)scM0.cos()))).add(1.0);
            this.delM0 = (CalculusFieldElement)((CalculusFieldElement)this.delM0.multiply(this.delM0)).multiply(this.delM0);
            this.d2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a0dp.multiply((FieldElement)this.tsi)).multiply((FieldElement)c1sq)).multiply(4.0);
            CalculusFieldElement temp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d2.multiply((FieldElement)this.tsi)).multiply((FieldElement)this.c1)).divide(3.0);
            this.d3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a0dp.multiply(17.0)).add((FieldElement)this.s4)).multiply((FieldElement)temp);
            this.d4 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)temp.multiply(0.5)).multiply((FieldElement)this.a0dp)).multiply((FieldElement)this.tsi)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a0dp.multiply(221.0)).add((FieldElement)((CalculusFieldElement)this.s4.multiply(31.0)))))).multiply((FieldElement)this.c1);
            this.t3cof = (CalculusFieldElement)this.d2.add((FieldElement)((CalculusFieldElement)c1sq.multiply(2)));
            this.t4cof = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d3.multiply(3.0)).add((FieldElement)((CalculusFieldElement)this.c1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d2.multiply(12.0)).add((FieldElement)((CalculusFieldElement)c1sq.multiply(10)))))))).multiply(0.25);
            this.t5cof = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d4.multiply(3.0)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.c1.multiply(12.0)).multiply(this.d3)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d2.multiply(this.d2)).multiply(6.0)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c1sq.multiply(15.0)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d2.multiply(2)).add((FieldElement)c1sq)))))).multiply(0.2);
            this.sinM0 = (CalculusFieldElement)scM0.sin();
            if (this.tle.getE().getReal() < 1.0E-4) {
                this.omgcof = (CalculusFieldElement)c1sq.getField().getZero();
                this.xmcof = (CalculusFieldElement)c1sq.getField().getZero();
            } else {
                CalculusFieldElement c3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.coef.multiply((FieldElement)this.tsi)).multiply((FieldElement)this.xn0dp)).multiply(0.004690139440023056)).multiply((FieldElement)((CalculusFieldElement)this.sini0.divide(this.tle.getE())));
                this.xmcof = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.coef.multiply(bStar)).divide((FieldElement)this.eeta)).multiply(-0.6666666666666666);
                this.omgcof = (CalculusFieldElement)((CalculusFieldElement)bStar.multiply((FieldElement)c3)).multiply((FieldElement)FastMath.cos(this.tle.getPerigeeArgument()));
            }
        }
        this.c5 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.coef1.multiply(2)).multiply((FieldElement)this.a0dp)).multiply((FieldElement)this.beta02)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.etasq.add((FieldElement)this.eeta)).multiply(2.75)).add((FieldElement)((CalculusFieldElement)this.eeta.multiply((FieldElement)this.etasq)))).add(1.0)));
    }

    @Override
    protected void sxpPropagate(T tSince, T[] parameters) {
        T bStar = parameters[0];
        CalculusFieldElement xmdf = (CalculusFieldElement)this.tle.getMeanAnomaly().add((FieldElement)((CalculusFieldElement)this.xmdot.multiply(tSince)));
        CalculusFieldElement omgadf = (CalculusFieldElement)this.tle.getPerigeeArgument().add((FieldElement)((CalculusFieldElement)this.omgdot.multiply(tSince)));
        CalculusFieldElement xn0ddf = (CalculusFieldElement)this.tle.getRaan().add((FieldElement)((CalculusFieldElement)this.xnodot.multiply(tSince)));
        this.omega = omgadf;
        CalculusFieldElement xmp = xmdf;
        CalculusFieldElement tsq = (CalculusFieldElement)tSince.square();
        this.xnode = (CalculusFieldElement)xn0ddf.add((FieldElement)((CalculusFieldElement)this.xnodcf.multiply((FieldElement)tsq)));
        CalculusFieldElement tempa = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.c1.multiply(tSince)).negate()).add(1.0);
        CalculusFieldElement tempe = (CalculusFieldElement)((CalculusFieldElement)bStar.multiply((FieldElement)this.c4)).multiply(tSince);
        CalculusFieldElement templ = (CalculusFieldElement)this.t2cof.multiply((FieldElement)tsq);
        if (!this.lessThan220) {
            CalculusFieldElement delomg = (CalculusFieldElement)this.omgcof.multiply(tSince);
            CalculusFieldElement delm = (CalculusFieldElement)((CalculusFieldElement)this.eta.multiply((FieldElement)FastMath.cos((CalculusFieldElement)xmdf))).add(1.0);
            delm = (CalculusFieldElement)this.xmcof.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)delm.square()).multiply((FieldElement)delm)).subtract(this.delM0)));
            CalculusFieldElement temp = (CalculusFieldElement)delomg.add((FieldElement)delm);
            xmp = (CalculusFieldElement)xmdf.add((FieldElement)temp);
            this.omega = (CalculusFieldElement)omgadf.subtract((FieldElement)temp);
            CalculusFieldElement tcube = (CalculusFieldElement)tsq.multiply(tSince);
            CalculusFieldElement tfour = (CalculusFieldElement)tSince.multiply((FieldElement)tcube);
            tempa = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tempa.subtract((FieldElement)((CalculusFieldElement)this.d2.multiply((FieldElement)tsq)))).subtract((FieldElement)((CalculusFieldElement)this.d3.multiply((FieldElement)tcube)))).subtract((FieldElement)((CalculusFieldElement)this.d4.multiply((FieldElement)tfour)));
            tempe = (CalculusFieldElement)tempe.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)bStar.multiply(this.c5)).multiply((FieldElement)((CalculusFieldElement)FastMath.sin((CalculusFieldElement)xmp).subtract(this.sinM0)))));
            templ = (CalculusFieldElement)((CalculusFieldElement)templ.add((FieldElement)((CalculusFieldElement)this.t3cof.multiply((FieldElement)tcube)))).add((FieldElement)((CalculusFieldElement)tfour.multiply((FieldElement)((CalculusFieldElement)this.t4cof.add((FieldElement)((CalculusFieldElement)tSince.multiply(this.t5cof)))))));
        }
        this.a = (CalculusFieldElement)((CalculusFieldElement)this.a0dp.multiply((FieldElement)tempa)).multiply((FieldElement)tempa);
        this.e = (CalculusFieldElement)this.tle.getE().subtract((FieldElement)tempe);
        if (this.e.getReal() < 1.0E-6) {
            this.e = (CalculusFieldElement)((CalculusFieldElement)this.e.getField().getZero()).newInstance(1.0E-6);
        }
        this.xl = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xmp.add((FieldElement)this.omega)).add((FieldElement)this.xnode)).add((FieldElement)((CalculusFieldElement)this.xn0dp.multiply((FieldElement)templ)));
        this.i = this.tle.getI();
    }
}

