/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.intelsat;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.intelsat.IntelsatElevenElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.units.Unit;

public class IntelsatElevenElementsPropagator
extends AbstractAnalyticalPropagator {
    private final IntelsatElevenElements elements;
    private final Frame inertialFrame;
    private final Frame ecefFrame;
    private final double mass;
    private UnivariateDerivative2 eastLongitudeDegrees;
    private UnivariateDerivative2 geocentricLatitudeDegrees;
    private UnivariateDerivative2 orbitRadius;

    @DefaultDataContext
    public IntelsatElevenElementsPropagator(IntelsatElevenElements elements) {
        this(elements, FramesFactory.getTOD(IERSConventions.IERS_2010, true), FramesFactory.getITRF(IERSConventions.IERS_2010, true));
    }

    public IntelsatElevenElementsPropagator(IntelsatElevenElements elements, Frame inertialFrame, Frame ecefFrame) {
        this(elements, inertialFrame, ecefFrame, FrameAlignedProvider.of(inertialFrame), 1000.0);
    }

    public IntelsatElevenElementsPropagator(IntelsatElevenElements elements, Frame inertialFrame, Frame ecefFrame, AttitudeProvider attitudeProvider, double mass) {
        super(attitudeProvider);
        this.elements = elements;
        this.inertialFrame = inertialFrame;
        this.ecefFrame = ecefFrame;
        this.mass = mass;
        this.setStartDate(elements.getEpoch());
        Orbit orbitAtElementsDate = this.propagateOrbit(elements.getEpoch());
        Attitude attitude = attitudeProvider.getAttitude(orbitAtElementsDate, elements.getEpoch(), inertialFrame);
        super.resetInitialState(new SpacecraftState(orbitAtElementsDate, attitude, mass));
    }

    public PVCoordinates propagateInEcef(AbsoluteDate date) {
        UnivariateDerivative2 tDays = new UnivariateDerivative2(date.durationFrom(this.elements.getEpoch()), 1.0, 0.0).divide(86400.0);
        double wDegreesPerDay = this.elements.getLm1() + 360.98564;
        UnivariateDerivative2 wt = (UnivariateDerivative2)FastMath.toRadians((CalculusFieldElement)tDays.multiply(wDegreesPerDay));
        FieldSinCos scWt = FastMath.sinCos((CalculusFieldElement)wt);
        FieldSinCos sc2Wt = FastMath.sinCos((CalculusFieldElement)wt.multiply(2.0));
        UnivariateDerivative2 satelliteEastLongitudeDegrees = this.computeSatelliteEastLongitudeDegrees(tDays, (FieldSinCos<UnivariateDerivative2>)scWt, (FieldSinCos<UnivariateDerivative2>)sc2Wt);
        UnivariateDerivative2 satelliteGeocentricLatitudeDegrees = this.computeSatelliteGeocentricLatitudeDegrees(tDays, (FieldSinCos<UnivariateDerivative2>)scWt);
        UnivariateDerivative2 satelliteRadius = this.computeSatelliteRadiusKilometers(wDegreesPerDay, (FieldSinCos<UnivariateDerivative2>)scWt).multiply(Unit.KILOMETRE.getScale());
        this.eastLongitudeDegrees = satelliteEastLongitudeDegrees;
        this.geocentricLatitudeDegrees = satelliteGeocentricLatitudeDegrees;
        this.orbitRadius = satelliteRadius;
        FieldSinCos scLongitude = FastMath.sinCos((CalculusFieldElement)((UnivariateDerivative2)FastMath.toRadians((CalculusFieldElement)satelliteEastLongitudeDegrees)));
        FieldSinCos scLatitude = FastMath.sinCos((CalculusFieldElement)((UnivariateDerivative2)FastMath.toRadians((CalculusFieldElement)satelliteGeocentricLatitudeDegrees)));
        FieldVector3D positionWithDerivatives = new FieldVector3D((CalculusFieldElement)satelliteRadius.multiply((UnivariateDerivative2)scLatitude.cos()).multiply((UnivariateDerivative2)scLongitude.cos()), (CalculusFieldElement)satelliteRadius.multiply((UnivariateDerivative2)scLatitude.cos()).multiply((UnivariateDerivative2)scLongitude.sin()), (CalculusFieldElement)satelliteRadius.multiply((UnivariateDerivative2)scLatitude.sin()));
        return new PVCoordinates(new Vector3D(((UnivariateDerivative2)positionWithDerivatives.getX()).getValue(), ((UnivariateDerivative2)positionWithDerivatives.getY()).getValue(), ((UnivariateDerivative2)positionWithDerivatives.getZ()).getValue()), new Vector3D(((UnivariateDerivative2)positionWithDerivatives.getX()).getFirstDerivative(), ((UnivariateDerivative2)positionWithDerivatives.getY()).getFirstDerivative(), ((UnivariateDerivative2)positionWithDerivatives.getZ()).getFirstDerivative()), new Vector3D(((UnivariateDerivative2)positionWithDerivatives.getX()).getSecondDerivative(), ((UnivariateDerivative2)positionWithDerivatives.getY()).getSecondDerivative(), ((UnivariateDerivative2)positionWithDerivatives.getZ()).getSecondDerivative()));
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return new CartesianOrbit(this.ecefFrame.getTransformTo(this.inertialFrame, date).transformPVCoordinates(this.propagateInEcef(date)), this.inertialFrame, date, 3.986004418E14);
    }

    private UnivariateDerivative2 computeSatelliteEastLongitudeDegrees(UnivariateDerivative2 tDays, FieldSinCos<UnivariateDerivative2> scW, FieldSinCos<UnivariateDerivative2> sc2W) {
        UnivariateDerivative2 longitude = (UnivariateDerivative2)tDays.multiply(tDays).multiply(this.elements.getLm2()).add(tDays.multiply(this.elements.getLm1())).add(this.elements.getLm0());
        UnivariateDerivative2 cosineLongitudeTerm = ((UnivariateDerivative2)scW.cos()).multiply((UnivariateDerivative2)tDays.multiply(this.elements.getLonC1()).add(this.elements.getLonC()));
        UnivariateDerivative2 sineLongitudeTerm = ((UnivariateDerivative2)scW.sin()).multiply((UnivariateDerivative2)tDays.multiply(this.elements.getLonS1()).add(this.elements.getLonS()));
        UnivariateDerivative2 latitudeTerm = ((UnivariateDerivative2)sc2W.sin()).multiply(0.5 * (this.elements.getLatC() * this.elements.getLatC() - this.elements.getLatS() * this.elements.getLatS())).subtract(((UnivariateDerivative2)sc2W.cos()).multiply(this.elements.getLatC() * this.elements.getLatS())).multiply(0.0087266462);
        return longitude.add(cosineLongitudeTerm).add(sineLongitudeTerm).add(latitudeTerm);
    }

    private UnivariateDerivative2 computeSatelliteGeocentricLatitudeDegrees(UnivariateDerivative2 tDays, FieldSinCos<UnivariateDerivative2> scW) {
        UnivariateDerivative2 cosineTerm = ((UnivariateDerivative2)scW.cos()).multiply((UnivariateDerivative2)tDays.multiply(this.elements.getLatC1()).add(this.elements.getLatC()));
        UnivariateDerivative2 sineTerm = ((UnivariateDerivative2)scW.sin()).multiply((UnivariateDerivative2)tDays.multiply(this.elements.getLatS1()).add(this.elements.getLatS()));
        return cosineTerm.add(sineTerm);
    }

    private UnivariateDerivative2 computeSatelliteRadiusKilometers(double wDegreesPerDay, FieldSinCos<UnivariateDerivative2> scW) {
        double coefficient = 42164.57 * (1.0 - 2.0 * this.elements.getLm1() / (3.0 * (wDegreesPerDay - this.elements.getLm1())));
        return ((UnivariateDerivative2)((UnivariateDerivative2)scW.sin()).multiply(0.0087266462 * this.elements.getLonC()).add(1.0)).subtract(((UnivariateDerivative2)scW.cos()).multiply(0.0087266462 * this.elements.getLonS())).multiply(coefficient);
    }

    public UnivariateDerivative2 getEastLongitudeDegrees() {
        return this.eastLongitudeDegrees;
    }

    public UnivariateDerivative2 getGeocentricLatitudeDegrees() {
        return this.geocentricLatitudeDegrees;
    }

    public UnivariateDerivative2 getOrbitRadius() {
        return this.orbitRadius;
    }

    @Override
    public Frame getFrame() {
        return this.inertialFrame;
    }

    public IntelsatElevenElements getIntelsatElevenElements() {
        return this.elements;
    }
}

