/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.intelsat;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.intelsat.FieldIntelsatElevenElements;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.units.Unit;

public class FieldIntelsatElevenElementsPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    private final FieldIntelsatElevenElements<T> elements;
    private final Frame inertialFrame;
    private final Frame ecefFrame;
    private final T mass;
    private FieldUnivariateDerivative2<T> eastLongitudeDegrees;
    private FieldUnivariateDerivative2<T> geocentricLatitudeDegrees;
    private FieldUnivariateDerivative2<T> orbitRadius;

    @DefaultDataContext
    public FieldIntelsatElevenElementsPropagator(FieldIntelsatElevenElements<T> elements) {
        this(elements, FramesFactory.getTOD(IERSConventions.IERS_2010, true), FramesFactory.getITRF(IERSConventions.IERS_2010, true));
    }

    public FieldIntelsatElevenElementsPropagator(FieldIntelsatElevenElements<T> elements, Frame inertialFrame, Frame ecefFrame) {
        this(elements, inertialFrame, ecefFrame, FrameAlignedProvider.of(inertialFrame), (CalculusFieldElement)((CalculusFieldElement)elements.getEpoch().getField().getZero()).add(1000.0));
    }

    public FieldIntelsatElevenElementsPropagator(FieldIntelsatElevenElements<T> elements, Frame inertialFrame, Frame ecefFrame, AttitudeProvider attitudeProvider, T mass) {
        super(elements.getEpoch().getField(), attitudeProvider);
        this.elements = elements;
        this.inertialFrame = inertialFrame;
        this.ecefFrame = ecefFrame;
        this.mass = mass;
        this.setStartDate(elements.getEpoch());
        FieldOrbit orbitAtElementsDate = this.propagateOrbit(elements.getEpoch(), this.getParameters(elements.getEpoch().getField()));
        FieldAttitude<T> attitude = attitudeProvider.getAttitude(orbitAtElementsDate, elements.getEpoch(), inertialFrame);
        super.resetInitialState(new FieldSpacecraftState<T>(orbitAtElementsDate, attitude, mass));
    }

    public FieldPVCoordinates<T> propagateInEcef(FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        FieldUnivariateDerivative2 tDays = new FieldUnivariateDerivative2(date.durationFrom(this.elements.getEpoch()), (CalculusFieldElement)field.getOne(), (CalculusFieldElement)field.getZero()).divide(86400.0);
        CalculusFieldElement wDegreesPerDay = (CalculusFieldElement)this.elements.getLm1().add(360.98564);
        FieldUnivariateDerivative2 wt = (FieldUnivariateDerivative2)FastMath.toRadians((CalculusFieldElement)tDays.multiply(wDegreesPerDay));
        FieldSinCos scWt = FastMath.sinCos((CalculusFieldElement)wt);
        FieldSinCos sc2Wt = FastMath.sinCos((CalculusFieldElement)wt.multiply(2.0));
        FieldUnivariateDerivative2<T> satelliteEastLongitudeDegrees = this.computeSatelliteEastLongitudeDegrees(tDays, scWt, sc2Wt);
        FieldUnivariateDerivative2<T> satelliteGeocentricLatitudeDegrees = this.computeSatelliteGeocentricLatitudeDegrees(tDays, scWt);
        FieldUnivariateDerivative2 satelliteRadius = this.computeSatelliteRadiusKilometers(wDegreesPerDay, scWt).multiply(Unit.KILOMETRE.getScale());
        this.eastLongitudeDegrees = satelliteEastLongitudeDegrees;
        this.geocentricLatitudeDegrees = satelliteGeocentricLatitudeDegrees;
        this.orbitRadius = satelliteRadius;
        FieldSinCos scLongitude = FastMath.sinCos((CalculusFieldElement)((FieldUnivariateDerivative2)FastMath.toRadians(satelliteEastLongitudeDegrees)));
        FieldSinCos scLatitude = FastMath.sinCos((CalculusFieldElement)((FieldUnivariateDerivative2)FastMath.toRadians(satelliteGeocentricLatitudeDegrees)));
        FieldVector3D positionWithDerivatives = new FieldVector3D((CalculusFieldElement)satelliteRadius.multiply((FieldUnivariateDerivative2)scLatitude.cos()).multiply((FieldUnivariateDerivative2)scLongitude.cos()), (CalculusFieldElement)satelliteRadius.multiply((FieldUnivariateDerivative2)scLatitude.cos()).multiply((FieldUnivariateDerivative2)scLongitude.sin()), (CalculusFieldElement)satelliteRadius.multiply((FieldUnivariateDerivative2)scLatitude.sin()));
        return new FieldPVCoordinates(new FieldVector3D(((FieldUnivariateDerivative2)positionWithDerivatives.getX()).getValue(), ((FieldUnivariateDerivative2)positionWithDerivatives.getY()).getValue(), ((FieldUnivariateDerivative2)positionWithDerivatives.getZ()).getValue()), new FieldVector3D(((FieldUnivariateDerivative2)positionWithDerivatives.getX()).getFirstDerivative(), ((FieldUnivariateDerivative2)positionWithDerivatives.getY()).getFirstDerivative(), ((FieldUnivariateDerivative2)positionWithDerivatives.getZ()).getFirstDerivative()), new FieldVector3D(((FieldUnivariateDerivative2)positionWithDerivatives.getX()).getSecondDerivative(), ((FieldUnivariateDerivative2)positionWithDerivatives.getY()).getSecondDerivative(), ((FieldUnivariateDerivative2)positionWithDerivatives.getZ()).getSecondDerivative()));
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return this.mass;
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date, T[] parameters) {
        return new FieldCartesianOrbit<CalculusFieldElement>(this.ecefFrame.getTransformTo(this.inertialFrame, date).transformPVCoordinates(this.propagateInEcef(date)), this.inertialFrame, date, (CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).add(3.986004418E14));
    }

    private FieldUnivariateDerivative2<T> computeSatelliteEastLongitudeDegrees(FieldUnivariateDerivative2<T> tDays, FieldSinCos<FieldUnivariateDerivative2<T>> scW, FieldSinCos<FieldUnivariateDerivative2<T>> sc2W) {
        FieldUnivariateDerivative2 longitude = (FieldUnivariateDerivative2)tDays.multiply(tDays).multiply(this.elements.getLm2()).add(tDays.multiply(this.elements.getLm1())).add(this.elements.getLm0());
        FieldUnivariateDerivative2 cosineLongitudeTerm = ((FieldUnivariateDerivative2)scW.cos()).multiply((FieldUnivariateDerivative2)tDays.multiply(this.elements.getLonC1()).add(this.elements.getLonC()));
        FieldUnivariateDerivative2 sineLongitudeTerm = ((FieldUnivariateDerivative2)scW.sin()).multiply((FieldUnivariateDerivative2)tDays.multiply(this.elements.getLonS1()).add(this.elements.getLonS()));
        FieldUnivariateDerivative2 latitudeTerm = ((FieldUnivariateDerivative2)sc2W.sin()).multiply((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.elements.getLatC().multiply(this.elements.getLatC())).subtract((FieldElement)((CalculusFieldElement)this.elements.getLatS().multiply(this.elements.getLatS())))).multiply(0.5)).subtract(((FieldUnivariateDerivative2)sc2W.cos()).multiply((CalculusFieldElement)this.elements.getLatC().multiply(this.elements.getLatS()))).multiply(0.0087266462);
        return longitude.add(cosineLongitudeTerm).add(sineLongitudeTerm).add(latitudeTerm);
    }

    private FieldUnivariateDerivative2<T> computeSatelliteGeocentricLatitudeDegrees(FieldUnivariateDerivative2<T> tDays, FieldSinCos<FieldUnivariateDerivative2<T>> scW) {
        FieldUnivariateDerivative2 cosineTerm = ((FieldUnivariateDerivative2)scW.cos()).multiply((FieldUnivariateDerivative2)tDays.multiply(this.elements.getLatC1()).add(this.elements.getLatC()));
        FieldUnivariateDerivative2 sineTerm = ((FieldUnivariateDerivative2)scW.sin()).multiply((FieldUnivariateDerivative2)tDays.multiply(this.elements.getLatS1()).add(this.elements.getLatS()));
        return cosineTerm.add(sineTerm);
    }

    private FieldUnivariateDerivative2<T> computeSatelliteRadiusKilometers(T wDegreesPerDay, FieldSinCos<FieldUnivariateDerivative2<T>> scW) {
        CalculusFieldElement coefficient = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.elements.getLm1().multiply(2.0)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)wDegreesPerDay.subtract(this.elements.getLm1())).multiply(3.0)))).negate()).add(1.0)).multiply(42164.57);
        return ((FieldUnivariateDerivative2)scW.sin()).multiply((CalculusFieldElement)this.elements.getLonC().multiply(0.0087266462)).add(1.0).subtract(((FieldUnivariateDerivative2)scW.cos()).multiply((CalculusFieldElement)this.elements.getLonS().multiply(0.0087266462))).multiply(coefficient);
    }

    public FieldUnivariateDerivative2<T> getEastLongitudeDegrees() {
        return this.eastLongitudeDegrees;
    }

    public FieldUnivariateDerivative2<T> getGeocentricLatitudeDegrees() {
        return this.geocentricLatitudeDegrees;
    }

    public FieldUnivariateDerivative2<T> getOrbitRadius() {
        return this.orbitRadius;
    }

    @Override
    public Frame getFrame() {
        return this.inertialFrame;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    public FieldIntelsatElevenElements<T> getIntelsatElevenElements() {
        return this.elements;
    }
}

