/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss.data;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.analytical.gnss.SBASPropagator;
import org.orekit.propagation.analytical.gnss.SBASPropagatorBuilder;
import org.orekit.propagation.analytical.gnss.data.AbstractEphemerisMessage;
import org.orekit.propagation.analytical.gnss.data.SBASOrbitalElements;

public class SBASNavigationMessage
extends AbstractEphemerisMessage
implements SBASOrbitalElements {
    private double time;
    private double aGf0;
    private double aGf1;
    private double ura;
    private int iodn;

    @DefaultDataContext
    public SBASPropagator getPropagator() {
        return new SBASPropagatorBuilder(this).build();
    }

    public SBASPropagator getPropagator(Frames frames) {
        return new SBASPropagatorBuilder(this, frames).build();
    }

    public SBASPropagator getPropagator(Frames frames, AttitudeProvider provider, Frame inertial, Frame bodyFixed, double mass, double mu) {
        return new SBASPropagatorBuilder(this, frames).attitudeProvider(provider).eci(inertial).ecef(bodyFixed).mass(mass).mu(mu).build();
    }

    @Override
    public int getWeek() {
        return 0;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    @Override
    public int getIODN() {
        return this.iodn;
    }

    public void setIODN(double iod) {
        this.iodn = (int)iod;
    }

    @Override
    public double getAGf0() {
        return this.aGf0;
    }

    public void setAGf0(double a0) {
        this.aGf0 = a0;
    }

    @Override
    public double getAGf1() {
        return this.aGf1;
    }

    public void setAGf1(double a1) {
        this.aGf1 = a1;
    }

    public double getURA() {
        return this.ura;
    }

    public void setURA(double accuracy) {
        this.ura = accuracy;
    }
}

