/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss.data;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.analytical.gnss.GNSSPropagator;
import org.orekit.propagation.analytical.gnss.GNSSPropagatorBuilder;
import org.orekit.time.TimeStamped;

public interface GNSSOrbitalElements
extends TimeStamped {
    public int getPRN();

    public int getWeek();

    public double getTime();

    public double getSma();

    public double getMeanMotion();

    public double getE();

    public double getI0();

    public double getIDot();

    public double getOmega0();

    public double getOmegaDot();

    public double getPa();

    public double getM0();

    public double getCuc();

    public double getCus();

    public double getCrc();

    public double getCrs();

    public double getCic();

    public double getCis();

    public double getMu();

    public double getAngularVelocity();

    public double getCycleDuration();

    @DefaultDataContext
    default public GNSSPropagator getPropagator() {
        return new GNSSPropagatorBuilder(this).build();
    }

    default public GNSSPropagator getPropagator(Frames frames) {
        return new GNSSPropagatorBuilder(this, frames).build();
    }

    default public GNSSPropagator getPropagator(Frames frames, AttitudeProvider provider, Frame inertial, Frame bodyFixed, double mass) {
        return new GNSSPropagatorBuilder(this, frames).attitudeProvider(provider).eci(inertial).ecef(bodyFixed).mass(mass).build();
    }
}

