/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss.data;

import org.hipparchus.ode.nonstiff.ClassicalRungeKuttaIntegrator;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.propagation.analytical.gnss.data.AbstractEphemerisMessage;
import org.orekit.propagation.analytical.gnss.data.GLONASSOrbitalElements;
import org.orekit.propagation.numerical.GLONASSNumericalPropagator;
import org.orekit.propagation.numerical.GLONASSNumericalPropagatorBuilder;

public class GLONASSNavigationMessage
extends AbstractEphemerisMessage
implements GLONASSOrbitalElements {
    private double time;
    private double tauN;
    private double gammaN;
    private int frequencyNumber;
    private int statusFlags;
    private int healthFlags;
    private double groupDelayDifference;
    private double ura;

    @DefaultDataContext
    public GLONASSNumericalPropagator getPropagator(double step) {
        return new GLONASSNumericalPropagatorBuilder(new ClassicalRungeKuttaIntegrator(step), this, this.isAccAvailable()).build();
    }

    public GLONASSNumericalPropagator getPropagator(double step, DataContext context) {
        return new GLONASSNumericalPropagatorBuilder(new ClassicalRungeKuttaIntegrator(step), this, this.isAccAvailable(), context).build();
    }

    public GLONASSNumericalPropagator getPropagator(double step, DataContext context, AttitudeProvider provider, Frame inertial, double mass) {
        return new GLONASSNumericalPropagatorBuilder(new ClassicalRungeKuttaIntegrator(step), this, this.isAccAvailable(), context).attitudeProvider(provider).eci(inertial).mass(mass).build();
    }

    @Override
    public double getTN() {
        return this.tauN;
    }

    public void setTauN(double tn) {
        this.tauN = tn;
    }

    @Override
    public double getGammaN() {
        return this.gammaN;
    }

    public void setGammaN(double gammaN) {
        this.gammaN = gammaN;
    }

    public int getFrequencyNumber() {
        return this.frequencyNumber;
    }

    public void setFrequencyNumber(double frequencyNumber) {
        this.frequencyNumber = (int)frequencyNumber;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public int getStatusFlags() {
        return this.statusFlags;
    }

    public void setStatusFlags(double statusFlags) {
        this.statusFlags = (int)FastMath.rint((double)statusFlags);
    }

    public void setHealthFlags(double healthFlags) {
        this.healthFlags = Double.isNaN(healthFlags) ? 15 : (int)FastMath.rint((double)healthFlags);
    }

    public int getHealthFlags() {
        return this.healthFlags;
    }

    public double getGroupDelayDifference() {
        return this.groupDelayDifference;
    }

    public void setGroupDelayDifference(double groupDelayDifference) {
        this.groupDelayDifference = Double.isNaN(groupDelayDifference) ? 9.99999999999E8 : groupDelayDifference;
    }

    public double getURA() {
        return this.ura;
    }

    public void setURA(double accuracy) {
        this.ura = accuracy;
    }

    private boolean isAccAvailable() {
        return this.getXDotDot() != 0.0 || this.getYDotDot() != 0.0 || this.getZDotDot() != 0.0;
    }
}

