/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss.data;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.propagation.analytical.gnss.GLONASSAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.GLONASSAnalyticalPropagatorBuilder;
import org.orekit.propagation.analytical.gnss.data.GLONASSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.GLONASSDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;

public class GLONASSAlmanac
implements GLONASSOrbitalElements {
    private final int channel;
    private final int health;
    private final int day;
    private final int month;
    private final int year;
    private final double ta;
    private final double lambda;
    private final double deltaI;
    private final double pa;
    private final double ecc;
    private final double deltaT;
    private final double deltaTDot;
    private final double tGlo2UTC;
    private final double tGPS2Glo;
    private final double tGlo;
    private final TimeScale glonass;

    @DefaultDataContext
    public GLONASSAlmanac(int channel, int health, int day, int month, int year, double ta, double lambda, double deltaI, double pa, double ecc, double deltaT, double deltaTDot, double tGlo2UTC, double tGPS2Glo, double tGlo) {
        this(channel, health, day, month, year, ta, lambda, deltaI, pa, ecc, deltaT, deltaTDot, tGlo2UTC, tGPS2Glo, tGlo, DataContext.getDefault().getTimeScales().getGLONASS());
    }

    public GLONASSAlmanac(int channel, int health, int day, int month, int year, double ta, double lambda, double deltaI, double pa, double ecc, double deltaT, double deltaTDot, double tGlo2UTC, double tGPS2Glo, double tGlo, TimeScale glonass) {
        this.channel = channel;
        this.health = health;
        this.day = day;
        this.month = month;
        this.year = year;
        this.ta = ta;
        this.lambda = lambda;
        this.deltaI = deltaI;
        this.pa = pa;
        this.ecc = ecc;
        this.deltaT = deltaT;
        this.deltaTDot = deltaTDot;
        this.tGlo2UTC = tGlo2UTC;
        this.tGPS2Glo = tGPS2Glo;
        this.tGlo = tGlo;
        this.glonass = glonass;
    }

    @DefaultDataContext
    public GLONASSAnalyticalPropagator getPropagator() {
        return new GLONASSAnalyticalPropagatorBuilder(this).build();
    }

    public GLONASSAnalyticalPropagator getPropagator(DataContext context) {
        return new GLONASSAnalyticalPropagatorBuilder(this, context).build();
    }

    public GLONASSAnalyticalPropagator getPropagator(DataContext context, AttitudeProvider provider, Frame inertial, Frame bodyFixed, double mass) {
        return new GLONASSAnalyticalPropagatorBuilder(this, context).attitudeProvider(provider).eci(inertial).ecef(bodyFixed).mass(mass).build();
    }

    @Override
    public AbsoluteDate getDate() {
        DateComponents date = new DateComponents(this.year, this.month, this.day);
        TimeComponents time = new TimeComponents(this.ta);
        return new AbsoluteDate(date, time, this.glonass);
    }

    @Override
    public double getTime() {
        return this.ta;
    }

    @Override
    public double getLambda() {
        return this.lambda;
    }

    @Override
    public double getE() {
        return this.ecc;
    }

    @Override
    public double getPa() {
        return this.pa;
    }

    @Override
    public double getDeltaI() {
        return this.deltaI;
    }

    @Override
    public double getDeltaT() {
        return this.deltaT;
    }

    @Override
    public double getDeltaTDot() {
        return this.deltaTDot;
    }

    public int getHealth() {
        return this.health;
    }

    public int getFrequencyChannel() {
        return this.channel;
    }

    public double getGlo2UTC() {
        return this.tGlo2UTC;
    }

    public double getGPS2Glo() {
        return this.tGPS2Glo;
    }

    public double getGloOffset() {
        return this.tGlo;
    }

    @Override
    public int getNa() {
        GLONASSDate gloDate = new GLONASSDate(this.getDate(), this.glonass);
        return gloDate.getDayNumber();
    }

    @Override
    public int getN4() {
        GLONASSDate gloDate = new GLONASSDate(this.getDate(), this.glonass);
        return gloDate.getIntervalNumber();
    }
}

