/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss.data;

import org.hipparchus.util.FastMath;
import org.orekit.propagation.analytical.gnss.data.CommonGnssData;
import org.orekit.propagation.analytical.gnss.data.GNSSOrbitalElements;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractNavigationMessage
extends CommonGnssData
implements GNSSOrbitalElements {
    private double sqrtA;
    private double deltaN;
    private double iDot;
    private double af2;
    private AbsoluteDate epochToc;
    private double cuc;
    private double cus;
    private double crc;
    private double crs;
    private double cic;
    private double cis;
    private double transmissionTime;

    public AbstractNavigationMessage(double mu, double angularVelocity, int weekNumber) {
        super(mu, angularVelocity, weekNumber);
    }

    public double getSqrtA() {
        return this.sqrtA;
    }

    public void setSqrtA(double sqrtA) {
        this.sqrtA = sqrtA;
        this.setSma(sqrtA * sqrtA);
    }

    @Override
    public double getMeanMotion() {
        double absA = FastMath.abs((double)this.getSma());
        return FastMath.sqrt((double)(this.getMu() / absA)) / absA + this.deltaN;
    }

    public double getDeltaN() {
        return this.deltaN;
    }

    public void setDeltaN(double deltaN) {
        this.deltaN = deltaN;
    }

    @Override
    public double getIDot() {
        return this.iDot;
    }

    public void setIDot(double iRate) {
        this.iDot = iRate;
    }

    public double getAf2() {
        return this.af2;
    }

    public void setAf2(double af2) {
        this.af2 = af2;
    }

    public AbsoluteDate getEpochToc() {
        return this.epochToc;
    }

    public void setEpochToc(AbsoluteDate epochToc) {
        this.epochToc = epochToc;
    }

    @Override
    public double getCuc() {
        return this.cuc;
    }

    public void setCuc(double cuc) {
        this.cuc = cuc;
    }

    @Override
    public double getCus() {
        return this.cus;
    }

    public void setCus(double cus) {
        this.cus = cus;
    }

    @Override
    public double getCrc() {
        return this.crc;
    }

    public void setCrc(double crc) {
        this.crc = crc;
    }

    @Override
    public double getCrs() {
        return this.crs;
    }

    public void setCrs(double crs) {
        this.crs = crs;
    }

    @Override
    public double getCic() {
        return this.cic;
    }

    public void setCic(double cic) {
        this.cic = cic;
    }

    @Override
    public double getCis() {
        return this.cis;
    }

    public void setCis(double cis) {
        this.cis = cis;
    }

    public double getTransmissionTime() {
        return this.transmissionTime;
    }

    public void setTransmissionTime(double transmissionTime) {
        this.transmissionTime = transmissionTime;
    }
}

