/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.analytical.gnss.SBASPropagator;
import org.orekit.propagation.analytical.gnss.data.SBASOrbitalElements;
import org.orekit.utils.IERSConventions;

public class SBASPropagatorBuilder {
    private final SBASOrbitalElements orbit;
    private double mu;
    private AttitudeProvider attitudeProvider;
    private double mass;
    private Frame eci;
    private Frame ecef;

    @DefaultDataContext
    public SBASPropagatorBuilder(SBASOrbitalElements sbasOrbElt) {
        this(sbasOrbElt, DataContext.getDefault().getFrames());
    }

    public SBASPropagatorBuilder(SBASOrbitalElements sbasOrbElt, Frames frames) {
        this.orbit = sbasOrbElt;
        this.mass = 1000.0;
        this.eci = frames.getEME2000();
        this.ecef = frames.getITRF(IERSConventions.IERS_2010, true);
        this.mu = 3.986005E14;
        this.attitudeProvider = new FrameAlignedProvider(this.eci);
    }

    public SBASPropagatorBuilder attitudeProvider(AttitudeProvider userProvider) {
        this.attitudeProvider = userProvider;
        return this;
    }

    public SBASPropagatorBuilder mu(double coefficient) {
        this.mu = coefficient;
        return this;
    }

    public SBASPropagatorBuilder mass(double userMass) {
        this.mass = userMass;
        return this;
    }

    public SBASPropagatorBuilder eci(Frame inertial) {
        this.eci = inertial;
        return this;
    }

    public SBASPropagatorBuilder ecef(Frame bodyFixed) {
        this.ecef = bodyFixed;
        return this;
    }

    public SBASPropagator build() {
        return new SBASPropagator(this.orbit, this.eci, this.ecef, this.attitudeProvider, this.mass, this.mu);
    }
}

