/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.propagation.analytical.gnss.GNSSPropagator;
import org.orekit.propagation.analytical.gnss.data.GNSSOrbitalElements;
import org.orekit.utils.IERSConventions;

public class GNSSPropagatorBuilder {
    private final GNSSOrbitalElements orbit;
    private AttitudeProvider attitudeProvider;
    private double mass;
    private Frame eci;
    private Frame ecef;

    @DefaultDataContext
    public GNSSPropagatorBuilder(GNSSOrbitalElements gnssOrbElt) {
        this(gnssOrbElt, DataContext.getDefault().getFrames());
    }

    public GNSSPropagatorBuilder(GNSSOrbitalElements gnssOrbElt, Frames frames) {
        this.orbit = gnssOrbElt;
        this.mass = 1000.0;
        this.eci = frames.getEME2000();
        this.ecef = frames.getITRF(IERSConventions.IERS_2010, true);
        this.attitudeProvider = FrameAlignedProvider.of(this.eci);
    }

    public GNSSPropagatorBuilder attitudeProvider(AttitudeProvider userProvider) {
        this.attitudeProvider = userProvider;
        return this;
    }

    public GNSSPropagatorBuilder mass(double userMass) {
        this.mass = userMass;
        return this;
    }

    public GNSSPropagatorBuilder eci(Frame inertial) {
        this.eci = inertial;
        return this;
    }

    public GNSSPropagatorBuilder ecef(Frame bodyFixed) {
        this.ecef = bodyFixed;
        return this;
    }

    public GNSSPropagator build() {
        return new GNSSPropagator(this.orbit, this.eci, this.ecef, this.attitudeProvider, this.mass);
    }
}

