/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.List;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalGradientConverter;
import org.orekit.propagation.analytical.FieldKeplerianPropagator;
import org.orekit.propagation.analytical.KeplerianPropagator;
import org.orekit.utils.ParameterDriver;

class KeplerianGradientConverter
extends AbstractAnalyticalGradientConverter {
    public static final int FREE_STATE_PARAMETERS = 6;
    private final KeplerianPropagator propagator;

    KeplerianGradientConverter(KeplerianPropagator propagator) {
        super(propagator, propagator.getInitialState().getMu(), 6);
        this.propagator = propagator;
    }

    public FieldKeplerianPropagator<Gradient> getPropagator(FieldSpacecraftState<Gradient> state, Gradient[] parameters) {
        Gradient zero = state.getA().getField().getZero();
        AttitudeProvider provider = this.propagator.getAttitudeProvider();
        Gradient mu = zero.newInstance(this.propagator.getInitialState().getMu());
        return new FieldKeplerianPropagator<Gradient>(state.getOrbit(), provider, mu);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

