/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.utils.FieldArrayDictionary;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;

public class FieldKeplerianPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    private transient FieldTimeSpanMap<FieldSpacecraftState<T>, T> states;

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit) {
        this((FieldOrbit<CalculusFieldElement>)initialFieldOrbit, FrameAlignedProvider.of(initialFieldOrbit.getFrame()), (CalculusFieldElement)initialFieldOrbit.getMu(), (CalculusFieldElement)((CalculusFieldElement)initialFieldOrbit.getA().getField().getZero()).newInstance(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, T mu) {
        this((FieldOrbit<CalculusFieldElement>)initialFieldOrbit, FrameAlignedProvider.of(initialFieldOrbit.getFrame()), (CalculusFieldElement)mu, (CalculusFieldElement)((CalculusFieldElement)initialFieldOrbit.getA().getField().getZero()).newInstance(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, AttitudeProvider attitudeProv) {
        this((FieldOrbit<CalculusFieldElement>)initialFieldOrbit, attitudeProv, (CalculusFieldElement)initialFieldOrbit.getMu(), (CalculusFieldElement)((CalculusFieldElement)initialFieldOrbit.getA().getField().getZero()).newInstance(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialFieldOrbit, AttitudeProvider attitudeProv, T mu) {
        this((FieldOrbit<CalculusFieldElement>)initialFieldOrbit, attitudeProv, (CalculusFieldElement)mu, (CalculusFieldElement)((CalculusFieldElement)initialFieldOrbit.getA().getField().getZero()).newInstance(1000.0));
    }

    public FieldKeplerianPropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mu, T mass) {
        super(initialOrbit.getA().getField(), attitudeProv);
        FieldSpacecraftState<T> initial = this.fixState(initialOrbit, this.getAttitudeProvider().getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass, mu, null, null);
        this.states = new FieldTimeSpanMap(initial, initialOrbit.getA().getField());
        super.resetInitialState(initial);
    }

    private FieldSpacecraftState<T> fixState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass, T mu, FieldArrayDictionary<T> additionalStates, FieldArrayDictionary<T> additionalStatesderivatives) {
        OrbitType type = orbit.getType();
        CalculusFieldElement[] stateVector = (CalculusFieldElement[])MathArrays.buildArray((Field)mass.getField(), (int)6);
        PositionAngleType positionAngleType = PositionAngleType.MEAN;
        type.mapOrbitToArray(orbit, positionAngleType, stateVector, null);
        FieldOrbit fixedOrbit = type.mapArrayToOrbit(stateVector, null, positionAngleType, orbit.getDate(), (CalculusFieldElement)mu, orbit.getFrame());
        FieldSpacecraftState fixedState = new FieldSpacecraftState(fixedOrbit, attitude, mass);
        if (additionalStates != null) {
            for (FieldArrayDictionary.Entry entry : additionalStates.getData()) {
                fixedState = fixedState.addAdditionalState(entry.getKey(), entry.getValue());
            }
        }
        if (additionalStatesderivatives != null) {
            for (FieldArrayDictionary.Entry entry : additionalStatesderivatives.getData()) {
                fixedState = fixedState.addAdditionalStateDerivative(entry.getKey(), entry.getValue());
            }
        }
        return fixedState;
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        FieldSpacecraftState formerInitial = this.getInitialState();
        T mu = formerInitial == null ? state.getMu() : formerInitial.getMu();
        FieldSpacecraftState<T> fixedState = this.fixState(state.getOrbit(), state.getAttitude(), state.getMass(), mu, state.getAdditionalStatesValues(), state.getAdditionalStatesDerivatives());
        this.states = new FieldTimeSpanMap<FieldSpacecraftState<FieldSpacecraftState<T>>, FieldSpacecraftState<T>>(fixedState, state.getDate().getField());
        super.resetInitialState(fixedState);
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        if (forward) {
            this.states.addValidAfter(state, state.getDate());
        } else {
            this.states.addValidBefore(state, state.getDate());
        }
        this.stateChanged(state);
    }

    @Override
    protected FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date, T[] parameters) {
        FieldTimeShiftable orbit = this.states.get(date).getOrbit();
        while (!date.equals(((FieldOrbit)(orbit = ((FieldOrbit)orbit).shiftedBy((CalculusFieldElement)date.durationFrom(((FieldOrbit)orbit).getDate())))).getDate())) {
        }
        return orbit;
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return this.states.get(date).getMass();
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

