/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathUtils;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldKeplerianAnomalyUtility;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;

public class FieldBrouwerLyddanePropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T> {
    private static final double SCALE = FastMath.scalb((double)1.0, (int)-32);
    private static final double BETA = FastMath.scalb((float)100.0f, (int)-11);
    private static final double MAX_ECC = 0.999999;
    private FieldBLModel<T> initialModel;
    private transient FieldTimeSpanMap<FieldBLModel<T>, T> models;
    private double referenceRadius;
    private T mu;
    private double[] ck0;
    private final ParameterDriver M2Driver;

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)initialOrbit.getMu().newInstance(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitude, T mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, double M2) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitude, (CalculusFieldElement)mass, provider.getAe(), (CalculusFieldElement)initialOrbit.getMu().newInstance(provider.getMu()), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double M2) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)initialOrbit.getMu().newInstance(1000.0), referenceRadius, (CalculusFieldElement)mu, c20, c30, c40, c50, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, T mass, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), mass, referenceRadius, mu, c20, c30, c40, c50, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, attitudeProv, (CalculusFieldElement)initialOrbit.getMu().newInstance(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double M2) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitudeProv, (CalculusFieldElement)initialOrbit.getMu().newInstance(1000.0), referenceRadius, (CalculusFieldElement)mu, c20, c30, c40, c50, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, attitudeProv, mass, referenceRadius, mu, c20, c30, c40, c50, PropagationType.OSCULATING, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), (CalculusFieldElement)initialOrbit.getMu().newInstance(1000.0), provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), initialType, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType, double M2) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate().toAbsoluteDate()), initialType, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitude, T mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, PropagationType initialType, double M2) {
        this((FieldOrbit<CalculusFieldElement>)initialOrbit, attitude, (CalculusFieldElement)mass, provider.getAe(), (CalculusFieldElement)initialOrbit.getMu().newInstance(provider.getMu()), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), initialType, M2);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, PropagationType initialType, double M2) {
        this(initialOrbit, attitudeProv, mass, referenceRadius, mu, c20, c30, c40, c50, initialType, M2, 1.0E-13, 200);
    }

    public FieldBrouwerLyddanePropagator(FieldOrbit<T> initialOrbit, AttitudeProvider attitudeProv, T mass, double referenceRadius, T mu, double c20, double c30, double c40, double c50, PropagationType initialType, double M2, double epsilon, int maxIterations) {
        super(mass.getField(), attitudeProv);
        this.referenceRadius = referenceRadius;
        this.mu = mu;
        this.ck0 = new double[]{0.0, 0.0, c20, c30, c40, c50};
        this.M2Driver = new ParameterDriver("M2", M2, SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.resetInitialState(new FieldSpacecraftState<T>(initialOrbit, attitudeProv.getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass), initialType, epsilon, maxIterations);
    }

    public static <T extends CalculusFieldElement<T>> FieldKeplerianOrbit<T> computeMeanOrbit(FieldOrbit<T> osculating, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, double M2Value) {
        return FieldBrouwerLyddanePropagator.computeMeanOrbit(osculating, provider, harmonics, M2Value, 1.0E-13, 200);
    }

    public static <T extends CalculusFieldElement<T>> FieldKeplerianOrbit<T> computeMeanOrbit(FieldOrbit<T> osculating, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, double M2Value, double epsilon, int maxIterations) {
        return FieldBrouwerLyddanePropagator.computeMeanOrbit(osculating, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), M2Value, epsilon, maxIterations);
    }

    public static <T extends CalculusFieldElement<T>> FieldKeplerianOrbit<T> computeMeanOrbit(FieldOrbit<T> osculating, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2Value, double epsilon, int maxIterations) {
        FieldBrouwerLyddanePropagator<CalculusFieldElement> propagator = new FieldBrouwerLyddanePropagator<CalculusFieldElement>(osculating, FrameAlignedProvider.of(osculating.getFrame()), (CalculusFieldElement)osculating.getMu().newInstance(1000.0), referenceRadius, (CalculusFieldElement)osculating.getMu().newInstance(mu), c20, c30, c40, c50, PropagationType.OSCULATING, M2Value, epsilon, maxIterations);
        return ((FieldBLModel)propagator.initialModel).mean;
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        this.resetInitialState(state, PropagationType.OSCULATING);
    }

    public void resetInitialState(FieldSpacecraftState<T> state, PropagationType stateType) {
        this.resetInitialState(state, stateType, 1.0E-13, 200);
    }

    public void resetInitialState(FieldSpacecraftState<T> state, PropagationType stateType, double epsilon, int maxIterations) {
        super.resetInitialState(state);
        FieldKeplerianOrbit keplerian = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(state.getOrbit());
        this.initialModel = stateType == PropagationType.MEAN ? new FieldBLModel<T>(keplerian, state.getMass(), this.referenceRadius, this.mu, this.ck0) : this.computeMeanParameters(keplerian, state.getMass(), epsilon, maxIterations);
        this.models = new FieldTimeSpanMap(this.initialModel, state.getA().getField());
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        this.resetIntermediateState(state, forward, 1.0E-13, 200);
    }

    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward, double epsilon, int maxIterations) {
        FieldBLModel<T> newModel = this.computeMeanParameters((FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(state.getOrbit()), state.getMass(), epsilon, maxIterations);
        if (forward) {
            this.models.addValidAfter(newModel, state.getDate());
        } else {
            this.models.addValidBefore(newModel, state.getDate());
        }
        this.stateChanged(state);
    }

    private FieldBLModel<T> computeMeanParameters(FieldKeplerianOrbit<T> osculating, T mass, double epsilon, int maxIterations) {
        double damping = 1.0;
        if (osculating.getA().getReal() < this.referenceRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, osculating.getA());
        }
        Field field = osculating.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement pi = (CalculusFieldElement)zero.getPi();
        FieldBLModel<T> current = new FieldBLModel<T>(osculating, mass, this.referenceRadius, this.mu, this.ck0);
        Object sma = osculating.getA();
        Object ex = osculating.getEquinoctialEx();
        Object ey = osculating.getEquinoctialEy();
        Object hx = osculating.getHx();
        Object hy = osculating.getHy();
        Object lv = osculating.getLv();
        CalculusFieldElement thresholdA = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)osculating.getA().abs()).add(1.0)).multiply(epsilon);
        CalculusFieldElement thresholdE = (CalculusFieldElement)((CalculusFieldElement)FastMath.hypot(ex, ey).add(1.0)).multiply(epsilon);
        CalculusFieldElement thresholdH = (CalculusFieldElement)((CalculusFieldElement)FastMath.hypot(hx, hy).add(1.0)).multiply(epsilon);
        CalculusFieldElement thresholdLv = (CalculusFieldElement)pi.multiply(epsilon);
        int i = 0;
        while (i++ < maxIterations) {
            FieldKeplerianOrbit parameters = current.propagateParameters(((FieldBLModel)current).mean.getDate(), this.getParameters(field, ((FieldBLModel)current).mean.getDate()));
            CalculusFieldElement deltaA = (CalculusFieldElement)osculating.getA().subtract(parameters.getA());
            CalculusFieldElement deltaEx = (CalculusFieldElement)osculating.getEquinoctialEx().subtract(parameters.getEquinoctialEx());
            CalculusFieldElement deltaEy = (CalculusFieldElement)osculating.getEquinoctialEy().subtract(parameters.getEquinoctialEy());
            CalculusFieldElement deltaHx = (CalculusFieldElement)osculating.getHx().subtract(parameters.getHx());
            CalculusFieldElement deltaHy = (CalculusFieldElement)osculating.getHy().subtract(parameters.getHy());
            CalculusFieldElement deltaLv = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)osculating.getLv().subtract(parameters.getLv())), (CalculusFieldElement)zero);
            sma = (CalculusFieldElement)sma.add((FieldElement)((CalculusFieldElement)deltaA.multiply(1.0)));
            ex = (CalculusFieldElement)ex.add((FieldElement)((CalculusFieldElement)deltaEx.multiply(1.0)));
            ey = (CalculusFieldElement)ey.add((FieldElement)((CalculusFieldElement)deltaEy.multiply(1.0)));
            hx = (CalculusFieldElement)hx.add((FieldElement)((CalculusFieldElement)deltaHx.multiply(1.0)));
            hy = (CalculusFieldElement)hy.add((FieldElement)((CalculusFieldElement)deltaHy.multiply(1.0)));
            lv = (CalculusFieldElement)lv.add((FieldElement)((CalculusFieldElement)deltaLv.multiply(1.0)));
            FieldEquinoctialOrbit<T> meanEquinoctial = new FieldEquinoctialOrbit<T>(sma, ex, ey, hx, hy, lv, PositionAngleType.TRUE, osculating.getFrame(), osculating.getDate(), osculating.getMu());
            FieldKeplerianOrbit meanKeplerian = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(meanEquinoctial);
            current = new FieldBLModel<T>(meanKeplerian, mass, this.referenceRadius, this.mu, this.ck0);
            if (!(FastMath.abs((double)deltaA.getReal()) < thresholdA.getReal()) || !(FastMath.abs((double)deltaEx.getReal()) < thresholdE.getReal()) || !(FastMath.abs((double)deltaEy.getReal()) < thresholdE.getReal()) || !(FastMath.abs((double)deltaHx.getReal()) < thresholdH.getReal()) || !(FastMath.abs((double)deltaHy.getReal()) < thresholdH.getReal()) || !(FastMath.abs((double)deltaLv.getReal()) < thresholdLv.getReal())) continue;
            return current;
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_BROUWER_LYDDANE_MEAN_PARAMETERS, i);
    }

    @Override
    public FieldKeplerianOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date, T[] parameters) {
        FieldBLModel<T> current = this.models.get(date);
        return current.propagateParameters(date, (CalculusFieldElement[])parameters);
    }

    public double getM2() {
        return this.M2Driver.getValue();
    }

    public double getM2(AbsoluteDate date) {
        return this.M2Driver.getValue(date);
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return (T)((FieldBLModel)this.models.get(date)).mass;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.M2Driver);
    }

    private static class FieldBLModel<T extends CalculusFieldElement<T>> {
        private final T mass;
        private final T mu;
        private final FieldKeplerianOrbit<T> mean;
        private final T n0;
        private final T n;
        private final T n2;
        private final T n3;
        private final T t8;
        private final T dsl;
        private final T dsg;
        private final T dsh;
        private final T aRate;
        private final T eRate;
        private final T yp2;
        private final T ci;
        private final T si;
        private final T oneMci2;
        private final T ci2X3M1;
        private final T vle1;
        private final T vle2;
        private final T vle3;
        private final T vli1;
        private final T vli2;
        private final T vli3;
        private final T vll2;
        private final T vlh1I;
        private final T vlh2I;
        private final T vlh3I;
        private final T vls1;
        private final T vls2;
        private final T vls3;

        FieldBLModel(FieldKeplerianOrbit<T> mean, T mass, double referenceRadius, T mu, double[] ck0) {
            this.mass = mass;
            this.mu = mu;
            this.mean = mean;
            CalculusFieldElement one = (CalculusFieldElement)mass.getField().getOne();
            T epp = mean.getE();
            if (epp.getReal() >= 1.0) {
                throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, epp.getReal());
            }
            CalculusFieldElement epp2 = (CalculusFieldElement)epp.square();
            this.n2 = (CalculusFieldElement)one.subtract((FieldElement)epp2);
            this.n = (CalculusFieldElement)this.n2.sqrt();
            this.n3 = (CalculusFieldElement)this.n2.multiply(this.n);
            this.t8 = (CalculusFieldElement)this.n.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)one.add(this.n)).reciprocal()));
            T app = mean.getA();
            this.n0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mu.divide(app)).sqrt()).divide(app);
            CalculusFieldElement q = (CalculusFieldElement)((CalculusFieldElement)app.divide(referenceRadius)).reciprocal();
            CalculusFieldElement ql = (CalculusFieldElement)q.square();
            CalculusFieldElement nl = (CalculusFieldElement)this.n2.square();
            this.yp2 = (CalculusFieldElement)((CalculusFieldElement)ql.multiply(-0.5 * ck0[2])).divide((FieldElement)nl);
            CalculusFieldElement yp22 = (CalculusFieldElement)this.yp2.square();
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            nl = (CalculusFieldElement)nl.multiply(this.n2);
            CalculusFieldElement yp3 = (CalculusFieldElement)((CalculusFieldElement)ql.multiply(ck0[3])).divide((FieldElement)nl);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            nl = (CalculusFieldElement)nl.multiply(this.n2);
            CalculusFieldElement yp4 = (CalculusFieldElement)((CalculusFieldElement)ql.multiply(0.375 * ck0[4])).divide((FieldElement)nl);
            ql = (CalculusFieldElement)ql.multiply((FieldElement)q);
            nl = (CalculusFieldElement)nl.multiply(this.n2);
            CalculusFieldElement yp5 = (CalculusFieldElement)((CalculusFieldElement)ql.multiply(ck0[5])).divide((FieldElement)nl);
            FieldSinCos sc = FastMath.sinCos(mean.getI());
            this.si = (CalculusFieldElement)sc.sin();
            this.ci = (CalculusFieldElement)sc.cos();
            CalculusFieldElement ci2 = (CalculusFieldElement)this.ci.square();
            this.oneMci2 = (CalculusFieldElement)one.subtract((FieldElement)ci2);
            this.ci2X3M1 = (CalculusFieldElement)((CalculusFieldElement)ci2.multiply(3.0)).subtract((FieldElement)one);
            CalculusFieldElement ci2X5M1 = (CalculusFieldElement)((CalculusFieldElement)ci2.multiply(5.0)).subtract((FieldElement)one);
            CalculusFieldElement dsl1 = (CalculusFieldElement)((CalculusFieldElement)this.yp2.multiply(this.n)).multiply(1.5);
            CalculusFieldElement dsl2a = (CalculusFieldElement)((CalculusFieldElement)this.n.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(25.0)).add(16.0)))).subtract(15.0);
            CalculusFieldElement dsl2b = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(90.0)).add(96.0)))).negate()).add(30.0);
            CalculusFieldElement dsl2c = (CalculusFieldElement)((CalculusFieldElement)this.n.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(25.0)).add(144.0)))).add(105.0);
            CalculusFieldElement dsl21 = (CalculusFieldElement)dsl2a.add((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)dsl2b.add((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)dsl2c)))))));
            CalculusFieldElement dsl2 = (CalculusFieldElement)this.ci2X3M1.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.yp2.multiply(0.0625)).multiply((FieldElement)dsl21)));
            CalculusFieldElement dsl3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp4.multiply(this.n)).multiply((FieldElement)epp2)).multiply(0.9375)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ci2.multiply(35.0)).subtract(30.0)).multiply((FieldElement)ci2)).add(3.0)));
            this.dsl = (CalculusFieldElement)((CalculusFieldElement)dsl1.multiply((FieldElement)dsl2)).add((FieldElement)dsl3);
            CalculusFieldElement dsg1 = (CalculusFieldElement)((CalculusFieldElement)this.yp2.multiply(1.5)).multiply((FieldElement)ci2X5M1);
            CalculusFieldElement dsg2a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(25.0)).add(24.0)).multiply(this.n)).add(-35.0);
            CalculusFieldElement dsg2b = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(126.0)).add(192.0)).multiply(this.n)).negate()).add(90.0);
            CalculusFieldElement dsg2c = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(45.0)).add(360.0)).multiply(this.n)).add(385.0);
            CalculusFieldElement dsg21 = (CalculusFieldElement)dsg2a.add((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)dsg2b.add((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)dsg2c)))))));
            CalculusFieldElement dsg2 = (CalculusFieldElement)((CalculusFieldElement)yp22.multiply(0.09375)).multiply((FieldElement)dsg21);
            CalculusFieldElement dsg3a = (CalculusFieldElement)((CalculusFieldElement)this.n2.multiply(-9.0)).add(21.0);
            CalculusFieldElement dsg3b = (CalculusFieldElement)((CalculusFieldElement)this.n2.multiply(126.0)).add(-270.0);
            CalculusFieldElement dsg3c = (CalculusFieldElement)((CalculusFieldElement)this.n2.multiply(-189.0)).add(385.0);
            CalculusFieldElement dsg31 = (CalculusFieldElement)dsg3a.add((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)dsg3b.add((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)dsg3c)))))));
            CalculusFieldElement dsg3 = (CalculusFieldElement)((CalculusFieldElement)yp4.multiply(0.3125)).multiply((FieldElement)dsg31);
            this.dsg = (CalculusFieldElement)((CalculusFieldElement)dsg1.add((FieldElement)dsg2)).add((FieldElement)dsg3);
            CalculusFieldElement dsh1 = (CalculusFieldElement)this.yp2.multiply(-3.0);
            CalculusFieldElement dsh2a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(9.0)).add(12.0)).multiply(this.n)).add(-5.0);
            CalculusFieldElement dsh2b = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(5.0)).add(36.0)).multiply(this.n)).add(35.0);
            CalculusFieldElement dsh21 = (CalculusFieldElement)dsh2a.subtract((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)dsh2b)));
            CalculusFieldElement dsh2 = (CalculusFieldElement)((CalculusFieldElement)yp22.multiply(0.375)).multiply((FieldElement)dsh21);
            CalculusFieldElement dsh31 = (CalculusFieldElement)((CalculusFieldElement)this.n2.multiply(3.0)).subtract(5.0);
            CalculusFieldElement dsh32 = (CalculusFieldElement)((CalculusFieldElement)ci2.multiply(7.0)).subtract(3.0);
            CalculusFieldElement dsh3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yp4.multiply(1.25)).multiply((FieldElement)dsh31)).multiply((FieldElement)dsh32);
            this.dsh = (CalculusFieldElement)this.ci.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)dsh1.add((FieldElement)dsh2)).add((FieldElement)dsh3)));
            CalculusFieldElement coef = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n0.multiply((FieldElement)((CalculusFieldElement)one.add(this.dsl)))).multiply(3.0)).reciprocal()).multiply(-4);
            this.aRate = (CalculusFieldElement)coef.multiply(app);
            this.eRate = (CalculusFieldElement)((CalculusFieldElement)coef.multiply(epp)).multiply(this.n2);
            T t2 = this.T2(this.ci);
            CalculusFieldElement fs12 = (CalculusFieldElement)yp3.divide(this.yp2);
            CalculusFieldElement fs13 = (CalculusFieldElement)((CalculusFieldElement)yp4.multiply(10)).divide((FieldElement)((CalculusFieldElement)this.yp2.multiply(3)));
            CalculusFieldElement fs14 = (CalculusFieldElement)yp5.divide(this.yp2);
            CalculusFieldElement ci2Xt2 = (CalculusFieldElement)ci2.multiply(t2);
            CalculusFieldElement cA = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ci2Xt2.multiply(40.0)).add(11.0)))));
            CalculusFieldElement cB = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ci2Xt2.multiply(8.0)).add(3.0)))));
            CalculusFieldElement cC = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ci2Xt2.multiply(24.0)).add(9.0)))));
            CalculusFieldElement cD = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ci2Xt2.multiply(16.0)).add(5.0)))));
            CalculusFieldElement cE = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ci2Xt2.multiply(200.0)).add(33.0)))));
            CalculusFieldElement cF = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)ci2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ci2Xt2.multiply(40.0)).add(9.0)))));
            CalculusFieldElement p5p = (CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)ci2Xt2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ci2Xt2.multiply(20.0)).add(8.0)))));
            CalculusFieldElement p5p2 = (CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)p5p.multiply(2.0)));
            CalculusFieldElement p5p4 = (CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)p5p.multiply(4.0)));
            CalculusFieldElement p5p10 = (CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)p5p.multiply(10.0)));
            CalculusFieldElement e2X3P4 = (CalculusFieldElement)((CalculusFieldElement)epp2.multiply(3.0)).add(4.0);
            CalculusFieldElement ciO1Pci = (CalculusFieldElement)this.ci.divide((FieldElement)((CalculusFieldElement)one.add(this.ci)));
            CalculusFieldElement oneMci = (CalculusFieldElement)one.subtract(this.ci);
            CalculusFieldElement q1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.yp2.multiply((FieldElement)cA)).subtract((FieldElement)((CalculusFieldElement)fs13.multiply((FieldElement)cB)))).multiply(0.125);
            CalculusFieldElement q2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.yp2.multiply((FieldElement)p5p10)).subtract((FieldElement)((CalculusFieldElement)fs13.multiply((FieldElement)p5p2)))).multiply((FieldElement)epp2)).multiply(this.ci)).multiply(0.125);
            CalculusFieldElement q5 = (CalculusFieldElement)((CalculusFieldElement)fs12.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2X3P4.multiply((FieldElement)fs14)).multiply((FieldElement)cC)).multiply(0.3125)))).multiply(0.25);
            CalculusFieldElement p2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)p5p2.multiply(epp)).multiply(this.ci)).multiply(this.si)).multiply((FieldElement)e2X3P4)).multiply((FieldElement)fs14)).multiply(0.46875);
            CalculusFieldElement p3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply(this.si)).multiply((FieldElement)fs14)).multiply((FieldElement)cC)).multiply(0.15625);
            double kf = 0.030381944444444444;
            CalculusFieldElement p4 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply((FieldElement)fs14)).multiply((FieldElement)cD)).multiply(0.030381944444444444);
            CalculusFieldElement p5 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply((FieldElement)epp2)).multiply(this.ci)).multiply(this.si)).multiply((FieldElement)fs14)).multiply((FieldElement)p5p4)).multiply(0.06076388888888889);
            this.vle1 = (CalculusFieldElement)((CalculusFieldElement)epp.multiply(this.n2)).multiply((FieldElement)q1);
            this.vle2 = (CalculusFieldElement)((CalculusFieldElement)this.n2.multiply(this.si)).multiply((FieldElement)q5);
            this.vle3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply(this.n2)).multiply(this.si)).multiply((FieldElement)p4)).multiply(-3.0);
            this.vli1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply((FieldElement)q1)).divide(this.si)).negate();
            this.vli2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply(this.ci)).multiply((FieldElement)q5)).negate();
            this.vli3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.multiply(this.ci)).multiply((FieldElement)p4)).multiply(-3.0);
            this.vll2 = (CalculusFieldElement)this.vle2.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply(this.n2)).multiply((FieldElement)p3)).multiply(3.0)));
            this.vlh1I = (CalculusFieldElement)((CalculusFieldElement)this.si.multiply((FieldElement)q2)).negate();
            this.vlh2I = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply(this.ci)).multiply((FieldElement)q5)).add((FieldElement)((CalculusFieldElement)this.si.multiply((FieldElement)p2)));
            this.vlh3I = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.multiply(this.ci)).multiply((FieldElement)p4)).add((FieldElement)((CalculusFieldElement)this.si.multiply((FieldElement)p5)))).negate();
            this.vls1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q1.multiply((FieldElement)((CalculusFieldElement)this.n3.subtract((FieldElement)one)))).subtract((FieldElement)q2)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.multiply((FieldElement)ci2)).multiply((FieldElement)ci2Xt2)).multiply((FieldElement)ci2Xt2)).multiply((FieldElement)((CalculusFieldElement)this.yp2.subtract((FieldElement)((CalculusFieldElement)fs13.multiply(0.2)))))).multiply(25.0)))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.yp2.multiply((FieldElement)cE)).subtract((FieldElement)((CalculusFieldElement)fs13.multiply((FieldElement)cF)))))).multiply(0.0625)));
            this.vls2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp.multiply(this.si)).multiply((FieldElement)((CalculusFieldElement)this.t8.add((FieldElement)ciO1Pci)))).multiply((FieldElement)q5)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epp2.subtract(this.n3)).multiply(3.0)).add(11.0)).multiply((FieldElement)p3)))).add((FieldElement)((CalculusFieldElement)oneMci.multiply((FieldElement)p2)));
            this.vls3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.si.multiply((FieldElement)p4)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n3.subtract((FieldElement)one)).multiply(3.0)).subtract((FieldElement)((CalculusFieldElement)epp2.multiply((FieldElement)((CalculusFieldElement)ciO1Pci.add(2.0)))))))).subtract((FieldElement)((CalculusFieldElement)oneMci.multiply((FieldElement)p5)));
        }

        private FieldUnivariateDerivative1<T> getTrueAnomaly(FieldUnivariateDerivative1<T> lM, FieldUnivariateDerivative1<T> ecc) {
            CalculusFieldElement zero = (CalculusFieldElement)this.mean.getE().getField().getZero();
            FieldUnivariateDerivative1 reducedM = new FieldUnivariateDerivative1(MathUtils.normalizeAngle((CalculusFieldElement)lM.getValue(), (CalculusFieldElement)zero), lM.getFirstDerivative());
            FieldUnivariateDerivative1 lV = FieldKeplerianAnomalyUtility.ellipticMeanToTrue(ecc, lM);
            lV = (FieldUnivariateDerivative1)lV.add((CalculusFieldElement)lM.getValue().subtract((FieldElement)reducedM.getValue()));
            return lV;
        }

        private T T2(T cosI) {
            CalculusFieldElement one;
            CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosI.square()).multiply(-5.0)).add(1.0);
            CalculusFieldElement x2 = (CalculusFieldElement)x.square();
            CalculusFieldElement xb = (CalculusFieldElement)x2.multiply(BETA);
            CalculusFieldElement sum = (CalculusFieldElement)x.getField().getZero();
            for (int i = 0; i <= 12; ++i) {
                double sign = i % 2 == 0 ? 1.0 : -1.0;
                sum = (CalculusFieldElement)sum.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.pow((CalculusFieldElement)x2, (int)i).multiply(FastMath.pow((double)BETA, (int)i))).multiply(sign)).divide(CombinatoricsUtils.factorialDouble((int)(i + 1)))));
            }
            CalculusFieldElement product = one = (CalculusFieldElement)x.getField().getOne();
            for (int i = 0; i <= 10; ++i) {
                product = (CalculusFieldElement)product.multiply((FieldElement)((CalculusFieldElement)one.add((FieldElement)FastMath.exp((CalculusFieldElement)((CalculusFieldElement)xb.multiply(FastMath.scalb((double)-1.0, (int)i)))))));
            }
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(BETA)).multiply((FieldElement)sum)).multiply((FieldElement)product));
        }

        public FieldKeplerianOrbit<T> propagateParameters(FieldAbsoluteDate<T> date, T[] parameters) {
            Field<T> field = date.getField();
            CalculusFieldElement one = (CalculusFieldElement)field.getOne();
            CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
            T m2 = parameters[0];
            FieldUnivariateDerivative1 dt = new FieldUnivariateDerivative1(date.durationFrom(this.mean.getDate()), one);
            FieldUnivariateDerivative1 not = dt.multiply(this.n0);
            FieldUnivariateDerivative1 dtM2 = dt.multiply(m2);
            FieldUnivariateDerivative1 dt2M2 = dt.multiply(dtM2);
            FieldUnivariateDerivative1 app = (FieldUnivariateDerivative1)dtM2.multiply(this.aRate).add(this.mean.getA());
            FieldUnivariateDerivative1 tmp = (FieldUnivariateDerivative1)dtM2.multiply(this.eRate).add(this.mean.getE());
            FieldUnivariateDerivative1 epp = (FieldUnivariateDerivative1)FastMath.max((CalculusFieldElement)((FieldUnivariateDerivative1)FastMath.min((CalculusFieldElement)tmp, (double)0.999999)), (double)0.0);
            CalculusFieldElement gp0 = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)this.mean.getPerigeeArgument().add((FieldElement)((CalculusFieldElement)this.dsg.multiply((FieldElement)not.getValue())))), (CalculusFieldElement)zero);
            CalculusFieldElement gp1 = (CalculusFieldElement)this.dsg.multiply(this.n0);
            FieldUnivariateDerivative1 gpp = new FieldUnivariateDerivative1(gp0, gp1);
            CalculusFieldElement hp0 = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)this.mean.getRightAscensionOfAscendingNode().add((FieldElement)((CalculusFieldElement)this.dsh.multiply((FieldElement)not.getValue())))), (CalculusFieldElement)zero);
            CalculusFieldElement hp1 = (CalculusFieldElement)this.dsh.multiply(this.n0);
            FieldUnivariateDerivative1 hpp = new FieldUnivariateDerivative1(hp0, hp1);
            CalculusFieldElement lp0 = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.mean.getMeanAnomaly().add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.dsl.add((FieldElement)one)).multiply((FieldElement)not.getValue())))).add((FieldElement)dt2M2.getValue())), (CalculusFieldElement)zero);
            CalculusFieldElement lp1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.dsl.add((FieldElement)one)).multiply(this.n0)).add((FieldElement)dtM2.multiply(2.0).getValue());
            FieldUnivariateDerivative1 lpp = new FieldUnivariateDerivative1(lp0, lp1);
            FieldSinCos scgpp = gpp.sinCos();
            FieldUnivariateDerivative1 cgpp = (FieldUnivariateDerivative1)scgpp.cos();
            FieldUnivariateDerivative1 sgpp = (FieldUnivariateDerivative1)scgpp.sin();
            FieldSinCos sc2gpp = gpp.multiply(2).sinCos();
            FieldUnivariateDerivative1 c2gpp = (FieldUnivariateDerivative1)sc2gpp.cos();
            FieldUnivariateDerivative1 s2gpp = (FieldUnivariateDerivative1)sc2gpp.sin();
            FieldSinCos sc3gpp = gpp.multiply(3).sinCos();
            FieldUnivariateDerivative1 c3gpp = (FieldUnivariateDerivative1)sc3gpp.cos();
            FieldUnivariateDerivative1 s3gpp = (FieldUnivariateDerivative1)sc3gpp.sin();
            FieldUnivariateDerivative1 d1e = c2gpp.multiply(this.vle1).add(sgpp.multiply(this.vle2)).add(s3gpp.multiply(this.vle3));
            FieldUnivariateDerivative1 d1I = sgpp.multiply(this.vli2).add(s3gpp.multiply(this.vli3));
            if (Double.isFinite(this.vli1.getReal())) {
                d1I = d1I.add(c2gpp.multiply(this.vli1));
            }
            FieldUnivariateDerivative1 eppd1l = s2gpp.multiply(this.vle1).subtract(cgpp.multiply(this.vll2)).subtract(c3gpp.multiply(this.vle3)).multiply(this.n);
            FieldUnivariateDerivative1 sIppd1h = s2gpp.multiply(this.vlh1I).add(cgpp.multiply(this.vlh2I)).add(c3gpp.multiply(this.vlh3I));
            FieldUnivariateDerivative1 d1z = s2gpp.multiply(this.vls1).add(cgpp.multiply(this.vls2)).add(c3gpp.multiply(this.vls3));
            FieldUnivariateDerivative1<T> fpp = this.getTrueAnomaly(lpp, epp);
            FieldSinCos scfpp = fpp.sinCos();
            FieldUnivariateDerivative1 cfpp = (FieldUnivariateDerivative1)scfpp.cos();
            FieldUnivariateDerivative1 sfpp = (FieldUnivariateDerivative1)scfpp.sin();
            FieldUnivariateDerivative1 eppsfpp = epp.multiply(sfpp);
            FieldUnivariateDerivative1 eppcfpp = epp.multiply(cfpp);
            FieldUnivariateDerivative1 eppcfppP1 = eppcfpp.add(1.0);
            FieldUnivariateDerivative1 eppcfppP2 = eppcfpp.add(2.0);
            FieldUnivariateDerivative1 eppcfppP3 = eppcfpp.add(3.0);
            FieldUnivariateDerivative1 eppcfppP1_3 = ((FieldUnivariateDerivative1)eppcfppP1.square()).multiply(eppcfppP1);
            FieldUnivariateDerivative1 g2 = gpp.multiply(2);
            FieldUnivariateDerivative1 g2f = g2.add(fpp);
            FieldSinCos sc2gf = g2f.sinCos();
            FieldUnivariateDerivative1 c2gf = (FieldUnivariateDerivative1)sc2gf.cos();
            FieldUnivariateDerivative1 s2gf = (FieldUnivariateDerivative1)sc2gf.sin();
            FieldUnivariateDerivative1 eppc2gf = epp.multiply(c2gf);
            FieldUnivariateDerivative1 epps2gf = epp.multiply(s2gf);
            FieldUnivariateDerivative1 g2f2 = g2.add(fpp.multiply(2));
            FieldSinCos sc2g2f = g2f2.sinCos();
            FieldUnivariateDerivative1 c2g2f = (FieldUnivariateDerivative1)sc2g2f.cos();
            FieldUnivariateDerivative1 s2g2f = (FieldUnivariateDerivative1)sc2g2f.sin();
            FieldUnivariateDerivative1 g2f3 = g2.add(fpp.multiply(3));
            FieldSinCos sc2g3f = g2f3.sinCos();
            FieldUnivariateDerivative1 c2g3f = (FieldUnivariateDerivative1)sc2g3f.cos();
            FieldUnivariateDerivative1 s2g3f = (FieldUnivariateDerivative1)sc2g3f.sin();
            FieldUnivariateDerivative1 eppc2g3f = epp.multiply(c2g3f);
            FieldUnivariateDerivative1 epps2g3f = epp.multiply(s2g3f);
            FieldUnivariateDerivative1 w17 = fpp.add(eppsfpp).subtract(lpp);
            FieldUnivariateDerivative1 w20 = cfpp.multiply(eppcfppP3.multiply(eppcfpp).add(3.0));
            FieldUnivariateDerivative1 w21 = s2g2f.add(epps2gf).multiply(3).add(epps2g3f);
            FieldUnivariateDerivative1 w22 = eppcfppP1.multiply(eppcfppP2).divide(this.n2);
            FieldSinCos sci = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)this.mean.getI().divide(2.0)));
            CalculusFieldElement siO2 = (CalculusFieldElement)sci.sin();
            CalculusFieldElement ciO2 = (CalculusFieldElement)sci.cos();
            FieldUnivariateDerivative1 d2a = app.multiply(this.yp2).divide(this.n2).multiply(((FieldUnivariateDerivative1)eppcfppP1_3.subtract(this.n3)).multiply(this.ci2X3M1).add(c2g2f.multiply(eppcfppP1_3).multiply(this.oneMci2).multiply(3.0)));
            FieldUnivariateDerivative1 d2e = w20.add(epp.multiply(this.t8)).multiply(this.ci2X3M1).add(w20.add(epp.multiply(c2g2f)).multiply((CalculusFieldElement)this.oneMci2.multiply(3))).subtract(eppc2gf.multiply(3).add(eppc2g3f).multiply((CalculusFieldElement)this.oneMci2.multiply(this.n2))).multiply((CalculusFieldElement)this.yp2.multiply(0.5));
            FieldUnivariateDerivative1 d2I = c2g2f.add(eppc2gf).multiply(3).add(eppc2g3f).multiply((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.yp2.divide(2.0)).multiply(this.ci)).multiply(this.si));
            FieldUnivariateDerivative1 eppd2l = w22.add(1.0).multiply(sfpp).multiply(this.oneMci2).multiply(2.0).add(w22.subtract(1.0).negate().multiply(s2gf).add(w22.add(0.3333333333333333).multiply(s2g3f)).multiply((CalculusFieldElement)this.oneMci2.multiply(3.0))).multiply((CalculusFieldElement)((CalculusFieldElement)this.yp2.divide(4.0)).multiply(this.n3)).negate();
            FieldUnivariateDerivative1 sIppd2h = w21.subtract(w17.multiply(6)).multiply(this.yp2).multiply(this.ci).multiply(this.si).divide(2.0);
            CalculusFieldElement ttt = (CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)this.ci.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ci.multiply(-5)).add(2.0)))));
            FieldUnivariateDerivative1 d2z = epp.multiply(eppd2l).multiply((CalculusFieldElement)this.t8.subtract((FieldElement)one)).divide(this.n3).add(w17.multiply(ttt).multiply(6).subtract(w21.multiply((CalculusFieldElement)ttt.add(2.0))).multiply((CalculusFieldElement)this.yp2.divide(4.0))).negate();
            FieldUnivariateDerivative1 de = epp.add(d1e).add(d2e);
            FieldUnivariateDerivative1 dl = eppd1l.add(eppd2l);
            FieldUnivariateDerivative1 dh = sIppd1h.add(sIppd2h).divide((CalculusFieldElement)ciO2.multiply(2.0));
            FieldUnivariateDerivative1 di = (FieldUnivariateDerivative1)d1I.add(d2I).multiply(ciO2).divide(2.0).add(siO2);
            FieldUnivariateDerivative1 z = lpp.add(gpp).add(hpp).add(d1z).add(d2z);
            FieldUnivariateDerivative1 a = app.add(d2a);
            FieldUnivariateDerivative1 e = (FieldUnivariateDerivative1)FastMath.sqrt((CalculusFieldElement)((FieldUnivariateDerivative1)de.square()).add((FieldUnivariateDerivative1)dl.square()));
            FieldSinCos sclpp = lpp.sinCos();
            FieldUnivariateDerivative1 clpp = (FieldUnivariateDerivative1)sclpp.cos();
            FieldUnivariateDerivative1 slpp = (FieldUnivariateDerivative1)sclpp.sin();
            FieldUnivariateDerivative1 l = (FieldUnivariateDerivative1)FastMath.atan2((CalculusFieldElement)de.multiply(slpp).add(dl.multiply(clpp)), (CalculusFieldElement)de.multiply(clpp).subtract(dl.multiply(slpp)));
            FieldUnivariateDerivative1 i = (FieldUnivariateDerivative1)FastMath.acos((CalculusFieldElement)((FieldUnivariateDerivative1)di.square()).add((FieldUnivariateDerivative1)dh.square()).multiply(2).negate().add(1.0));
            FieldSinCos schpp = hpp.sinCos();
            FieldUnivariateDerivative1 chpp = (FieldUnivariateDerivative1)schpp.cos();
            FieldUnivariateDerivative1 shpp = (FieldUnivariateDerivative1)schpp.sin();
            FieldUnivariateDerivative1 h = (FieldUnivariateDerivative1)FastMath.atan2((CalculusFieldElement)di.multiply(shpp).add(dh.multiply(chpp)), (CalculusFieldElement)di.multiply(chpp).subtract(dh.multiply(shpp)));
            FieldUnivariateDerivative1 g = z.subtract(l).subtract(h);
            return new FieldKeplerianOrbit<CalculusFieldElement>(a.getValue(), e.getValue(), i.getValue(), g.getValue(), h.getValue(), l.getValue(), a.getFirstDerivative(), e.getFirstDerivative(), i.getFirstDerivative(), g.getFirstDerivative(), h.getFirstDerivative(), l.getFirstDerivative(), PositionAngleType.MEAN, this.mean.getFrame(), date, (CalculusFieldElement)this.mu);
        }
    }
}

