/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.RealMatrix;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.SpacecraftStateInterpolator;
import org.orekit.propagation.StateCovariance;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.time.TimeInterpolator;
import org.orekit.time.TimeStampedPair;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ImmutableTimeStampedCache;

public class Ephemeris
extends AbstractAnalyticalPropagator
implements BoundedPropagator {
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private final Frame frame;
    private final String[] additional;
    private final transient ImmutableTimeStampedCache<SpacecraftState> statesCache;
    private final transient ImmutableTimeStampedCache<StateCovariance> covariancesCache;
    private final transient TimeInterpolator<SpacecraftState> stateInterpolator;
    private final transient TimeInterpolator<TimeStampedPair<Orbit, StateCovariance>> covarianceInterpolator;
    private final transient boolean statesAreOrbitDefined;

    public Ephemeris(List<SpacecraftState> states, int interpolationPoints) throws MathIllegalArgumentException {
        this(states, new SpacecraftStateInterpolator(interpolationPoints, states.get(0).getFrame(), states.get(0).getFrame()), new ArrayList<StateCovariance>(), null);
    }

    public Ephemeris(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator) throws MathIllegalArgumentException {
        this(states, stateInterpolator, new ArrayList<StateCovariance>(), null);
    }

    public Ephemeris(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator, AttitudeProvider attitudeProvider) throws MathIllegalArgumentException {
        this(states, stateInterpolator, new ArrayList<StateCovariance>(), null, attitudeProvider);
    }

    public Ephemeris(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator, List<StateCovariance> covariances, TimeInterpolator<TimeStampedPair<Orbit, StateCovariance>> covarianceInterpolator) throws MathIllegalArgumentException {
        this(states, stateInterpolator, covariances, covarianceInterpolator, states.isEmpty() ? null : FrameAlignedProvider.of(states.get(0).getFrame()));
    }

    public Ephemeris(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator, List<StateCovariance> covariances, TimeInterpolator<TimeStampedPair<Orbit, StateCovariance>> covarianceInterpolator, AttitudeProvider attitudeProvider) throws MathIllegalArgumentException {
        super(attitudeProvider);
        Ephemeris.checkInputConsistency(states, stateInterpolator, covariances, covarianceInterpolator);
        SpacecraftState s0 = states.get(0);
        this.minDate = s0.getDate();
        this.maxDate = states.get(states.size() - 1).getDate();
        this.frame = s0.getFrame();
        List<DoubleArrayDictionary.Entry> as = s0.getAdditionalStatesValues().getData();
        this.additional = new String[as.size()];
        for (int i = 0; i < this.additional.length; ++i) {
            this.additional[i] = as.get(i).getKey();
        }
        this.statesCache = new ImmutableTimeStampedCache<SpacecraftState>(stateInterpolator.getNbInterpolationPoints(), states);
        this.stateInterpolator = stateInterpolator;
        this.covarianceInterpolator = covarianceInterpolator;
        this.covariancesCache = covarianceInterpolator != null ? new ImmutableTimeStampedCache<StateCovariance>(covarianceInterpolator.getNbInterpolationPoints(), covariances) : null;
        this.statesAreOrbitDefined = s0.isOrbitDefined();
        super.resetInitialState(this.getInitialState());
    }

    public static void checkInputConsistency(List<SpacecraftState> states, TimeInterpolator<SpacecraftState> stateInterpolator, List<StateCovariance> covariances, TimeInterpolator<TimeStampedPair<Orbit, StateCovariance>> covarianceInterpolator) {
        if (!states.isEmpty()) {
            SpacecraftStateInterpolator.checkStatesDefinitionsConsistency(states);
            AbstractTimeInterpolator.checkInterpolatorCompatibilityWithSampleSize(stateInterpolator, states.size());
            if (!covariances.isEmpty()) {
                AbstractTimeInterpolator.checkInterpolatorCompatibilityWithSampleSize(covarianceInterpolator, covariances.size());
                Ephemeris.checkStatesAndCovariancesConsistency(states, covariances);
            }
        } else {
            throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_DATA, 0);
        }
    }

    public static void checkStatesAndCovariancesConsistency(List<SpacecraftState> states, List<StateCovariance> covariances) {
        int nbStates = states.size();
        if (nbStates != covariances.size()) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, states.size(), covariances.size());
        }
        for (int i = 0; i < nbStates; ++i) {
            if (states.get(i).getDate().isCloseTo(covariances.get(i).getDate(), 1.0E-9)) continue;
            throw new OrekitIllegalStateException(OrekitMessages.STATE_AND_COVARIANCE_DATES_MISMATCH, states.get(i).getDate(), covariances.get(i).getDate());
        }
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    public Optional<StateCovariance> getCovariance(AbsoluteDate date) {
        if (this.covarianceInterpolator != null && this.covariancesCache != null && this.statesAreOrbitDefined) {
            List<TimeStampedPair<Orbit, StateCovariance>> sample = this.buildOrbitAndCovarianceSample();
            TimeStampedPair<Orbit, StateCovariance> interpolatedOrbitAndCovariance = this.covarianceInterpolator.interpolate(date, sample);
            return Optional.of(interpolatedOrbitAndCovariance.getSecond());
        }
        return Optional.empty();
    }

    private List<TimeStampedPair<Orbit, StateCovariance>> buildOrbitAndCovarianceSample() {
        ArrayList<TimeStampedPair<Orbit, StateCovariance>> sample = new ArrayList<TimeStampedPair<Orbit, StateCovariance>>();
        List<SpacecraftState> states = this.statesCache.getAll();
        List<StateCovariance> covariances = this.covariancesCache.getAll();
        for (int i = 0; i < states.size(); ++i) {
            sample.add(new TimeStampedPair<Orbit, StateCovariance>(states.get(i).getOrbit(), covariances.get(i)));
        }
        return sample;
    }

    @Override
    public SpacecraftState basicPropagate(AbsoluteDate date) {
        AbsoluteDate centralDate = AbstractTimeInterpolator.getCentralDate(date, this.statesCache, this.stateInterpolator.getExtrapolationThreshold());
        SpacecraftState evaluatedState = this.stateInterpolator.interpolate(date, this.statesCache.getNeighbors(centralDate));
        AttitudeProvider attitudeProvider = this.getAttitudeProvider();
        if (attitudeProvider == null) {
            return evaluatedState;
        }
        if (evaluatedState.isOrbitDefined()) {
            Attitude calculatedAttitude = attitudeProvider.getAttitude(evaluatedState.getOrbit(), date, evaluatedState.getFrame());
            return new SpacecraftState(evaluatedState.getOrbit(), calculatedAttitude, evaluatedState.getMass(), evaluatedState.getAdditionalStatesValues(), evaluatedState.getAdditionalStatesDerivatives());
        }
        Attitude calculatedAttitude = attitudeProvider.getAttitude(evaluatedState.getAbsPVA(), date, evaluatedState.getFrame());
        return new SpacecraftState(evaluatedState.getAbsPVA(), calculatedAttitude, evaluatedState.getMass(), evaluatedState.getAdditionalStatesValues(), evaluatedState.getAdditionalStatesDerivatives());
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.basicPropagate(date).getMass();
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.basicPropagate(this.getMinDate());
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (String a : this.additional) {
            if (!a.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] upperManaged = super.getManagedAdditionalStates();
        String[] managed = new String[upperManaged.length + this.additional.length];
        System.arraycopy(upperManaged, 0, managed, 0, upperManaged.length);
        System.arraycopy(this.additional, 0, managed, upperManaged.length, this.additional.length);
        return managed;
    }

    @Override
    protected AbstractMatricesHarvester createHarvester(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        return null;
    }

    public TimeInterpolator<SpacecraftState> getStateInterpolator() {
        return this.stateInterpolator;
    }

    public Optional<TimeInterpolator<TimeStampedPair<Orbit, StateCovariance>>> getCovarianceInterpolator() {
        return Optional.ofNullable(this.covarianceInterpolator);
    }
}

