/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative1;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldKeplerianAnomalyUtility;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.BrouwerLyddaneHarvester;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversProvider;
import org.orekit.utils.TimeSpanMap;

public class BrouwerLyddanePropagator
extends AbstractAnalyticalPropagator
implements ParameterDriversProvider {
    public static final String M2_NAME = "M2";
    public static final double M2 = 0.0;
    public static final double EPSILON_DEFAULT = 1.0E-13;
    public static final int MAX_ITERATIONS_DEFAULT = 200;
    public static final double DAMPING_DEFAULT = 1.0;
    private static final double SCALE = FastMath.scalb((double)1.0, (int)-32);
    private static final double BETA = FastMath.scalb((float)100.0f, (int)-11);
    private static final double MAX_ECC = 0.999999;
    private BLModel initialModel;
    private transient TimeSpanMap<BLModel> models;
    private double referenceRadius;
    private double mu;
    private double[] ck0;
    private final ParameterDriver M2Driver;

    public BrouwerLyddanePropagator(Orbit initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), 1000.0, provider, provider.onDate(initialOrbit.getDate()), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitude, double mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, double M2) {
        this(initialOrbit, attitude, mass, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), 1000.0, referenceRadius, mu, c20, c30, c40, c50, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, double mass, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), mass, provider, provider.onDate(initialOrbit.getDate()), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), mass, referenceRadius, mu, c20, c30, c40, c50, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, attitudeProv, 1000.0, provider, provider.onDate(initialOrbit.getDate()), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, attitudeProv, 1000.0, referenceRadius, mu, c20, c30, c40, c50, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, UnnormalizedSphericalHarmonicsProvider provider, double M2) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate()), M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2) {
        this(initialOrbit, attitudeProv, mass, referenceRadius, mu, c20, c30, c40, c50, PropagationType.OSCULATING, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType, double M2) {
        this(initialOrbit, FrameAlignedProvider.of(initialOrbit.getFrame()), 1000.0, provider, provider.onDate(initialOrbit.getDate()), initialType, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, UnnormalizedSphericalHarmonicsProvider provider, PropagationType initialType, double M2) {
        this(initialOrbit, attitudeProv, mass, provider, provider.onDate(initialOrbit.getDate()), initialType, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitude, double mass, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, PropagationType initialType, double M2) {
        this(initialOrbit, attitude, mass, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), initialType, M2);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, PropagationType initialType, double M2) {
        this(initialOrbit, attitudeProv, mass, referenceRadius, mu, c20, c30, c40, c50, initialType, M2, 1.0E-13, 200);
    }

    public BrouwerLyddanePropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mass, double referenceRadius, double mu, double c20, double c30, double c40, double c50, PropagationType initialType, double M2, double epsilon, int maxIterations) {
        super(attitudeProv);
        this.referenceRadius = referenceRadius;
        this.mu = mu;
        this.ck0 = new double[]{0.0, 0.0, c20, c30, c40, c50};
        this.M2Driver = new ParameterDriver(M2_NAME, M2, SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.resetInitialState(new SpacecraftState(initialOrbit, attitudeProv.getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass), initialType, epsilon, maxIterations);
    }

    public static KeplerianOrbit computeMeanOrbit(Orbit osculating, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, double M2Value) {
        return BrouwerLyddanePropagator.computeMeanOrbit(osculating, provider, harmonics, M2Value, 1.0E-13, 200);
    }

    public static KeplerianOrbit computeMeanOrbit(Orbit osculating, UnnormalizedSphericalHarmonicsProvider provider, UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics, double M2Value, double epsilon, int maxIterations) {
        return BrouwerLyddanePropagator.computeMeanOrbit(osculating, provider.getAe(), provider.getMu(), harmonics.getUnnormalizedCnm(2, 0), harmonics.getUnnormalizedCnm(3, 0), harmonics.getUnnormalizedCnm(4, 0), harmonics.getUnnormalizedCnm(5, 0), M2Value, epsilon, maxIterations);
    }

    public static KeplerianOrbit computeMeanOrbit(Orbit osculating, double referenceRadius, double mu, double c20, double c30, double c40, double c50, double M2Value, double epsilon, int maxIterations) {
        BrouwerLyddanePropagator propagator = new BrouwerLyddanePropagator(osculating, FrameAlignedProvider.of(osculating.getFrame()), 1000.0, referenceRadius, mu, c20, c30, c40, c50, PropagationType.OSCULATING, M2Value, epsilon, maxIterations);
        return propagator.initialModel.mean;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        this.resetInitialState(state, PropagationType.OSCULATING);
    }

    public void resetInitialState(SpacecraftState state, PropagationType stateType) {
        this.resetInitialState(state, stateType, 1.0E-13, 200);
    }

    public void resetInitialState(SpacecraftState state, PropagationType stateType, double epsilon, int maxIterations) {
        super.resetInitialState(state);
        KeplerianOrbit keplerian = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(state.getOrbit());
        this.initialModel = stateType == PropagationType.MEAN ? new BLModel(keplerian, state.getMass(), this.referenceRadius, this.mu, this.ck0) : this.computeMeanParameters(keplerian, state.getMass(), epsilon, maxIterations);
        this.models = new TimeSpanMap<BLModel>(this.initialModel);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        this.resetIntermediateState(state, forward, 1.0E-13, 200);
    }

    protected void resetIntermediateState(SpacecraftState state, boolean forward, double epsilon, int maxIterations) {
        BLModel newModel = this.computeMeanParameters((KeplerianOrbit)OrbitType.KEPLERIAN.convertType(state.getOrbit()), state.getMass(), epsilon, maxIterations);
        if (forward) {
            this.models.addValidAfter(newModel, state.getDate(), false);
        } else {
            this.models.addValidBefore(newModel, state.getDate(), false);
        }
        this.stateChanged(state);
    }

    private BLModel computeMeanParameters(KeplerianOrbit osculating, double mass, double epsilon, int maxIterations) {
        double damping = 1.0;
        if (osculating.getA() < this.referenceRadius) {
            throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_INSIDE_BRILLOUIN_SPHERE, osculating.getA());
        }
        BLModel current = new BLModel(osculating, mass, this.referenceRadius, this.mu, this.ck0);
        double sma = osculating.getA();
        double ex = osculating.getEquinoctialEx();
        double ey = osculating.getEquinoctialEy();
        double hx = osculating.getHx();
        double hy = osculating.getHy();
        double lv = osculating.getLv();
        double thresholdA = epsilon * (1.0 + FastMath.abs((double)osculating.getA()));
        double thresholdE = epsilon * (1.0 + FastMath.hypot((double)ex, (double)ey));
        double thresholdH = epsilon * (1.0 + FastMath.hypot((double)hx, (double)hy));
        double thresholdLv = epsilon * Math.PI;
        int i = 0;
        while (i++ < maxIterations) {
            KeplerianOrbit parameters = current.propagateParameters(current.mean.getDate());
            double deltaA = osculating.getA() - parameters.getA();
            double deltaEx = osculating.getEquinoctialEx() - parameters.getEquinoctialEx();
            double deltaEy = osculating.getEquinoctialEy() - parameters.getEquinoctialEy();
            double deltaHx = osculating.getHx() - parameters.getHx();
            double deltaHy = osculating.getHy() - parameters.getHy();
            double deltaLv = MathUtils.normalizeAngle((double)(osculating.getLv() - parameters.getLv()), (double)0.0);
            EquinoctialOrbit mean = new EquinoctialOrbit(sma += 1.0 * deltaA, ex += 1.0 * deltaEx, ey += 1.0 * deltaEy, hx += 1.0 * deltaHx, hy += 1.0 * deltaHy, lv += 1.0 * deltaLv, PositionAngleType.TRUE, osculating.getFrame(), osculating.getDate(), osculating.getMu());
            KeplerianOrbit meanOrb = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(mean);
            current = new BLModel(meanOrb, mass, this.referenceRadius, this.mu, this.ck0);
            if (!(FastMath.abs((double)deltaA) < thresholdA) || !(FastMath.abs((double)deltaEx) < thresholdE) || !(FastMath.abs((double)deltaEy) < thresholdE) || !(FastMath.abs((double)deltaHx) < thresholdH) || !(FastMath.abs((double)deltaHy) < thresholdH) || !(FastMath.abs((double)deltaLv) < thresholdLv)) continue;
            return current;
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_BROUWER_LYDDANE_MEAN_PARAMETERS, i);
    }

    @Override
    public KeplerianOrbit propagateOrbit(AbsoluteDate date) {
        BLModel current = this.models.get(date);
        return current.propagateParameters(date);
    }

    public double getM2() {
        return this.M2Driver.getValue();
    }

    public double getMu() {
        return this.mu;
    }

    public double[] getCk0() {
        return (double[])this.ck0.clone();
    }

    public double getReferenceRadius() {
        return this.referenceRadius;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.M2Driver);
    }

    @Override
    protected AbstractMatricesHarvester createHarvester(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        BrouwerLyddaneHarvester harvester = new BrouwerLyddaneHarvester(this, stmName, initialStm, initialJacobianColumns);
        this.addAdditionalStateProvider(harvester);
        return harvester;
    }

    @Override
    protected List<String> getJacobiansColumnsNames() {
        ArrayList<String> columnsNames = new ArrayList<String>();
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!driver.isSelected() || columnsNames.contains(driver.getNamesSpanMap().getFirstSpan().getData())) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                columnsNames.add(span.getData());
            }
        }
        Collections.sort(columnsNames);
        return columnsNames;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.models.get(date).mass;
    }

    private class BLModel {
        private final double mass;
        private final KeplerianOrbit mean;
        private final double n0;
        private final double n;
        private final double n2;
        private final double n3;
        private final double t8;
        private final double dsl;
        private final double dsg;
        private final double dsh;
        private final double aRate;
        private final double eRate;
        private final double yp2;
        private final double ci;
        private final double si;
        private final double oneMci2;
        private final double ci2X3M1;
        private final double vle1;
        private final double vle2;
        private final double vle3;
        private final double vli1;
        private final double vli2;
        private final double vli3;
        private final double vll2;
        private final double vlh1I;
        private final double vlh2I;
        private final double vlh3I;
        private final double vls1;
        private final double vls2;
        private final double vls3;

        BLModel(KeplerianOrbit mean, double mass, double referenceRadius, double mu, double[] ck0) {
            this.mass = mass;
            this.mean = mean;
            double epp = mean.getE();
            if (epp >= 1.0) {
                throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_ECCENTRICITY_FOR_PROPAGATION_MODEL, epp);
            }
            double epp2 = epp * epp;
            this.n2 = 1.0 - epp2;
            this.n = FastMath.sqrt((double)this.n2);
            this.n3 = this.n2 * this.n;
            this.t8 = this.n + 1.0 / (1.0 + this.n);
            double app = mean.getA();
            this.n0 = FastMath.sqrt((double)(mu / app)) / app;
            double q = referenceRadius / app;
            double ql = q * q;
            double nl = this.n2 * this.n2;
            this.yp2 = -0.5 * ck0[2] * ql / nl;
            double yp22 = this.yp2 * this.yp2;
            double yp3 = ck0[3] * (ql *= q) / (nl *= this.n2);
            double yp4 = 0.375 * ck0[4] * (ql *= q) / (nl *= this.n2);
            double yp5 = ck0[5] * (ql *= q) / (nl *= this.n2);
            SinCos sci = FastMath.sinCos((double)mean.getI());
            this.si = sci.sin();
            this.ci = sci.cos();
            double ci2 = this.ci * this.ci;
            this.oneMci2 = 1.0 - ci2;
            this.ci2X3M1 = 3.0 * ci2 - 1.0;
            double ci2X5M1 = 5.0 * ci2 - 1.0;
            this.dsl = 1.5 * this.yp2 * this.n * (this.ci2X3M1 + 0.0625 * this.yp2 * (-15.0 + this.n * (16.0 + 25.0 * this.n) + ci2 * (30.0 - this.n * (96.0 + 90.0 * this.n) + ci2 * (105.0 + this.n * (144.0 + 25.0 * this.n))))) + 0.9375 * yp4 * this.n * epp2 * (3.0 - ci2 * (30.0 - 35.0 * ci2));
            this.dsg = 1.5 * this.yp2 * ci2X5M1 + 0.09375 * yp22 * (-35.0 + this.n * (24.0 + 25.0 * this.n) + ci2 * (90.0 - this.n * (192.0 + 126.0 * this.n) + ci2 * (385.0 + this.n * (360.0 + 45.0 * this.n)))) + 0.3125 * yp4 * (21.0 - 9.0 * this.n2 + ci2 * (-270.0 + 126.0 * this.n2 + ci2 * (385.0 - 189.0 * this.n2)));
            this.dsh = (-3.0 * this.yp2 + 0.375 * yp22 * (-5.0 + this.n * (12.0 + 9.0 * this.n) - ci2 * (35.0 + this.n * (36.0 + 5.0 * this.n))) + 1.25 * yp4 * (5.0 - 3.0 * this.n2) * (3.0 - 7.0 * ci2)) * this.ci;
            double coef = -4.0 / (3.0 * this.n0 * (1.0 + this.dsl));
            this.aRate = coef * app;
            this.eRate = coef * epp * this.n2;
            double t2 = this.T2(this.ci);
            double fs12 = yp3 / this.yp2;
            double fs13 = 10.0 * yp4 / (3.0 * this.yp2);
            double fs14 = yp5 / this.yp2;
            double ci2Xt2 = ci2 * t2;
            double cA = 1.0 - ci2 * (11.0 + 40.0 * ci2Xt2);
            double cB = 1.0 - ci2 * (3.0 + 8.0 * ci2Xt2);
            double cC = 1.0 - ci2 * (9.0 + 24.0 * ci2Xt2);
            double cD = 1.0 - ci2 * (5.0 + 16.0 * ci2Xt2);
            double cE = 1.0 - ci2 * (33.0 + 200.0 * ci2Xt2);
            double cF = 1.0 - ci2 * (9.0 + 40.0 * ci2Xt2);
            double p5p = 1.0 + ci2Xt2 * (8.0 + 20.0 * ci2Xt2);
            double p5p2 = 1.0 + 2.0 * p5p;
            double p5p4 = 1.0 + 4.0 * p5p;
            double p5p10 = 1.0 + 10.0 * p5p;
            double e2X3P4 = 4.0 + 3.0 * epp2;
            double ciO1Pci = this.ci / (1.0 + this.ci);
            double q1 = 0.125 * (this.yp2 * cA - fs13 * cB);
            double q2 = 0.125 * epp2 * this.ci * (this.yp2 * p5p10 - fs13 * p5p2);
            double q5 = 0.25 * (fs12 + 0.3125 * e2X3P4 * fs14 * cC);
            double p2 = 0.46875 * p5p2 * epp * this.ci * this.si * e2X3P4 * fs14;
            double p3 = 0.15625 * epp * this.si * fs14 * cC;
            double kf = 0.030381944444444444;
            double p4 = 0.030381944444444444 * epp * fs14 * cD;
            double p5 = 0.06076388888888889 * epp * epp2 * this.ci * this.si * fs14 * p5p4;
            this.vle1 = epp * this.n2 * q1;
            this.vle2 = this.n2 * this.si * q5;
            this.vle3 = -3.0 * epp * this.n2 * this.si * p4;
            this.vli1 = -epp * q1 / this.si;
            this.vli2 = -epp * this.ci * q5;
            this.vli3 = -3.0 * epp2 * this.ci * p4;
            this.vll2 = this.vle2 + 3.0 * epp * this.n2 * p3;
            this.vlh1I = -this.si * q2;
            this.vlh2I = epp * this.ci * q5 + this.si * p2;
            this.vlh3I = -epp2 * this.ci * p4 - this.si * p5;
            this.vls1 = (this.n3 - 1.0) * q1 - q2 + 25.0 * epp2 * ci2 * ci2Xt2 * ci2Xt2 * (this.yp2 - 0.2 * fs13) - 0.0625 * epp2 * (this.yp2 * cE - fs13 * cF);
            this.vls2 = epp * this.si * (this.t8 + ciO1Pci) * q5 + (11.0 + 3.0 * (epp2 - this.n3)) * p3 + (1.0 - this.ci) * p2;
            this.vls3 = this.si * p4 * (3.0 * (this.n3 - 1.0) - epp2 * (2.0 + ciO1Pci)) - (1.0 - this.ci) * p5;
        }

        private UnivariateDerivative1 getTrueAnomaly(UnivariateDerivative1 lM, UnivariateDerivative1 ecc) {
            double reducedM = MathUtils.normalizeAngle((double)lM.getValue(), (double)0.0);
            UnivariateDerivative1 lV = FieldKeplerianAnomalyUtility.ellipticMeanToTrue(ecc, lM);
            lV = (UnivariateDerivative1)lV.add(lM.getValue() - reducedM);
            return lV;
        }

        private double T2(double cosI) {
            double x = 1.0 - 5.0 * cosI * cosI;
            double x2 = x * x;
            double sum = 0.0;
            for (int i = 0; i <= 12; ++i) {
                double sign = i % 2 == 0 ? 1.0 : -1.0;
                sum += sign * FastMath.pow((double)BETA, (int)i) * FastMath.pow((double)x2, (int)i) / CombinatoricsUtils.factorialDouble((int)(i + 1));
            }
            double product = 1.0;
            for (int i = 0; i <= 10; ++i) {
                product *= 1.0 + FastMath.exp((double)(FastMath.scalb((double)-1.0, (int)i) * BETA * x2));
            }
            return BETA * x * sum * product;
        }

        public KeplerianOrbit propagateParameters(AbsoluteDate date) {
            double m2 = BrouwerLyddanePropagator.this.M2Driver.getValue();
            UnivariateDerivative1 dt = new UnivariateDerivative1(date.durationFrom(this.mean.getDate()), 1.0);
            UnivariateDerivative1 not = dt.multiply(this.n0);
            UnivariateDerivative1 dtM2 = dt.multiply(m2);
            UnivariateDerivative1 dt2M2 = dt.multiply(dtM2);
            UnivariateDerivative1 app = (UnivariateDerivative1)dtM2.multiply(this.aRate).add(this.mean.getA());
            UnivariateDerivative1 tmp = (UnivariateDerivative1)dtM2.multiply(this.eRate).add(this.mean.getE());
            UnivariateDerivative1 epp = tmp.withValue(FastMath.max((double)0.0, (double)FastMath.min((double)tmp.getValue(), (double)0.999999)));
            double gppVal = this.mean.getPerigeeArgument() + this.dsg * not.getValue();
            UnivariateDerivative1 gpp = new UnivariateDerivative1(MathUtils.normalizeAngle((double)gppVal, (double)0.0), this.dsg * this.n0);
            double hppVal = this.mean.getRightAscensionOfAscendingNode() + this.dsh * not.getValue();
            UnivariateDerivative1 hpp = new UnivariateDerivative1(MathUtils.normalizeAngle((double)hppVal, (double)0.0), this.dsh * this.n0);
            double lppVal = this.mean.getMeanAnomaly() + (1.0 + this.dsl) * not.getValue() + dt2M2.getValue();
            double dlppdt = (1.0 + this.dsl) * this.n0 + 2.0 * dtM2.getValue();
            UnivariateDerivative1 lpp = new UnivariateDerivative1(MathUtils.normalizeAngle((double)lppVal, (double)0.0), dlppdt);
            FieldSinCos scgpp = gpp.sinCos();
            UnivariateDerivative1 cgpp = (UnivariateDerivative1)scgpp.cos();
            UnivariateDerivative1 sgpp = (UnivariateDerivative1)scgpp.sin();
            FieldSinCos sc2gpp = gpp.multiply(2).sinCos();
            UnivariateDerivative1 c2gpp = (UnivariateDerivative1)sc2gpp.cos();
            UnivariateDerivative1 s2gpp = (UnivariateDerivative1)sc2gpp.sin();
            FieldSinCos sc3gpp = gpp.multiply(3).sinCos();
            UnivariateDerivative1 c3gpp = (UnivariateDerivative1)sc3gpp.cos();
            UnivariateDerivative1 s3gpp = (UnivariateDerivative1)sc3gpp.sin();
            UnivariateDerivative1 d1e = c2gpp.multiply(this.vle1).add(sgpp.multiply(this.vle2)).add(s3gpp.multiply(this.vle3));
            UnivariateDerivative1 d1I = sgpp.multiply(this.vli2).add(s3gpp.multiply(this.vli3));
            if (Double.isFinite(this.vli1)) {
                d1I = d1I.add(c2gpp.multiply(this.vli1));
            }
            UnivariateDerivative1 eppd1l = s2gpp.multiply(this.vle1).subtract(cgpp.multiply(this.vll2)).subtract(c3gpp.multiply(this.vle3)).multiply(this.n);
            UnivariateDerivative1 sIppd1h = s2gpp.multiply(this.vlh1I).add(cgpp.multiply(this.vlh2I)).add(c3gpp.multiply(this.vlh3I));
            UnivariateDerivative1 d1z = s2gpp.multiply(this.vls1).add(cgpp.multiply(this.vls2)).add(c3gpp.multiply(this.vls3));
            UnivariateDerivative1 fpp = this.getTrueAnomaly(lpp, epp);
            FieldSinCos scfpp = fpp.sinCos();
            UnivariateDerivative1 cfpp = (UnivariateDerivative1)scfpp.cos();
            UnivariateDerivative1 sfpp = (UnivariateDerivative1)scfpp.sin();
            UnivariateDerivative1 eppsfpp = epp.multiply(sfpp);
            UnivariateDerivative1 eppcfpp = epp.multiply(cfpp);
            UnivariateDerivative1 eppcfppP1 = (UnivariateDerivative1)eppcfpp.add(1.0);
            UnivariateDerivative1 eppcfppP2 = (UnivariateDerivative1)eppcfpp.add(2.0);
            UnivariateDerivative1 eppcfppP3 = (UnivariateDerivative1)eppcfpp.add(3.0);
            UnivariateDerivative1 eppcfppP1_3 = ((UnivariateDerivative1)eppcfppP1.square()).multiply(eppcfppP1);
            UnivariateDerivative1 g2 = gpp.multiply(2);
            UnivariateDerivative1 g2f = g2.add(fpp);
            FieldSinCos sc2gf = g2f.sinCos();
            UnivariateDerivative1 c2gf = (UnivariateDerivative1)sc2gf.cos();
            UnivariateDerivative1 s2gf = (UnivariateDerivative1)sc2gf.sin();
            UnivariateDerivative1 eppc2gf = epp.multiply(c2gf);
            UnivariateDerivative1 epps2gf = epp.multiply(s2gf);
            UnivariateDerivative1 g2f2 = g2.add(fpp.multiply(2));
            FieldSinCos sc2g2f = g2f2.sinCos();
            UnivariateDerivative1 c2g2f = (UnivariateDerivative1)sc2g2f.cos();
            UnivariateDerivative1 s2g2f = (UnivariateDerivative1)sc2g2f.sin();
            UnivariateDerivative1 g2f3 = g2.add(fpp.multiply(3));
            FieldSinCos sc2g3f = g2f3.sinCos();
            UnivariateDerivative1 c2g3f = (UnivariateDerivative1)sc2g3f.cos();
            UnivariateDerivative1 s2g3f = (UnivariateDerivative1)sc2g3f.sin();
            UnivariateDerivative1 eppc2g3f = epp.multiply(c2g3f);
            UnivariateDerivative1 epps2g3f = epp.multiply(s2g3f);
            UnivariateDerivative1 w17 = fpp.add(eppsfpp).subtract(lpp);
            UnivariateDerivative1 w20 = cfpp.multiply((UnivariateDerivative1)eppcfppP3.multiply(eppcfpp).add(3.0));
            UnivariateDerivative1 w21 = s2g2f.add(epps2gf).multiply(3).add(epps2g3f);
            UnivariateDerivative1 w22 = eppcfppP1.multiply(eppcfppP2).divide(this.n2);
            SinCos sci = FastMath.sinCos((double)(0.5 * this.mean.getI()));
            double siO2 = sci.sin();
            double ciO2 = sci.cos();
            UnivariateDerivative1 d2a = app.multiply(this.yp2 / this.n2).multiply(((UnivariateDerivative1)eppcfppP1_3.subtract(this.n3)).multiply(this.ci2X3M1).add(eppcfppP1_3.multiply(c2g2f).multiply(3.0 * this.oneMci2)));
            UnivariateDerivative1 d2e = w20.add(epp.multiply(this.t8)).multiply(this.ci2X3M1).add(w20.add(epp.multiply(c2g2f)).multiply(3.0 * this.oneMci2)).subtract(eppc2gf.multiply(3).add(eppc2g3f).multiply(this.n2 * this.oneMci2)).multiply(0.5 * this.yp2);
            UnivariateDerivative1 d2I = c2g2f.add(eppc2gf).multiply(3).add(eppc2g3f).multiply(0.5 * this.yp2 * this.ci * this.si);
            UnivariateDerivative1 eppd2l = ((UnivariateDerivative1)w22.add(1.0)).multiply(sfpp).multiply(2.0 * this.oneMci2).add(((UnivariateDerivative1)w22.subtract(1.0)).negate().multiply(s2gf).add(((UnivariateDerivative1)w22.add(0.3333333333333333)).multiply(s2g3f)).multiply(3.0 * this.oneMci2)).multiply(0.25 * this.yp2 * this.n3).negate();
            UnivariateDerivative1 sIppd2h = w21.subtract(w17.multiply(6)).multiply(0.5 * this.yp2 * this.ci * this.si);
            UnivariateDerivative1 d2z = epp.multiply(eppd2l).multiply(this.t8 - 1.0).divide(this.n3).add(w17.multiply(6.0 * (1.0 + this.ci * (2.0 - 5.0 * this.ci))).subtract(w21.multiply(3.0 + this.ci * (2.0 - 5.0 * this.ci))).multiply(0.25 * this.yp2)).negate();
            UnivariateDerivative1 de = epp.add(d1e).add(d2e);
            UnivariateDerivative1 dl = eppd1l.add(eppd2l);
            UnivariateDerivative1 dh = sIppd1h.add(sIppd2h).divide(2.0 * ciO2);
            UnivariateDerivative1 di = (UnivariateDerivative1)d1I.add(d2I).multiply(0.5 * ciO2).add(siO2);
            UnivariateDerivative1 z = lpp.add(gpp).add(hpp).add(d1z).add(d2z);
            UnivariateDerivative1 a = app.add(d2a);
            UnivariateDerivative1 e = (UnivariateDerivative1)FastMath.sqrt((CalculusFieldElement)((UnivariateDerivative1)de.square()).add((UnivariateDerivative1)dl.square()));
            FieldSinCos sclpp = lpp.sinCos();
            UnivariateDerivative1 clpp = (UnivariateDerivative1)sclpp.cos();
            UnivariateDerivative1 slpp = (UnivariateDerivative1)sclpp.sin();
            UnivariateDerivative1 l = (UnivariateDerivative1)FastMath.atan2((CalculusFieldElement)de.multiply(slpp).add(dl.multiply(clpp)), (CalculusFieldElement)de.multiply(clpp).subtract(dl.multiply(slpp)));
            UnivariateDerivative1 i = (UnivariateDerivative1)FastMath.acos((CalculusFieldElement)((UnivariateDerivative1)((UnivariateDerivative1)di.square()).add((UnivariateDerivative1)dh.square()).multiply(2).negate().add(1.0)));
            FieldSinCos schpp = hpp.sinCos();
            UnivariateDerivative1 chpp = (UnivariateDerivative1)schpp.cos();
            UnivariateDerivative1 shpp = (UnivariateDerivative1)schpp.sin();
            UnivariateDerivative1 h = (UnivariateDerivative1)FastMath.atan2((CalculusFieldElement)di.multiply(shpp).add(dh.multiply(chpp)), (CalculusFieldElement)di.multiply(chpp).subtract(dh.multiply(shpp)));
            UnivariateDerivative1 g = z.subtract(l).subtract(h);
            return new KeplerianOrbit(a.getValue(), e.getValue(), i.getValue(), g.getValue(), h.getValue(), l.getValue(), a.getFirstDerivative(), e.getFirstDerivative(), i.getFirstDerivative(), g.getFirstDerivative(), h.getFirstDerivative(), l.getFirstDerivative(), PositionAngleType.MEAN, this.mean.getFrame(), date, BrouwerLyddanePropagator.this.mu);
        }
    }
}

