/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.List;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalGradientConverter;
import org.orekit.propagation.analytical.BrouwerLyddanePropagator;
import org.orekit.propagation.analytical.FieldBrouwerLyddanePropagator;
import org.orekit.utils.ParameterDriver;

class BrouwerLyddaneGradientConverter
extends AbstractAnalyticalGradientConverter {
    public static final int FREE_STATE_PARAMETERS = 6;
    private final BrouwerLyddanePropagator propagator;

    BrouwerLyddaneGradientConverter(BrouwerLyddanePropagator propagator) {
        super(propagator, propagator.getMu(), 6);
        this.propagator = propagator;
    }

    public FieldBrouwerLyddanePropagator<Gradient> getPropagator(FieldSpacecraftState<Gradient> state, Gradient[] parameters) {
        Gradient zero = state.getA().getField().getZero();
        double[] ck0 = this.propagator.getCk0();
        double radius = this.propagator.getReferenceRadius();
        AttitudeProvider provider = this.propagator.getAttitudeProvider();
        Gradient mu = zero.newInstance(this.propagator.getMu());
        return new FieldBrouwerLyddanePropagator<Gradient>(state.getOrbit(), provider, radius, mu, ck0[2], ck0[3], ck0[4], ck0[5], parameters[0].getValue());
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.propagator.getParametersDrivers();
    }
}

