/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collection;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AggregateBoundedPropagator
extends AbstractAnalyticalPropagator
implements BoundedPropagator {
    private final TimeSpanMap<BoundedPropagator> map = new TimeSpanMap<Object>(null);
    private final AbsoluteDate min;
    private final AbsoluteDate max;

    public AggregateBoundedPropagator(Collection<? extends BoundedPropagator> propagators) {
        super(null);
        propagators.forEach(p -> this.map.addValidAfter((BoundedPropagator)p, p.getMinDate(), false));
        this.setAttitudeProvider(new AggregateAttitudeProvider());
        this.min = this.map.getFirstNonNullSpan().getData().getMinDate();
        this.max = this.map.getLastNonNullSpan().getData().getMaxDate();
        super.resetInitialState(this.getInitialState());
    }

    public AggregateBoundedPropagator(NavigableMap<AbsoluteDate, ? extends BoundedPropagator> propagators, AbsoluteDate min, AbsoluteDate max) {
        super(null);
        propagators.forEach((d, p) -> this.map.addValidAfter((BoundedPropagator)p, p.getMinDate(), false));
        this.setAttitudeProvider(new AggregateAttitudeProvider());
        this.min = min;
        this.max = max;
        super.resetInitialState(this.getInitialState());
    }

    public TimeSpanMap<BoundedPropagator> getPropagatorsMap() {
        return this.map;
    }

    @Deprecated
    public NavigableMap<AbsoluteDate, BoundedPropagator> getPropagators() {
        TreeMap<AbsoluteDate, BoundedPropagator> nm = new TreeMap<AbsoluteDate, BoundedPropagator>();
        for (TimeSpanMap.Span<BoundedPropagator> span = this.map.getFirstNonNullSpan(); span != null; span = span.next()) {
            nm.put(span.getData().getMinDate(), span.getData());
        }
        return nm;
    }

    @Override
    protected SpacecraftState basicPropagate(AbsoluteDate date) {
        SpacecraftState state = this.getPropagator(date).propagate(date);
        Attitude attitude = this.getAttitudeProvider().getAttitude(this, date, state.getFrame());
        if (state.isOrbitDefined()) {
            return new SpacecraftState(state.getOrbit(), attitude, state.getMass(), state.getAdditionalStatesValues(), state.getAdditionalStatesDerivatives());
        }
        return new SpacecraftState(state.getAbsPVA(), attitude, state.getMass(), state.getAdditionalStatesValues(), state.getAdditionalStatesDerivatives());
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.getPropagator(date).getPVCoordinates(date, frame);
    }

    @Override
    public Vector3D getPosition(AbsoluteDate date, Frame frame) {
        return this.getPropagator(date).propagate(date).getPosition(frame);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return this.getPropagator(date).propagate(date).getOrbit();
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.min;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.max;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.getPropagator(date).propagate(date).getMass();
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.map.getFirstNonNullSpan().getData().getInitialState();
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    private BoundedPropagator getPropagator(AbsoluteDate date) {
        BoundedPropagator propagator = this.map.get(date);
        if (propagator != null) {
            return propagator;
        }
        return this.map.getFirstNonNullSpan().getData();
    }

    private class AggregateAttitudeProvider
    implements AttitudeProvider {
        private AggregateAttitudeProvider() {
        }

        @Override
        public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
            return AggregateBoundedPropagator.this.getPropagator(date).getAttitudeProvider().getAttitude(pvProv, date, frame);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
            return AggregateBoundedPropagator.this.getPropagator(date.toAbsoluteDate()).getAttitudeProvider().getAttitude(pvProv, date, frame);
        }

        @Override
        public Rotation getAttitudeRotation(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
            return AggregateBoundedPropagator.this.getPropagator(date).getAttitudeProvider().getAttitudeRotation(pvProv, date, frame);
        }

        @Override
        public <T extends CalculusFieldElement<T>> FieldRotation<T> getAttitudeRotation(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
            return AggregateBoundedPropagator.this.getPropagator(date.toAbsoluteDate()).getAttitudeProvider().getAttitudeRotation(pvProv, date, frame);
        }
    }
}

