/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.StateCovariance;
import org.orekit.time.AbsoluteDate;

public class StateCovarianceMatrixProvider
implements AdditionalStateProvider {
    private static final int STATE_DIMENSION = 6;
    private final String stmName;
    private final MatricesHarvester harvester;
    private final String additionalName;
    private final OrbitType stmOrbitType;
    private final PositionAngleType stmAngleType;
    private final OrbitType covOrbitType;
    private final PositionAngleType covAngleType;
    private StateCovariance covInit;
    private RealMatrix covMatrixInit;

    public StateCovarianceMatrixProvider(String additionalName, String stmName, MatricesHarvester harvester, StateCovariance covInit) {
        this.additionalName = additionalName;
        this.stmName = stmName;
        this.harvester = harvester;
        this.covInit = covInit;
        this.covOrbitType = covInit.getOrbitType();
        this.covAngleType = covInit.getPositionAngleType();
        this.stmOrbitType = harvester.getOrbitType();
        this.stmAngleType = harvester.getPositionAngleType();
    }

    @Override
    public String getName() {
        return this.additionalName;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        this.covInit = this.covInit.changeCovarianceType(initialState.getOrbit(), this.stmOrbitType, this.stmAngleType);
        Orbit initialOrbit = initialState.getOrbit();
        StateCovariance covInitInSTMFrame = this.covInit.changeCovarianceFrame(initialOrbit, initialOrbit.getFrame());
        this.covMatrixInit = covInitInSTMFrame.getMatrix();
    }

    @Override
    public boolean yields(SpacecraftState state) {
        return !state.hasAdditionalState(this.stmName);
    }

    @Override
    public double[] getAdditionalState(SpacecraftState state) {
        RealMatrix dYdY0 = this.harvester.getStateTransitionMatrix(state);
        RealMatrix propCov = dYdY0.multiply(this.covMatrixInit.multiplyTransposed(dYdY0));
        StateCovariance propagated = new StateCovariance(propCov, state.getDate(), state.getFrame(), this.stmOrbitType, this.stmAngleType);
        propCov = propagated.changeCovarianceType(state.getOrbit(), this.covOrbitType, this.covAngleType).getMatrix();
        return this.toArray(propCov);
    }

    public OrbitType getCovarianceOrbitType() {
        return this.covOrbitType;
    }

    public StateCovariance getStateCovariance(SpacecraftState state) {
        RealMatrix covarianceMatrix = this.toRealMatrix(this.getAdditionalState(state));
        StateCovariance covariance = new StateCovariance(covarianceMatrix, state.getDate(), state.getFrame(), this.covOrbitType, this.covAngleType);
        if (this.covInit.getLOF() == null) {
            return covariance;
        }
        return covariance.changeCovarianceFrame(state.getOrbit(), this.covInit.getLOF());
    }

    public StateCovariance getStateCovariance(SpacecraftState state, Frame frame) {
        return this.getStateCovariance(state).changeCovarianceFrame(state.getOrbit(), frame);
    }

    public StateCovariance getStateCovariance(SpacecraftState state, OrbitType orbitType, PositionAngleType angleType) {
        return this.getStateCovariance(state).changeCovarianceType(state.getOrbit(), orbitType, angleType);
    }

    private double[] toArray(RealMatrix covariance) {
        double[] array = new double[36];
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                array[index++] = covariance.getEntry(i, j);
            }
        }
        return array;
    }

    private RealMatrix toRealMatrix(double[] array) {
        RealMatrix matrix = MatrixUtils.createRealMatrix((int)6, (int)6);
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                matrix.setEntry(i, j, array[index++]);
            }
        }
        return matrix;
    }
}

