/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.AbstractStateCovarianceInterpolator;
import org.orekit.propagation.StateCovariance;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolator;
import org.orekit.time.TimeStampedPair;
import org.orekit.utils.CartesianDerivativesFilter;

public class StateCovarianceKeplerianHermiteInterpolator
extends AbstractStateCovarianceInterpolator {
    private final CartesianDerivativesFilter filter;

    public StateCovarianceKeplerianHermiteInterpolator(TimeInterpolator<Orbit> orbitInterpolator, LOFType outLOF) {
        this(2, orbitInterpolator, outLOF);
    }

    public StateCovarianceKeplerianHermiteInterpolator(int interpolationPoints, TimeInterpolator<Orbit> orbitInterpolator, LOFType outLOF) {
        this(interpolationPoints, orbitInterpolator, CartesianDerivativesFilter.USE_PVA, outLOF);
    }

    public StateCovarianceKeplerianHermiteInterpolator(int interpolationPoints, TimeInterpolator<Orbit> orbitInterpolator, CartesianDerivativesFilter filter, LOFType outLOF) {
        this(interpolationPoints, 0.001, orbitInterpolator, filter, outLOF);
    }

    public StateCovarianceKeplerianHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, TimeInterpolator<Orbit> orbitInterpolator, CartesianDerivativesFilter filter, LOFType outLOF) {
        super(interpolationPoints, extrapolationThreshold, orbitInterpolator, outLOF);
        this.filter = filter;
    }

    public StateCovarianceKeplerianHermiteInterpolator(TimeInterpolator<Orbit> orbitInterpolator, Frame outFrame, OrbitType outOrbitType, PositionAngleType outPositionAngleType) {
        this(2, orbitInterpolator, outFrame, outOrbitType, outPositionAngleType);
    }

    public StateCovarianceKeplerianHermiteInterpolator(int interpolationPoints, TimeInterpolator<Orbit> orbitInterpolator, Frame outFrame, OrbitType outOrbitType, PositionAngleType outPositionAngleType) {
        this(interpolationPoints, 0.001, orbitInterpolator, CartesianDerivativesFilter.USE_PVA, outFrame, outOrbitType, outPositionAngleType);
    }

    public StateCovarianceKeplerianHermiteInterpolator(int interpolationPoints, TimeInterpolator<Orbit> orbitInterpolator, CartesianDerivativesFilter filter, Frame outFrame, OrbitType outOrbitType, PositionAngleType outPositionAngleType) {
        this(interpolationPoints, 0.001, orbitInterpolator, filter, outFrame, outOrbitType, outPositionAngleType);
    }

    public StateCovarianceKeplerianHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, TimeInterpolator<Orbit> orbitInterpolator, CartesianDerivativesFilter filter, Frame outFrame, OrbitType outOrbitType, PositionAngleType outPositionAngleType) {
        super(interpolationPoints, extrapolationThreshold, orbitInterpolator, outFrame, outOrbitType, outPositionAngleType);
        this.filter = filter;
    }

    public CartesianDerivativesFilter getFilter() {
        return this.filter;
    }

    @Override
    protected StateCovariance computeInterpolatedCovarianceInOrbitFrame(List<TimeStampedPair<Orbit, StateCovariance>> uncertainStates, Orbit interpolatedOrbit) {
        ArrayList<double[][][]> covarianceValueAndDerivativesList = new ArrayList<double[][][]>();
        for (TimeStampedPair<Orbit, StateCovariance> uncertainState : uncertainStates) {
            double[][][] currentCovarianceValueAndDerivatives = this.computeAndCombineCovarianceValueAndDerivatives(uncertainState, interpolatedOrbit);
            covarianceValueAndDerivativesList.add(currentCovarianceValueAndDerivatives);
        }
        RealMatrix interpolatedCovarianceMatrixInEqui = this.computeInterpolatedStateCovariance(interpolatedOrbit.getDate(), uncertainStates, covarianceValueAndDerivativesList);
        return new StateCovariance(interpolatedCovarianceMatrixInEqui, interpolatedOrbit.getDate(), interpolatedOrbit.getFrame(), OrbitType.EQUINOCTIAL, DEFAULT_POSITION_ANGLE);
    }

    private double[][][] computeAndCombineCovarianceValueAndDerivatives(TimeStampedPair<Orbit, StateCovariance> uncertainState, Orbit interpolatedOrbit) {
        RealMatrix covarianceMatrixSecondDerInKep;
        RealMatrix covarianceMatrixFirstDerInKep;
        Orbit orbit = uncertainState.getFirst();
        StateCovariance covariance = uncertainState.getSecond();
        StateCovariance covarianceInOrbitFrame = covariance.changeCovarianceFrame(orbit, interpolatedOrbit.getFrame());
        StateCovariance covarianceInOrbitFrameInEqui = covarianceInOrbitFrame.changeCovarianceType(orbit, OrbitType.EQUINOCTIAL, DEFAULT_POSITION_ANGLE);
        RealMatrix covarianceInOrbitFrameInEquiMatrix = covarianceInOrbitFrameInEqui.getMatrix();
        int dim = 6;
        switch (this.filter) {
            case USE_P: {
                covarianceMatrixFirstDerInKep = MatrixUtils.createRealMatrix((int)6, (int)6);
                covarianceMatrixSecondDerInKep = MatrixUtils.createRealMatrix((int)6, (int)6);
                break;
            }
            case USE_PV: {
                covarianceMatrixFirstDerInKep = this.computeCovarianceFirstDerivative(orbit, covarianceInOrbitFrameInEquiMatrix);
                covarianceMatrixSecondDerInKep = MatrixUtils.createRealMatrix((int)6, (int)6);
                break;
            }
            case USE_PVA: {
                covarianceMatrixFirstDerInKep = this.computeCovarianceFirstDerivative(orbit, covarianceInOrbitFrameInEquiMatrix);
                covarianceMatrixSecondDerInKep = this.computeCovarianceSecondDerivative(orbit, covarianceInOrbitFrameInEquiMatrix);
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        return this.combineCovarianceValueAndDerivatives(covarianceInOrbitFrameInEquiMatrix, covarianceMatrixFirstDerInKep, covarianceMatrixSecondDerInKep);
    }

    private RealMatrix computeInterpolatedStateCovariance(AbsoluteDate interpolationDate, List<TimeStampedPair<Orbit, StateCovariance>> uncertainStates, List<double[][][]> covarianceValueAndDerivativesList) {
        BlockRealMatrix interpolatedCovarianceMatrix = new BlockRealMatrix(new double[6][6]);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                HermiteInterpolator tempInterpolator = new HermiteInterpolator();
                for (int k = 0; k < uncertainStates.size(); ++k) {
                    TimeStampedPair<Orbit, StateCovariance> currentUncertainStates = uncertainStates.get(k);
                    double[][][] currentCovarianceValueAndDerivatives = covarianceValueAndDerivativesList.get(k);
                    double deltaT = currentUncertainStates.getDate().durationFrom(interpolationDate);
                    this.addSampleToInterpolator(tempInterpolator, deltaT, currentCovarianceValueAndDerivatives[i][j]);
                }
                interpolatedCovarianceMatrix.setEntry(i, j, tempInterpolator.value(0.0)[0]);
            }
        }
        return interpolatedCovarianceMatrix;
    }

    private void addSampleToInterpolator(HermiteInterpolator interpolator, double deltaT, double[] valueAndDerivatives) {
        switch (this.filter) {
            case USE_P: {
                interpolator.addSamplePoint(deltaT, (double[][])new double[][]{{valueAndDerivatives[0]}});
                break;
            }
            case USE_PV: {
                interpolator.addSamplePoint(deltaT, (double[][])new double[][]{{valueAndDerivatives[0]}, {valueAndDerivatives[1]}});
                break;
            }
            case USE_PVA: {
                interpolator.addSamplePoint(deltaT, (double[][])new double[][]{{valueAndDerivatives[0]}, {valueAndDerivatives[1]}, {valueAndDerivatives[2]}});
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    private RealMatrix computeCovarianceFirstDerivative(Orbit orbit, RealMatrix covarianceMatrixInEqui) {
        BlockRealMatrix covarianceFirstDerivative = new BlockRealMatrix(6, 6);
        double m = orbit.getMeanAnomalyDotWrtA();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                double value;
                if (i != 5 && j != 5) {
                    covarianceFirstDerivative.setEntry(i, j, 0.0);
                    continue;
                }
                if (i == 5 && j != 5) {
                    value = covarianceMatrixInEqui.getEntry(0, j) * m;
                    covarianceFirstDerivative.setEntry(i, j, value);
                    covarianceFirstDerivative.setEntry(j, i, value);
                    continue;
                }
                value = 2.0 * covarianceMatrixInEqui.getEntry(0, 5) * m;
                covarianceFirstDerivative.setEntry(i, j, value);
            }
        }
        return covarianceFirstDerivative;
    }

    private RealMatrix computeCovarianceSecondDerivative(Orbit orbit, RealMatrix covarianceMatrixInEqui) {
        BlockRealMatrix covarianceSecondDerivative = new BlockRealMatrix(6, 6);
        double m = orbit.getMeanAnomalyDotWrtA();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (i == 5 && j == 5) {
                    double value = 2.0 * covarianceMatrixInEqui.getEntry(0, 0) * m * m;
                    covarianceSecondDerivative.setEntry(i, j, value);
                    continue;
                }
                covarianceSecondDerivative.setEntry(i, j, 0.0);
            }
        }
        return covarianceSecondDerivative;
    }

    private double[][][] combineCovarianceValueAndDerivatives(RealMatrix covarianceMatrixInEqui, RealMatrix covarianceMatrixFirstDerInEqui, RealMatrix covarianceMatrixSecondDerInEqui) {
        double[][][] covarianceValueAndDerivativesArray = new double[6][6][3];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                covarianceValueAndDerivativesArray[i][j][0] = covarianceMatrixInEqui.getEntry(i, j);
                covarianceValueAndDerivativesArray[i][j][1] = covarianceMatrixFirstDerInEqui.getEntry(i, j);
                covarianceValueAndDerivativesArray[i][j][2] = covarianceMatrixSecondDerInEqui.getEntry(i, j);
            }
        }
        return covarianceValueAndDerivativesArray;
    }
}

