/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.List;
import org.hipparchus.analysis.polynomials.SmoothStepFactory;
import org.hipparchus.linear.RealMatrix;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.AbstractStateCovarianceInterpolator;
import org.orekit.propagation.StateCovariance;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeInterpolator;
import org.orekit.time.TimeStampedPair;

public class StateCovarianceBlender
extends AbstractStateCovarianceInterpolator {
    private final SmoothStepFactory.SmoothStepFunction blendingFunction;

    public StateCovarianceBlender(SmoothStepFactory.SmoothStepFunction blendingFunction, TimeInterpolator<Orbit> orbitInterpolator, LOFType outLOF) {
        super(2, 0.0, orbitInterpolator, outLOF);
        this.blendingFunction = blendingFunction;
    }

    public StateCovarianceBlender(SmoothStepFactory.SmoothStepFunction blendingFunction, TimeInterpolator<Orbit> orbitInterpolator, Frame outFrame, OrbitType outOrbitType, PositionAngleType outPositionAngleType) {
        super(2, 0.0, orbitInterpolator, outFrame, outOrbitType, outPositionAngleType);
        this.blendingFunction = blendingFunction;
    }

    @Override
    protected StateCovariance computeInterpolatedCovarianceInOrbitFrame(List<TimeStampedPair<Orbit, StateCovariance>> uncertainStates, Orbit interpolatedOrbit) {
        TimeStampedPair<Orbit, StateCovariance> previousUncertainState = uncertainStates.get(0);
        TimeStampedPair<Orbit, StateCovariance> nextUncertainState = uncertainStates.get(1);
        AbsoluteDate interpolationDate = interpolatedOrbit.getDate();
        StateCovariance forwardedCovariance = this.propagateCovarianceAnalytically(interpolationDate, interpolatedOrbit, previousUncertainState);
        StateCovariance backwardedCovariance = this.propagateCovarianceAnalytically(interpolationDate, interpolatedOrbit, nextUncertainState);
        double timeParameter = this.getTimeParameter(interpolationDate, previousUncertainState.getDate(), nextUncertainState.getDate());
        double blendingValue = this.blendingFunction.value(timeParameter);
        RealMatrix forwardedCovarianceMatrix = forwardedCovariance.getMatrix();
        RealMatrix backwardedCovarianceMatrix = backwardedCovariance.getMatrix();
        RealMatrix blendedCovarianceMatrix = forwardedCovarianceMatrix.blendArithmeticallyWith(backwardedCovarianceMatrix, blendingValue);
        return new StateCovariance(blendedCovarianceMatrix, interpolationDate, interpolatedOrbit.getFrame(), OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
    }

    private StateCovariance propagateCovarianceAnalytically(AbsoluteDate interpolationTime, Orbit orbitAtInterpolatingTime, TimeStampedPair<Orbit, StateCovariance> tabulatedUncertainState) {
        Orbit tabulatedOrbit = tabulatedUncertainState.getFirst();
        StateCovariance tabulatedCovariance = tabulatedUncertainState.getSecond();
        Frame interpolatedOrbitFrame = orbitAtInterpolatingTime.getFrame();
        StateCovariance tabulatedCovarianceInOrbitFrame = tabulatedCovariance.changeCovarianceFrame(tabulatedOrbit, interpolatedOrbitFrame);
        RealMatrix covarianceMatrixInEquinoctial = tabulatedCovarianceInOrbitFrame.changeCovarianceType(tabulatedOrbit, OrbitType.EQUINOCTIAL, DEFAULT_POSITION_ANGLE).getMatrix();
        RealMatrix stateErrorTransitionMatrixInEquinoctial = StateCovariance.getStm(tabulatedOrbit, interpolationTime.durationFrom(tabulatedOrbit.getDate()));
        RealMatrix propagatedCovarianceMatrixInEquinoctial = stateErrorTransitionMatrixInEquinoctial.multiply(covarianceMatrixInEquinoctial.multiplyTransposed(stateErrorTransitionMatrixInEquinoctial));
        StateCovariance propagatedCovarianceInEquinoctial = new StateCovariance(propagatedCovarianceMatrixInEquinoctial, interpolationTime, interpolatedOrbitFrame, OrbitType.EQUINOCTIAL, DEFAULT_POSITION_ANGLE);
        return propagatedCovarianceInEquinoctial.changeCovarianceType(orbitAtInterpolatingTime, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
    }
}

