/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.KinematicTransform;
import org.orekit.frames.LOF;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.CartesianCovarianceUtils;

public class StateCovariance
implements TimeStamped {
    public static final int STATE_DIMENSION = 6;
    private static final PositionAngleType DEFAULT_POSITION_ANGLE = PositionAngleType.TRUE;
    private final RealMatrix orbitalCovariance;
    private final Frame frame;
    private final LOF lof;
    private final AbsoluteDate epoch;
    private final OrbitType orbitType;
    private final PositionAngleType angleType;

    public StateCovariance(RealMatrix orbitalCovariance, AbsoluteDate epoch, LOF lof) {
        this(orbitalCovariance, epoch, null, lof, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
    }

    public StateCovariance(RealMatrix orbitalCovariance, AbsoluteDate epoch, Frame covarianceFrame, OrbitType orbitType, PositionAngleType angleType) {
        this(orbitalCovariance, epoch, covarianceFrame, null, orbitType, angleType);
    }

    private StateCovariance(RealMatrix orbitalCovariance, AbsoluteDate epoch, Frame covarianceFrame, LOF lof, OrbitType orbitType, PositionAngleType angleType) {
        StateCovariance.checkFrameAndOrbitTypeConsistency(covarianceFrame, orbitType);
        this.orbitalCovariance = orbitalCovariance;
        this.epoch = epoch;
        this.frame = covarianceFrame;
        this.lof = lof;
        this.orbitType = orbitType;
        this.angleType = angleType;
    }

    public static void checkFrameAndOrbitTypeConsistency(Frame covarianceFrame, OrbitType inputType) {
        if (covarianceFrame != null && !covarianceFrame.isPseudoInertial() && inputType != OrbitType.CARTESIAN) {
            throw new OrekitException((Localizable)OrekitMessages.WRONG_ORBIT_PARAMETERS_TYPE, inputType.name(), OrbitType.CARTESIAN.name());
        }
    }

    public static boolean inputAndOutputAreIdentical(OrbitType inOrbitType, PositionAngleType inAngleType, OrbitType outOrbitType, PositionAngleType outAngleType) {
        return inOrbitType == outOrbitType && inAngleType == outAngleType;
    }

    public static boolean inputAndOutputOrbitTypesAreCartesian(OrbitType inOrbitType, OrbitType outOrbitType) {
        return inOrbitType == OrbitType.CARTESIAN && outOrbitType == OrbitType.CARTESIAN;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.epoch;
    }

    public RealMatrix getMatrix() {
        return this.orbitalCovariance;
    }

    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    public PositionAngleType getPositionAngleType() {
        return this.angleType;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public LOF getLOF() {
        return this.lof;
    }

    public StateCovariance changeCovarianceType(Orbit orbit, OrbitType outOrbitType, PositionAngleType outAngleType) {
        if (outOrbitType == this.orbitType && (outOrbitType == OrbitType.CARTESIAN || outAngleType == this.angleType)) {
            if (this.lof == null) {
                return new StateCovariance(this.orbitalCovariance, this.epoch, this.frame, this.orbitType, this.angleType);
            }
            return new StateCovariance(this.orbitalCovariance, this.epoch, this.lof);
        }
        if (this.frame != null) {
            if (this.frame.isPseudoInertial()) {
                return StateCovariance.changeTypeAndCreate(orbit, this.epoch, this.frame, this.orbitType, this.angleType, outOrbitType, outAngleType, this.orbitalCovariance);
            }
            throw new OrekitException((Localizable)OrekitMessages.CANNOT_CHANGE_COVARIANCE_TYPE_IF_DEFINED_IN_NON_INERTIAL_FRAME, new Object[0]);
        }
        throw new OrekitException((Localizable)OrekitMessages.CANNOT_CHANGE_COVARIANCE_TYPE_IF_DEFINED_IN_LOF, new Object[0]);
    }

    public StateCovariance changeCovarianceFrame(Orbit orbit, LOF lofOut) {
        if (this.lof != null) {
            if (lofOut == this.lof) {
                return new StateCovariance(this.orbitalCovariance, this.epoch, this.lof);
            }
            return StateCovariance.changeFrameAndCreate(orbit, this.epoch, this.lof, lofOut, this.orbitalCovariance);
        }
        return StateCovariance.changeFrameAndCreate(orbit, this.epoch, this.frame, lofOut, this.orbitalCovariance, this.orbitType, this.angleType);
    }

    public StateCovariance changeCovarianceFrame(Orbit orbit, Frame frameOut) {
        if (this.lof != null) {
            return StateCovariance.changeFrameAndCreate(orbit, this.epoch, this.lof, frameOut, this.orbitalCovariance);
        }
        if (this.frame == frameOut) {
            return new StateCovariance(this.orbitalCovariance, this.epoch, this.frame, this.orbitType, this.angleType);
        }
        return StateCovariance.changeFrameAndCreate(orbit, this.epoch, this.frame, frameOut, this.orbitalCovariance, this.orbitType, this.angleType);
    }

    public StateCovariance shiftedBy(Orbit orbit, double dt) {
        Orbit shifted = orbit.shiftedBy(dt);
        if (this.frame != null) {
            if (this.frame.isPseudoInertial()) {
                RealMatrix stm = StateCovariance.getStm(orbit, dt);
                StateCovariance inStmType = StateCovariance.changeTypeAndCreate(orbit, this.epoch, this.frame, this.orbitType, this.angleType, OrbitType.EQUINOCTIAL, PositionAngleType.MEAN, this.orbitalCovariance);
                RealMatrix shiftedCov = stm.multiply(inStmType.getMatrix().multiplyTransposed(stm));
                return StateCovariance.changeTypeAndCreate(shifted, shifted.getDate(), this.frame, OrbitType.EQUINOCTIAL, PositionAngleType.MEAN, this.orbitType, this.angleType, shiftedCov);
            }
            StateCovariance inOrbitFrame = this.changeCovarianceFrame(orbit, orbit.getFrame());
            StateCovariance shiftedCovariance = inOrbitFrame.shiftedBy(orbit, dt);
            return shiftedCovariance.changeCovarianceFrame(shifted, this.frame);
        }
        StateCovariance inOrbitFrame = this.changeCovarianceFrame(orbit, orbit.getFrame());
        StateCovariance shiftedCovariance = inOrbitFrame.shiftedBy(orbit, dt);
        return shiftedCovariance.changeCovarianceFrame(shifted, this.lof);
    }

    private static StateCovariance changeTypeAndCreate(Orbit orbit, AbsoluteDate date, Frame covFrame, OrbitType inOrbitType, PositionAngleType inAngleType, OrbitType outOrbitType, PositionAngleType outAngleType, RealMatrix inputCov) {
        if (StateCovariance.inputAndOutputOrbitTypesAreCartesian(inOrbitType, outOrbitType) || StateCovariance.inputAndOutputAreIdentical(inOrbitType, inAngleType, outOrbitType, outAngleType)) {
            return new StateCovariance(inputCov, date, covFrame, inOrbitType, inAngleType);
        }
        double[][] aOC = new double[6][6];
        Orbit orbitInOutputType = outOrbitType.convertType(orbit);
        orbitInOutputType.getJacobianWrtCartesian(outAngleType, aOC);
        Array2DRowRealMatrix dOdC = new Array2DRowRealMatrix(aOC, false);
        double[][] aCI = new double[6][6];
        Orbit orbitInInputType = inOrbitType.convertType(orbit);
        orbitInInputType.getJacobianWrtParameters(inAngleType, aCI);
        Array2DRowRealMatrix dCdI = new Array2DRowRealMatrix(aCI, false);
        RealMatrix dOdI = dOdC.multiply((RealMatrix)dCdI);
        RealMatrix outputCov = dOdI.multiply(inputCov.multiplyTransposed(dOdI));
        return new StateCovariance(outputCov, date, covFrame, outOrbitType, outAngleType);
    }

    private static StateCovariance changeFrameAndCreate(Orbit orbit, AbsoluteDate date, LOF lofIn, LOF lofOut, RealMatrix inputCartesianCov) {
        RealMatrix jacobianFromLofInToLofOut = StateCovariance.getJacobian(LOF.transformFromLOFInToLOFOut(lofIn, lofOut, date, orbit.getPVCoordinates()));
        RealMatrix cartesianCovarianceOut = jacobianFromLofInToLofOut.multiply(inputCartesianCov.multiplyTransposed(jacobianFromLofInToLofOut));
        return new StateCovariance(cartesianCovarianceOut, date, lofOut);
    }

    private static StateCovariance changeFrameAndCreate(Orbit orbit, AbsoluteDate date, Frame frameIn, LOF lofOut, RealMatrix inputCov, OrbitType covOrbitType, PositionAngleType covAngleType) {
        if (frameIn.isPseudoInertial()) {
            RealMatrix cartesianCovarianceIn = StateCovariance.changeTypeAndCreate(orbit, date, frameIn, covOrbitType, covAngleType, OrbitType.CARTESIAN, PositionAngleType.MEAN, inputCov).getMatrix();
            RealMatrix jacobianFromFrameInToLofOut = StateCovariance.getJacobian(lofOut.transformFromInertial(date, orbit.getPVCoordinates(frameIn)));
            RealMatrix cartesianCovarianceOut = jacobianFromFrameInToLofOut.multiply(cartesianCovarianceIn.multiplyTransposed(jacobianFromFrameInToLofOut));
            return new StateCovariance(cartesianCovarianceOut, date, lofOut);
        }
        Frame orbitInertialFrame = orbit.getFrame();
        RealMatrix cartesianCovarianceInOrbitFrame = StateCovariance.changeFrameAndCreate(orbit, date, frameIn, orbitInertialFrame, inputCov, OrbitType.CARTESIAN, PositionAngleType.MEAN).getMatrix();
        return StateCovariance.changeFrameAndCreate(orbit, date, orbitInertialFrame, lofOut, cartesianCovarianceInOrbitFrame, OrbitType.CARTESIAN, PositionAngleType.MEAN);
    }

    private static StateCovariance changeFrameAndCreate(Orbit orbit, AbsoluteDate date, LOF lofIn, Frame frameOut, RealMatrix inputCartesianCov) {
        if (frameOut.isPseudoInertial()) {
            RealMatrix jacobianFromLofInToFrameOut = StateCovariance.getJacobian(lofIn.transformFromInertial(date, orbit.getPVCoordinates(frameOut)).getInverse());
            RealMatrix transformedCovariance = jacobianFromLofInToFrameOut.multiply(inputCartesianCov.multiplyTransposed(jacobianFromLofInToFrameOut));
            return new StateCovariance(transformedCovariance, date, frameOut, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
        }
        RealMatrix jacobianFromLofInToOrbitFrame = StateCovariance.getJacobian(lofIn.transformFromInertial(date, orbit.getPVCoordinates()).getInverse());
        RealMatrix cartesianCovarianceInOrbitFrame = jacobianFromLofInToOrbitFrame.multiply(inputCartesianCov.multiplyTransposed(jacobianFromLofInToOrbitFrame));
        return StateCovariance.changeFrameAndCreate(orbit, date, orbit.getFrame(), frameOut, cartesianCovarianceInOrbitFrame, OrbitType.CARTESIAN, PositionAngleType.MEAN);
    }

    private static StateCovariance changeFrameAndCreate(Orbit orbit, AbsoluteDate date, Frame frameIn, Frame frameOut, RealMatrix inputCov, OrbitType covOrbitType, PositionAngleType covAngleType) {
        if (frameIn.isPseudoInertial()) {
            RealMatrix cartesianCovarianceIn = StateCovariance.changeTypeAndCreate(orbit, date, frameIn, covOrbitType, covAngleType, OrbitType.CARTESIAN, PositionAngleType.MEAN, inputCov).getMatrix();
            RealMatrix cartesianCovarianceOut = CartesianCovarianceUtils.changeReferenceFrame(frameIn, cartesianCovarianceIn, date, frameOut);
            if (frameOut.isPseudoInertial()) {
                return StateCovariance.changeTypeAndCreate(orbit, date, frameOut, OrbitType.CARTESIAN, PositionAngleType.MEAN, covOrbitType, covAngleType, cartesianCovarianceOut);
            }
            return new StateCovariance(cartesianCovarianceOut, date, frameOut, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
        }
        RealMatrix covInFrameOut = CartesianCovarianceUtils.changeReferenceFrame(frameIn, inputCov, date, frameOut);
        return new StateCovariance(covInFrameOut, date, frameOut, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
    }

    private static RealMatrix getJacobian(KinematicTransform transform) {
        return MatrixUtils.createRealMatrix((double[][])transform.getPVJacobian());
    }

    public static RealMatrix getStm(Orbit initialOrbit, double dt) {
        RealMatrix stm = MatrixUtils.createRealIdentityMatrix((int)6);
        double contribution = initialOrbit.getMeanAnomalyDotWrtA() * dt;
        stm.setEntry(5, 0, contribution);
        return stm;
    }
}

