/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hipparchus.util.Pair;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeInterpolator;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitHermiteInterpolator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.time.TimeInterpolator;
import org.orekit.time.TimeStamped;
import org.orekit.time.TimeStampedDouble;
import org.orekit.time.TimeStampedDoubleHermiteInterpolator;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.AbsolutePVCoordinatesHermiteInterpolator;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinatesHermiteInterpolator;

public class SpacecraftStateInterpolator
extends AbstractTimeInterpolator<SpacecraftState> {
    private final Frame outputFrame;
    private final TimeInterpolator<Orbit> orbitInterpolator;
    private final TimeInterpolator<AbsolutePVCoordinates> absPVAInterpolator;
    private final TimeInterpolator<TimeStampedDouble> massInterpolator;
    private final TimeInterpolator<Attitude> attitudeInterpolator;
    private final TimeInterpolator<TimeStampedDouble> additionalStateInterpolator;

    public SpacecraftStateInterpolator(Frame outputFrame) {
        this(2, outputFrame);
    }

    public SpacecraftStateInterpolator(int interpolationPoints, Frame outputFrame) {
        this(interpolationPoints, 0.001, outputFrame, outputFrame);
    }

    public SpacecraftStateInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame) {
        this(interpolationPoints, extrapolationThreshold, outputFrame, outputFrame);
    }

    public SpacecraftStateInterpolator(int interpolationPoints, Frame outputFrame, Frame attitudeReferenceFrame) {
        this(interpolationPoints, 0.001, outputFrame, attitudeReferenceFrame, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_RR);
    }

    public SpacecraftStateInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame, Frame attitudeReferenceFrame) {
        this(interpolationPoints, extrapolationThreshold, outputFrame, attitudeReferenceFrame, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_RR);
    }

    public SpacecraftStateInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame, Frame attitudeReferenceFrame, CartesianDerivativesFilter pvaFilter, AngularDerivativesFilter angularFilter) {
        this(interpolationPoints, extrapolationThreshold, outputFrame, new OrbitHermiteInterpolator(interpolationPoints, extrapolationThreshold, outputFrame, pvaFilter), new AbsolutePVCoordinatesHermiteInterpolator(interpolationPoints, extrapolationThreshold, outputFrame, pvaFilter), new TimeStampedDoubleHermiteInterpolator(interpolationPoints, extrapolationThreshold), new AttitudeInterpolator(attitudeReferenceFrame, new TimeStampedAngularCoordinatesHermiteInterpolator(interpolationPoints, extrapolationThreshold, angularFilter)), new TimeStampedDoubleHermiteInterpolator(interpolationPoints, extrapolationThreshold));
    }

    @Deprecated
    public SpacecraftStateInterpolator(Frame outputFrame, TimeInterpolator<Orbit> orbitInterpolator, TimeInterpolator<AbsolutePVCoordinates> absPVAInterpolator, TimeInterpolator<TimeStampedDouble> massInterpolator, TimeInterpolator<Attitude> attitudeInterpolator, TimeInterpolator<TimeStampedDouble> additionalStateInterpolator) {
        super(2, 0.001);
        this.checkAtLeastOneInterpolator(orbitInterpolator, absPVAInterpolator);
        this.outputFrame = outputFrame;
        this.orbitInterpolator = orbitInterpolator;
        this.absPVAInterpolator = absPVAInterpolator;
        this.massInterpolator = massInterpolator;
        this.attitudeInterpolator = attitudeInterpolator;
        this.additionalStateInterpolator = additionalStateInterpolator;
    }

    public SpacecraftStateInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame, TimeInterpolator<Orbit> orbitInterpolator, TimeInterpolator<AbsolutePVCoordinates> absPVAInterpolator, TimeInterpolator<TimeStampedDouble> massInterpolator, TimeInterpolator<Attitude> attitudeInterpolator, TimeInterpolator<TimeStampedDouble> additionalStateInterpolator) {
        super(interpolationPoints, extrapolationThreshold);
        this.checkAtLeastOneInterpolator(orbitInterpolator, absPVAInterpolator);
        this.outputFrame = outputFrame;
        this.orbitInterpolator = orbitInterpolator;
        this.absPVAInterpolator = absPVAInterpolator;
        this.massInterpolator = massInterpolator;
        this.attitudeInterpolator = attitudeInterpolator;
        this.additionalStateInterpolator = additionalStateInterpolator;
    }

    public static void checkSampleAndInterpolatorConsistency(List<SpacecraftState> sample, boolean orbitInterpolatorIsPresent, boolean absPVInterpolatorIsPresent) {
        SpacecraftState earliestState = sample.get(0);
        if (earliestState.isOrbitDefined() && !orbitInterpolatorIsPresent || !earliestState.isOrbitDefined() && !absPVInterpolatorIsPresent) {
            throw new OrekitIllegalArgumentException(OrekitMessages.WRONG_INTERPOLATOR_DEFINED_FOR_STATE_INTERPOLATION, new Object[0]);
        }
    }

    public static void checkStatesDefinitionsConsistency(List<SpacecraftState> states) {
        SpacecraftState s0 = states.get(0);
        boolean s0IsOrbitDefined = s0.isOrbitDefined();
        for (SpacecraftState state : states) {
            s0.ensureCompatibleAdditionalStates(state);
            if (s0IsOrbitDefined == state.isOrbitDefined()) continue;
            throw new OrekitIllegalArgumentException(OrekitMessages.DIFFERENT_STATE_DEFINITION, new Object[0]);
        }
    }

    @Override
    public SpacecraftState interpolate(AbsoluteDate interpolationDate, Collection<SpacecraftState> sample) {
        ArrayList<SpacecraftState> sampleList = new ArrayList<SpacecraftState>(sample);
        if (!sample.isEmpty()) {
            SpacecraftStateInterpolator.checkStatesDefinitionsConsistency(sampleList);
            SpacecraftStateInterpolator.checkSampleAndInterpolatorConsistency(sampleList, this.orbitInterpolator != null, this.absPVAInterpolator != null);
        }
        return super.interpolate(interpolationDate, sample);
    }

    @Override
    public List<TimeInterpolator<? extends TimeStamped>> getSubInterpolators() {
        ArrayList<TimeInterpolator<? extends TimeStamped>> subInterpolators = new ArrayList<TimeInterpolator<? extends TimeStamped>>();
        this.addOptionalSubInterpolatorIfDefined(this.orbitInterpolator, subInterpolators);
        this.addOptionalSubInterpolatorIfDefined(this.absPVAInterpolator, subInterpolators);
        this.addOptionalSubInterpolatorIfDefined(this.massInterpolator, subInterpolators);
        this.addOptionalSubInterpolatorIfDefined(this.attitudeInterpolator, subInterpolators);
        this.addOptionalSubInterpolatorIfDefined(this.additionalStateInterpolator, subInterpolators);
        return subInterpolators;
    }

    @Override
    protected SpacecraftState interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        DoubleArrayDictionary interpolatedAdditionalDot;
        DoubleArrayDictionary interpolatedAdditional;
        List samples = interpolationData.getNeighborList();
        SpacecraftState earliestState = (SpacecraftState)samples.get(0);
        boolean areOrbitDefined = earliestState.isOrbitDefined();
        ArrayList<Attitude> attitudes = new ArrayList<Attitude>();
        ArrayList<TimeStampedDouble> masses = new ArrayList<TimeStampedDouble>();
        List<DoubleArrayDictionary.Entry> additionalEntries = earliestState.getAdditionalStatesValues().getData();
        Map<String, List<Pair<AbsoluteDate, double[]>>> additionalSample = this.createAdditionalStateSample(additionalEntries);
        List<DoubleArrayDictionary.Entry> additionalDotEntries = earliestState.getAdditionalStatesDerivatives().getData();
        Map<String, List<Pair<AbsoluteDate, double[]>>> additionalDotSample = this.createAdditionalStateSample(additionalDotEntries);
        ArrayList<Orbit> orbitSample = new ArrayList<Orbit>();
        ArrayList<AbsolutePVCoordinates> absPVASample = new ArrayList<AbsolutePVCoordinates>();
        for (SpacecraftState state : samples) {
            AbsoluteDate currentDate = state.getDate();
            if (state.isOrbitDefined()) {
                orbitSample.add(state.getOrbit());
            } else {
                absPVASample.add(state.getAbsPVA());
            }
            if (this.massInterpolator != null) {
                masses.add(new TimeStampedDouble(state.getMass(), state.getDate()));
            }
            if (this.attitudeInterpolator != null) {
                attitudes.add(state.getAttitude());
            }
            if (this.additionalStateInterpolator == null) continue;
            for (Map.Entry<String, List<Pair<AbsoluteDate, double[]>>> entry : additionalSample.entrySet()) {
                entry.getValue().add((Pair<AbsoluteDate, double[]>)new Pair((Object)currentDate, (Object)state.getAdditionalState(entry.getKey())));
            }
            for (Map.Entry<String, List<Pair<AbsoluteDate, double[]>>> entry : additionalDotSample.entrySet()) {
                entry.getValue().add((Pair<AbsoluteDate, double[]>)new Pair((Object)currentDate, (Object)state.getAdditionalStateDerivative(entry.getKey())));
            }
        }
        AbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        double interpolatedMass = this.massInterpolator != null ? this.massInterpolator.interpolate(interpolationDate, masses).getValue() : 1000.0;
        if (this.additionalStateInterpolator != null) {
            interpolatedAdditional = this.interpolateAdditionalState(interpolationDate, additionalSample);
            interpolatedAdditionalDot = this.interpolateAdditionalState(interpolationDate, additionalDotSample);
        } else {
            interpolatedAdditional = null;
            interpolatedAdditionalDot = null;
        }
        if (areOrbitDefined && this.orbitInterpolator != null) {
            Orbit interpolatedOrbit = this.orbitInterpolator.interpolate(interpolationDate, orbitSample);
            Attitude interpolatedAttitude = this.interpolateAttitude(interpolationDate, attitudes, interpolatedOrbit);
            return new SpacecraftState(interpolatedOrbit, interpolatedAttitude, interpolatedMass, interpolatedAdditional, interpolatedAdditionalDot);
        }
        if (!areOrbitDefined && this.absPVAInterpolator != null) {
            AbsolutePVCoordinates interpolatedAbsPva = this.absPVAInterpolator.interpolate(interpolationDate, absPVASample);
            Attitude interpolatedAttitude = this.interpolateAttitude(interpolationDate, attitudes, interpolatedAbsPva);
            return new SpacecraftState(interpolatedAbsPva, interpolatedAttitude, interpolatedMass, interpolatedAdditional, interpolatedAdditionalDot);
        }
        throw new OrekitInternalError(null);
    }

    public Frame getOutputFrame() {
        return this.outputFrame;
    }

    public Optional<TimeInterpolator<Orbit>> getOrbitInterpolator() {
        return Optional.ofNullable(this.orbitInterpolator);
    }

    public Optional<TimeInterpolator<AbsolutePVCoordinates>> getAbsPVAInterpolator() {
        return Optional.ofNullable(this.absPVAInterpolator);
    }

    public Optional<TimeInterpolator<TimeStampedDouble>> getMassInterpolator() {
        return Optional.ofNullable(this.massInterpolator);
    }

    public Optional<TimeInterpolator<Attitude>> getAttitudeInterpolator() {
        return Optional.ofNullable(this.attitudeInterpolator);
    }

    public Optional<TimeInterpolator<TimeStampedDouble>> getAdditionalStateInterpolator() {
        return Optional.ofNullable(this.additionalStateInterpolator);
    }

    private void checkAtLeastOneInterpolator(TimeInterpolator<Orbit> orbitInterpolatorToCheck, TimeInterpolator<AbsolutePVCoordinates> absPVAInterpolatorToCheck) {
        if (orbitInterpolatorToCheck == null && absPVAInterpolatorToCheck == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NO_INTERPOLATOR_FOR_STATE_DEFINITION, new Object[0]);
        }
    }

    private Map<String, List<Pair<AbsoluteDate, double[]>>> createAdditionalStateSample(List<DoubleArrayDictionary.Entry> additionalEntries) {
        HashMap<String, List<Pair<AbsoluteDate, double[]>>> additionalSamples = new HashMap<String, List<Pair<AbsoluteDate, double[]>>>(additionalEntries.size());
        for (DoubleArrayDictionary.Entry entry : additionalEntries) {
            additionalSamples.put(entry.getKey(), new ArrayList());
        }
        return additionalSamples;
    }

    private DoubleArrayDictionary interpolateAdditionalState(AbsoluteDate interpolationDate, Map<String, List<Pair<AbsoluteDate, double[]>>> additionalSamples) {
        DoubleArrayDictionary interpolatedAdditional;
        if (additionalSamples.isEmpty()) {
            interpolatedAdditional = null;
        } else {
            interpolatedAdditional = new DoubleArrayDictionary(additionalSamples.size());
            for (Map.Entry<String, List<Pair<AbsoluteDate, double[]>>> entry : additionalSamples.entrySet()) {
                List<Pair<AbsoluteDate, double[]>> currentAdditionalSamples = entry.getValue();
                int nbOfValues = ((double[])currentAdditionalSamples.get(0).getValue()).length;
                double[] currentInterpolatedAdditional = new double[nbOfValues];
                for (int i = 0; i < nbOfValues; ++i) {
                    int currentIndex = i;
                    ArrayList currentValueSample = new ArrayList();
                    currentAdditionalSamples.forEach(currentSamples -> currentValueSample.add(new TimeStampedDouble(((double[])currentSamples.getValue())[currentIndex], (AbsoluteDate)currentSamples.getFirst())));
                    currentInterpolatedAdditional[i] = this.additionalStateInterpolator.interpolate(interpolationDate, currentValueSample).getValue();
                }
                interpolatedAdditional.put(entry.getKey(), currentInterpolatedAdditional);
            }
        }
        return interpolatedAdditional;
    }

    private Attitude interpolateAttitude(AbsoluteDate interpolationDate, List<Attitude> attitudes, PVCoordinatesProvider pvProvider) {
        if (attitudes.isEmpty()) {
            FrameAlignedProvider attitudeProvider = new FrameAlignedProvider(this.outputFrame);
            return attitudeProvider.getAttitude(pvProvider, interpolationDate, this.outputFrame);
        }
        return this.attitudeInterpolator.interpolate(interpolationDate, attitudes);
    }
}

