/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.io.Serializable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class SpacecraftState
implements TimeStamped,
TimeShiftable<SpacecraftState>,
Serializable {
    public static final double DEFAULT_MASS = 1000.0;
    private static final long serialVersionUID = 20211119L;
    private static final double DATE_INCONSISTENCY_THRESHOLD = 1.0E-7;
    private final Orbit orbit;
    private final AbsolutePVCoordinates absPva;
    private final Attitude attitude;
    private final double mass;
    private final DoubleArrayDictionary additional;
    private final DoubleArrayDictionary additionalDot;

    public SpacecraftState(Orbit orbit) {
        this(orbit, SpacecraftState.getDefaultAttitudeProvider(orbit.getFrame()).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), 1000.0, (DoubleArrayDictionary)null);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude) throws IllegalArgumentException {
        this(orbit, attitude, 1000.0, (DoubleArrayDictionary)null);
    }

    public SpacecraftState(Orbit orbit, double mass) {
        this(orbit, SpacecraftState.getDefaultAttitudeProvider(orbit.getFrame()).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, (DoubleArrayDictionary)null);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, double mass) throws IllegalArgumentException {
        this(orbit, attitude, mass, (DoubleArrayDictionary)null);
    }

    public SpacecraftState(Orbit orbit, DoubleArrayDictionary additional) {
        this(orbit, SpacecraftState.getDefaultAttitudeProvider(orbit.getFrame()).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), 1000.0, additional);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, DoubleArrayDictionary additional) throws IllegalArgumentException {
        this(orbit, attitude, 1000.0, additional);
    }

    public SpacecraftState(Orbit orbit, double mass, DoubleArrayDictionary additional) {
        this(orbit, SpacecraftState.getDefaultAttitudeProvider(orbit.getFrame()).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, additional);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, double mass, DoubleArrayDictionary additional) throws IllegalArgumentException {
        this(orbit, attitude, mass, additional, null);
    }

    public SpacecraftState(Orbit orbit, Attitude attitude, double mass, DoubleArrayDictionary additional, DoubleArrayDictionary additionalDot) throws IllegalArgumentException {
        SpacecraftState.checkConsistency(orbit, attitude);
        this.orbit = orbit;
        this.absPva = null;
        this.attitude = attitude;
        this.mass = mass;
        this.additional = additional == null ? new DoubleArrayDictionary() : additional;
        this.additionalDot = additionalDot == null ? new DoubleArrayDictionary() : new DoubleArrayDictionary(additionalDot);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva) {
        this(absPva, SpacecraftState.getDefaultAttitudeProvider(absPva.getFrame()).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), 1000.0, (DoubleArrayDictionary)null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude) throws IllegalArgumentException {
        this(absPva, attitude, 1000.0, (DoubleArrayDictionary)null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, double mass) {
        this(absPva, SpacecraftState.getDefaultAttitudeProvider(absPva.getFrame()).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), mass, (DoubleArrayDictionary)null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude, double mass) throws IllegalArgumentException {
        this(absPva, attitude, mass, (DoubleArrayDictionary)null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, DoubleArrayDictionary additional) {
        this(absPva, SpacecraftState.getDefaultAttitudeProvider(absPva.getFrame()).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), 1000.0, additional);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude, DoubleArrayDictionary additional) throws IllegalArgumentException {
        this(absPva, attitude, 1000.0, additional);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, double mass, DoubleArrayDictionary additional) {
        this(absPva, SpacecraftState.getDefaultAttitudeProvider(absPva.getFrame()).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), mass, additional);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude, double mass, DoubleArrayDictionary additional) throws IllegalArgumentException {
        this(absPva, attitude, mass, additional, null);
    }

    public SpacecraftState(AbsolutePVCoordinates absPva, Attitude attitude, double mass, DoubleArrayDictionary additional, DoubleArrayDictionary additionalDot) throws IllegalArgumentException {
        SpacecraftState.checkConsistency(absPva, attitude);
        this.orbit = null;
        this.absPva = absPva;
        this.attitude = attitude;
        this.mass = mass;
        this.additional = additional == null ? new DoubleArrayDictionary() : new DoubleArrayDictionary(additional);
        this.additionalDot = additionalDot == null ? new DoubleArrayDictionary() : new DoubleArrayDictionary(additionalDot);
    }

    public SpacecraftState addAdditionalState(String name, double ... value) {
        DoubleArrayDictionary newDict = new DoubleArrayDictionary(this.additional);
        newDict.put(name, (double[])value.clone());
        if (this.isOrbitDefined()) {
            return new SpacecraftState(this.orbit, this.attitude, this.mass, newDict, this.additionalDot);
        }
        return new SpacecraftState(this.absPva, this.attitude, this.mass, newDict, this.additionalDot);
    }

    public SpacecraftState addAdditionalStateDerivative(String name, double ... value) {
        DoubleArrayDictionary newDict = new DoubleArrayDictionary(this.additionalDot);
        newDict.put(name, (double[])value.clone());
        if (this.isOrbitDefined()) {
            return new SpacecraftState(this.orbit, this.attitude, this.mass, this.additional, newDict);
        }
        return new SpacecraftState(this.absPva, this.attitude, this.mass, this.additional, newDict);
    }

    private static void checkConsistency(Orbit orbit, Attitude attitude) throws IllegalArgumentException {
        if (FastMath.abs((double)orbit.getDate().durationFrom(attitude.getDate())) > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, orbit.getDate(), attitude.getDate());
        }
        if (orbit.getFrame() != attitude.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, orbit.getFrame().getName(), attitude.getReferenceFrame().getName());
        }
    }

    static AttitudeProvider getDefaultAttitudeProvider(Frame frame) {
        return new FrameAlignedProvider(frame);
    }

    public boolean isOrbitDefined() {
        return this.orbit != null;
    }

    private static void checkConsistency(AbsolutePVCoordinates absPva, Attitude attitude) throws IllegalArgumentException {
        if (FastMath.abs((double)absPva.getDate().durationFrom(attitude.getDate())) > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, absPva.getDate(), attitude.getDate());
        }
        if (absPva.getFrame() != attitude.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, absPva.getFrame().getName(), attitude.getReferenceFrame().getName());
        }
    }

    @Override
    public SpacecraftState shiftedBy(double dt) {
        if (this.isOrbitDefined()) {
            return new SpacecraftState(this.orbit.shiftedBy(dt), this.attitude.shiftedBy(dt), this.mass, this.shiftAdditional(dt), this.additionalDot);
        }
        return new SpacecraftState(this.absPva.shiftedBy(dt), this.attitude.shiftedBy(dt), this.mass, this.shiftAdditional(dt), this.additionalDot);
    }

    private DoubleArrayDictionary shiftAdditional(double dt) {
        if (this.additionalDot.size() == 0) {
            return this.additional;
        }
        DoubleArrayDictionary shifted = new DoubleArrayDictionary(this.additional);
        for (DoubleArrayDictionary.Entry dotEntry : this.additionalDot.getData()) {
            DoubleArrayDictionary.Entry entry = shifted.getEntry(dotEntry.getKey());
            if (entry == null) continue;
            entry.scaledIncrement(dt, dotEntry);
        }
        return shifted;
    }

    public AbsolutePVCoordinates getAbsPVA() throws OrekitIllegalStateException {
        if (this.isOrbitDefined()) {
            throw new OrekitIllegalStateException(OrekitMessages.UNDEFINED_ABSOLUTE_PVCOORDINATES, new Object[0]);
        }
        return this.absPva;
    }

    public Orbit getOrbit() throws OrekitIllegalStateException {
        if (this.orbit == null) {
            throw new OrekitIllegalStateException(OrekitMessages.UNDEFINED_ORBIT, new Object[0]);
        }
        return this.orbit;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.absPva == null ? this.orbit.getDate() : this.absPva.getDate();
    }

    public Frame getFrame() {
        return this.isOrbitDefined() ? this.orbit.getFrame() : this.absPva.getFrame();
    }

    public boolean hasAdditionalState(String name) {
        return this.additional.getEntry(name) != null;
    }

    public boolean hasAdditionalStateDerivative(String name) {
        return this.additionalDot.getEntry(name) != null;
    }

    public void ensureCompatibleAdditionalStates(SpacecraftState state) throws MathIllegalStateException {
        double[] other;
        for (DoubleArrayDictionary.Entry entry : this.additional.getData()) {
            other = state.additional.get(entry.getKey());
            if (other == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
            if (other.length == entry.getValue().length) continue;
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{other.length, entry.getValue().length});
        }
        for (DoubleArrayDictionary.Entry entry : this.additionalDot.getData()) {
            other = state.additionalDot.get(entry.getKey());
            if (other == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
            if (other.length == entry.getValue().length) continue;
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{other.length, entry.getValue().length});
        }
        if (state.additional.size() > this.additional.size()) {
            for (DoubleArrayDictionary.Entry entry : state.additional.getData()) {
                if (this.additional.getEntry(entry.getKey()) != null) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
        }
        if (state.additionalDot.size() > this.additionalDot.size()) {
            for (DoubleArrayDictionary.Entry entry : state.additionalDot.getData()) {
                if (this.additionalDot.getEntry(entry.getKey()) != null) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
        }
    }

    public double[] getAdditionalState(String name) {
        DoubleArrayDictionary.Entry entry = this.additional.getEntry(name);
        if (entry == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
        }
        return entry.getValue();
    }

    public double[] getAdditionalStateDerivative(String name) {
        DoubleArrayDictionary.Entry entry = this.additionalDot.getEntry(name);
        if (entry == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
        }
        return entry.getValue();
    }

    public DoubleArrayDictionary getAdditionalStatesValues() {
        return this.additional.unmodifiableView();
    }

    public DoubleArrayDictionary getAdditionalStatesDerivatives() {
        return this.additionalDot.unmodifiableView();
    }

    public Transform toTransform() {
        TimeStampedPVCoordinates pv = this.getPVCoordinates();
        return new Transform(pv.getDate(), pv.negate(), this.attitude.getOrientation());
    }

    public StaticTransform toStaticTransform() {
        return StaticTransform.of(this.getDate(), this.getPosition().negate(), this.attitude.getRotation());
    }

    public double getMu() {
        return this.isOrbitDefined() ? this.orbit.getMu() : Double.NaN;
    }

    public double getKeplerianPeriod() {
        return this.isOrbitDefined() ? this.orbit.getKeplerianPeriod() : Double.NaN;
    }

    public double getKeplerianMeanMotion() {
        return this.isOrbitDefined() ? this.orbit.getKeplerianMeanMotion() : Double.NaN;
    }

    public double getA() {
        return this.isOrbitDefined() ? this.orbit.getA() : Double.NaN;
    }

    public double getEquinoctialEx() {
        return this.isOrbitDefined() ? this.orbit.getEquinoctialEx() : Double.NaN;
    }

    public double getEquinoctialEy() {
        return this.isOrbitDefined() ? this.orbit.getEquinoctialEy() : Double.NaN;
    }

    public double getHx() {
        return this.isOrbitDefined() ? this.orbit.getHx() : Double.NaN;
    }

    public double getHy() {
        return this.isOrbitDefined() ? this.orbit.getHy() : Double.NaN;
    }

    public double getLv() {
        return this.isOrbitDefined() ? this.orbit.getLv() : Double.NaN;
    }

    public double getLE() {
        return this.isOrbitDefined() ? this.orbit.getLE() : Double.NaN;
    }

    public double getLM() {
        return this.isOrbitDefined() ? this.orbit.getLM() : Double.NaN;
    }

    public double getE() {
        return this.isOrbitDefined() ? this.orbit.getE() : Double.NaN;
    }

    public double getI() {
        return this.isOrbitDefined() ? this.orbit.getI() : Double.NaN;
    }

    public Vector3D getPosition() {
        return this.isOrbitDefined() ? this.orbit.getPosition() : this.absPva.getPosition();
    }

    public TimeStampedPVCoordinates getPVCoordinates() {
        return this.isOrbitDefined() ? this.orbit.getPVCoordinates() : this.absPva.getPVCoordinates();
    }

    public Vector3D getPosition(Frame outputFrame) {
        return this.isOrbitDefined() ? this.orbit.getPosition(outputFrame) : this.absPva.getPosition(outputFrame);
    }

    public TimeStampedPVCoordinates getPVCoordinates(Frame outputFrame) {
        return this.isOrbitDefined() ? this.orbit.getPVCoordinates(outputFrame) : this.absPva.getPVCoordinates(outputFrame);
    }

    public Attitude getAttitude() {
        return this.attitude;
    }

    public double getMass() {
        return this.mass;
    }

    private Object writeReplace() {
        return this.isOrbitDefined() ? new DTOO(this) : new DTOA(this);
    }

    public String toString() {
        return "SpacecraftState{orbit=" + this.orbit + ", attitude=" + this.attitude + ", mass=" + this.mass + ", additional=" + this.additional + ", additionalDot=" + this.additionalDot + '}';
    }

    private static class DTOA
    implements Serializable {
        private static final long serialVersionUID = 20211121L;
        private final AbsolutePVCoordinates absPva;
        private double[] d;
        private final DoubleArrayDictionary additional;
        private final DoubleArrayDictionary additionalDot;

        private DTOA(SpacecraftState state) {
            this.absPva = state.absPva;
            this.additional = state.additional.getData().isEmpty() ? null : state.additional;
            this.additionalDot = state.additionalDot.getData().isEmpty() ? null : state.additionalDot;
            Rotation rotation = state.attitude.getRotation();
            Vector3D spin = state.attitude.getSpin();
            Vector3D rotationAcceleration = state.attitude.getRotationAcceleration();
            this.d = new double[]{rotation.getQ0(), rotation.getQ1(), rotation.getQ2(), rotation.getQ3(), spin.getX(), spin.getY(), spin.getZ(), rotationAcceleration.getX(), rotationAcceleration.getY(), rotationAcceleration.getZ(), state.mass};
        }

        private Object readResolve() {
            return new SpacecraftState(this.absPva, new Attitude(this.absPva.getFrame(), new TimeStampedAngularCoordinates(this.absPva.getDate(), new Rotation(this.d[0], this.d[1], this.d[2], this.d[3], false), new Vector3D(this.d[4], this.d[5], this.d[6]), new Vector3D(this.d[7], this.d[8], this.d[9]))), this.d[10], this.additional, this.additionalDot);
        }
    }

    private static class DTOO
    implements Serializable {
        private static final long serialVersionUID = 20211121L;
        private final Orbit orbit;
        private double[] d;
        private final DoubleArrayDictionary additional;
        private final DoubleArrayDictionary additionalDot;

        private DTOO(SpacecraftState state) {
            this.orbit = state.orbit;
            this.additional = state.additional.getData().isEmpty() ? null : state.additional;
            this.additionalDot = state.additionalDot.getData().isEmpty() ? null : state.additionalDot;
            Rotation rotation = state.attitude.getRotation();
            Vector3D spin = state.attitude.getSpin();
            Vector3D rotationAcceleration = state.attitude.getRotationAcceleration();
            this.d = new double[]{rotation.getQ0(), rotation.getQ1(), rotation.getQ2(), rotation.getQ3(), spin.getX(), spin.getY(), spin.getZ(), rotationAcceleration.getX(), rotationAcceleration.getY(), rotationAcceleration.getZ(), state.mass};
        }

        private Object readResolve() {
            return new SpacecraftState(this.orbit, new Attitude(this.orbit.getFrame(), new TimeStampedAngularCoordinates(this.orbit.getDate(), new Rotation(this.d[0], this.d[1], this.d[2], this.d[3], false), new Vector3D(this.d[4], this.d[5], this.d[6]), new Vector3D(this.d[7], this.d[8], this.d[9]))), this.d[10], this.additional, this.additionalDot);
        }
    }
}

