/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.MultiSatFixedStepHandler;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.sampling.MultisatStepNormalizer;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.propagation.sampling.StepHandlerMultiplexer;
import org.orekit.time.AbsoluteDate;

public class PropagatorsParallelizer {
    private static long MAX_WAIT = 10L;
    private final List<Propagator> propagators;
    private final MultiSatStepHandler globalHandler;

    public PropagatorsParallelizer(List<Propagator> propagators, MultiSatStepHandler globalHandler) {
        this.propagators = propagators;
        this.globalHandler = globalHandler;
    }

    public PropagatorsParallelizer(List<Propagator> propagators, double h, MultiSatFixedStepHandler globalHandler) {
        this.propagators = propagators;
        this.globalHandler = new MultisatStepNormalizer(h, globalHandler);
    }

    public List<Propagator> getPropagators() {
        return Collections.unmodifiableList(this.propagators);
    }

    /*
     * WARNING - void declaration
     */
    public List<SpacecraftState> propagate(AbsoluteDate start, AbsoluteDate target) {
        if (this.propagators.size() == 1) {
            this.propagators.get(0).getMultiplexer().add(new SinglePropagatorHandler(this.globalHandler));
            return Collections.singletonList(this.propagators.get(0).propagate(start, target));
        }
        double sign = FastMath.copySign((double)1.0, (double)target.durationFrom(start));
        ExecutorService executorService = Executors.newFixedThreadPool(this.propagators.size());
        ArrayList<Object> monitors = new ArrayList<Object>(this.propagators.size());
        for (Propagator propagator : this.propagators) {
            PropagatorMonitoring monitor = new PropagatorMonitoring(propagator, start, target, executorService);
            monitor.waitFirstStepCompletion();
            monitors.add(monitor);
        }
        AbsoluteDate previousDate = start;
        ArrayList<SpacecraftState> initialStates = new ArrayList<SpacecraftState>(monitors.size());
        for (PropagatorMonitoring propagatorMonitoring : monitors) {
            initialStates.add(propagatorMonitoring.parameters.initialState);
        }
        this.globalHandler.init(initialStates, target);
        boolean isLast = false;
        while (!isLast) {
            void var11_17;
            void var10_14;
            Object var10_13 = null;
            Object var11_18 = null;
            for (PropagatorMonitoring propagatorMonitoring : monitors) {
                AbsoluteDate absoluteDate = propagatorMonitoring.parameters.interpolator.getCurrentState().getDate();
                if (var10_14 != null && !(sign * var11_17.durationFrom(absoluteDate) > 0.0)) continue;
                PropagatorMonitoring propagatorMonitoring2 = propagatorMonitoring;
                AbsoluteDate absoluteDate2 = absoluteDate;
            }
            for (PropagatorMonitoring propagatorMonitoring : monitors) {
                OrekitStepInterpolator orekitStepInterpolator = propagatorMonitoring.parameters.interpolator;
                SpacecraftState previousState = orekitStepInterpolator.getInterpolatedState(previousDate);
                SpacecraftState currentState = orekitStepInterpolator.getInterpolatedState((AbsoluteDate)var11_17);
                propagatorMonitoring.restricted = orekitStepInterpolator.restrictStep(previousState, currentState);
            }
            ArrayList<OrekitStepInterpolator> interpolators = new ArrayList<OrekitStepInterpolator>(monitors.size());
            for (PropagatorMonitoring propagatorMonitoring : monitors) {
                interpolators.add(propagatorMonitoring.restricted);
            }
            this.globalHandler.handleStep(interpolators);
            if (((PropagatorMonitoring)var10_14).parameters.finalState == null) {
                var10_14.retrieveNextParameters();
            } else {
                isLast = true;
                for (PropagatorMonitoring propagatorMonitoring : monitors) {
                    if (propagatorMonitoring == var10_14) continue;
                    propagatorMonitoring.retrieveNextParameters();
                }
            }
            previousDate = var11_17;
        }
        executorService.shutdownNow();
        ArrayList<SpacecraftState> finalStates = new ArrayList<SpacecraftState>(monitors.size());
        for (PropagatorMonitoring propagatorMonitoring : monitors) {
            try {
                finalStates.add((SpacecraftState)propagatorMonitoring.future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                propagatorMonitoring.manageException(e);
                finalStates.add(propagatorMonitoring.parameters.interpolator.getInterpolatedState(previousDate));
            }
        }
        this.globalHandler.finish(finalStates);
        return finalStates;
    }

    private static class PropagatorMonitoring {
        private final SynchronousQueue<ParametersContainer> queue = new SynchronousQueue();
        private final Future<SpacecraftState> future;
        private ParametersContainer parameters;
        private OrekitStepInterpolator restricted;

        PropagatorMonitoring(Propagator propagator, AbsoluteDate start, AbsoluteDate target, ExecutorService executorService) {
            this.clearMultiplePropagatorsHandler(propagator);
            propagator.getMultiplexer().add(new MultiplePropagatorsHandler(this.queue));
            this.future = executorService.submit(() -> propagator.propagate(start, target));
        }

        public void waitFirstStepCompletion() {
            while (this.parameters == null || this.parameters.initialState == null || this.parameters.interpolator == null) {
                this.retrieveNextParameters();
            }
        }

        public void retrieveNextParameters() {
            try {
                ParametersContainer params = null;
                while (params == null && !this.future.isDone()) {
                    params = this.queue.poll(MAX_WAIT, TimeUnit.MILLISECONDS);
                    if (this.parameters == null || this.parameters.finalState == null) continue;
                }
                if (params == null) {
                    this.future.get();
                }
                this.parameters = params;
            }
            catch (InterruptedException | ExecutionException e) {
                this.manageException(e);
                this.parameters = null;
            }
        }

        private void manageException(Exception exception) {
            if (exception.getCause() instanceof PropagatorStoppingException) {
                return;
            }
            if (exception.getCause() instanceof OrekitException) {
                throw (OrekitException)exception.getCause();
            }
            throw new OrekitException(exception.getCause(), (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, exception.getLocalizedMessage());
        }

        private void clearMultiplePropagatorsHandler(Propagator propagator) {
            StepHandlerMultiplexer multiplexer = propagator.getMultiplexer();
            ArrayList<OrekitStepHandler> existingMultiplePropagatorsHandler = new ArrayList<OrekitStepHandler>();
            for (OrekitStepHandler handler : multiplexer.getHandlers()) {
                if (!(handler instanceof MultiplePropagatorsHandler)) continue;
                existingMultiplePropagatorsHandler.add(handler);
            }
            for (OrekitStepHandler handler : existingMultiplePropagatorsHandler) {
                multiplexer.remove(handler);
            }
        }
    }

    private static class ParametersContainer {
        private final SpacecraftState initialState;
        private final OrekitStepInterpolator interpolator;
        private final SpacecraftState finalState;

        ParametersContainer(SpacecraftState initialState, OrekitStepInterpolator interpolator, SpacecraftState finalState) {
            this.initialState = initialState;
            this.interpolator = interpolator;
            this.finalState = finalState;
        }
    }

    private static class MultiplePropagatorsHandler
    implements OrekitStepHandler {
        private ParametersContainer previous = new ParametersContainer(null, null, null);
        private final SynchronousQueue<ParametersContainer> queue;

        MultiplePropagatorsHandler(SynchronousQueue<ParametersContainer> queue) {
            this.queue = queue;
        }

        private void handOff(ParametersContainer container) {
            try {
                this.previous = container;
                this.queue.put(this.previous);
            }
            catch (InterruptedException ie) {
                throw new PropagatorStoppingException(ie);
            }
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            this.handOff(new ParametersContainer(s0, null, null));
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator) {
            this.handOff(new ParametersContainer(this.previous.initialState, interpolator, null));
        }

        @Override
        public void finish(SpacecraftState finalState) {
            this.handOff(new ParametersContainer(this.previous.initialState, this.previous.interpolator, finalState));
        }
    }

    private static class SinglePropagatorHandler
    implements OrekitStepHandler {
        private final MultiSatStepHandler globalHandler;

        SinglePropagatorHandler(MultiSatStepHandler globalHandler) {
            this.globalHandler = globalHandler;
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            this.globalHandler.init(Collections.singletonList(s0), t);
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator) {
            this.globalHandler.handleStep(Collections.singletonList(interpolator));
        }

        @Override
        public void finish(SpacecraftState finalState) {
            this.globalHandler.finish(Collections.singletonList(finalState));
        }
    }

    private static class PropagatorStoppingException
    extends OrekitException {
        private static final long serialVersionUID = 20170629L;

        PropagatorStoppingException(InterruptedException ie) {
            super(ie, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ie.getLocalizedMessage());
        }
    }
}

