/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.Array2DRowFieldMatrix;
import org.hipparchus.linear.BlockRealMatrix;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOF;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.StateCovariance;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;

public class FieldStateCovariance<T extends CalculusFieldElement<T>>
implements FieldTimeStamped<T> {
    private static final int STATE_DIMENSION = 6;
    private static final PositionAngleType DEFAULT_POSITION_ANGLE = PositionAngleType.TRUE;
    private final FieldMatrix<T> orbitalCovariance;
    private final Frame frame;
    private final LOF lof;
    private final FieldAbsoluteDate<T> epoch;
    private final OrbitType orbitType;
    private final PositionAngleType angleType;

    public FieldStateCovariance(FieldMatrix<T> orbitalCovariance, FieldAbsoluteDate<T> epoch, LOF lof) {
        this(orbitalCovariance, epoch, null, lof, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
    }

    public FieldStateCovariance(FieldMatrix<T> orbitalCovariance, FieldAbsoluteDate<T> epoch, Frame covarianceFrame, OrbitType orbitType, PositionAngleType angleType) {
        this(orbitalCovariance, epoch, covarianceFrame, null, orbitType, angleType);
    }

    private FieldStateCovariance(FieldMatrix<T> orbitalCovariance, FieldAbsoluteDate<T> epoch, Frame covarianceFrame, LOF lof, OrbitType orbitType, PositionAngleType angleType) {
        StateCovariance.checkFrameAndOrbitTypeConsistency(covarianceFrame, orbitType);
        this.orbitalCovariance = orbitalCovariance;
        this.epoch = epoch;
        this.frame = covarianceFrame;
        this.lof = lof;
        this.orbitType = orbitType;
        this.angleType = angleType;
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.epoch;
    }

    public FieldMatrix<T> getMatrix() {
        return this.orbitalCovariance;
    }

    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    public PositionAngleType getPositionAngleType() {
        return this.angleType;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public LOF getLOF() {
        return this.lof;
    }

    public FieldStateCovariance<T> changeCovarianceType(FieldOrbit<T> orbit, OrbitType outOrbitType, PositionAngleType outAngleType) {
        if (outOrbitType == this.orbitType && (outOrbitType == OrbitType.CARTESIAN || outAngleType == this.angleType)) {
            if (this.lof == null) {
                return new FieldStateCovariance<T>(this.orbitalCovariance, this.epoch, this.frame, this.orbitType, this.angleType);
            }
            return new FieldStateCovariance<T>(this.orbitalCovariance, this.epoch, this.lof);
        }
        if (this.frame != null) {
            if (this.frame.isPseudoInertial()) {
                return this.changeTypeAndCreate(orbit, this.epoch, this.frame, this.orbitType, this.angleType, outOrbitType, outAngleType, this.orbitalCovariance);
            }
            throw new OrekitException((Localizable)OrekitMessages.CANNOT_CHANGE_COVARIANCE_TYPE_IF_DEFINED_IN_NON_INERTIAL_FRAME, new Object[0]);
        }
        throw new OrekitException((Localizable)OrekitMessages.CANNOT_CHANGE_COVARIANCE_TYPE_IF_DEFINED_IN_LOF, new Object[0]);
    }

    public FieldStateCovariance<T> changeCovarianceFrame(FieldOrbit<T> orbit, LOF lofOut) {
        if (this.lof != null) {
            if (lofOut == this.lof) {
                return new FieldStateCovariance<T>(this.orbitalCovariance, this.epoch, this.lof);
            }
            return this.changeFrameAndCreate(orbit, this.epoch, this.lof, lofOut, this.orbitalCovariance);
        }
        return this.changeFrameAndCreate(orbit, this.epoch, this.frame, lofOut, this.orbitalCovariance, this.orbitType, this.angleType);
    }

    public FieldStateCovariance<T> changeCovarianceFrame(FieldOrbit<T> orbit, Frame frameOut) {
        if (this.lof != null) {
            return this.changeFrameAndCreate(orbit, this.epoch, this.lof, frameOut, this.orbitalCovariance);
        }
        if (this.frame == frameOut) {
            return new FieldStateCovariance<T>(this.orbitalCovariance, this.epoch, this.frame, this.orbitType, this.angleType);
        }
        return this.changeFrameAndCreate(orbit, this.epoch, this.frame, frameOut, this.orbitalCovariance, this.orbitType, this.angleType);
    }

    public FieldStateCovariance<T> shiftedBy(Field<T> field, FieldOrbit<T> orbit, T dt) {
        FieldTimeShiftable shifted = orbit.shiftedBy((CalculusFieldElement)dt);
        if (this.frame != null) {
            if (this.frame.isPseudoInertial()) {
                FieldMatrix<T> stm = this.getStm(field, orbit, dt);
                FieldStateCovariance<T> inStmType = this.changeTypeAndCreate(orbit, this.epoch, this.frame, this.orbitType, this.angleType, OrbitType.EQUINOCTIAL, PositionAngleType.MEAN, this.orbitalCovariance);
                FieldMatrix shiftedCov = stm.multiply(inStmType.getMatrix().multiplyTransposed(stm));
                return this.changeTypeAndCreate((FieldOrbit<T>)shifted, ((FieldOrbit)shifted).getDate(), this.frame, OrbitType.EQUINOCTIAL, PositionAngleType.MEAN, this.orbitType, this.angleType, (FieldMatrix<T>)shiftedCov);
            }
            FieldStateCovariance<T> inOrbitFrame = this.changeCovarianceFrame(orbit, orbit.getFrame());
            FieldStateCovariance<T> shiftedCovariance = inOrbitFrame.shiftedBy(field, orbit, dt);
            return shiftedCovariance.changeCovarianceFrame((FieldOrbit<T>)shifted, this.frame);
        }
        FieldStateCovariance<T> inOrbitFrame = this.changeCovarianceFrame(orbit, orbit.getFrame());
        FieldStateCovariance<T> shiftedCovariance = inOrbitFrame.shiftedBy(field, orbit, dt);
        return shiftedCovariance.changeCovarianceFrame((FieldOrbit<T>)shifted, this.lof);
    }

    public StateCovariance toStateCovariance() {
        CalculusFieldElement[][] data = (CalculusFieldElement[][])this.orbitalCovariance.getData();
        int rowDim = data.length;
        int columnDim = data.length;
        double[][] realData = new double[rowDim][columnDim];
        for (int i = 0; i < rowDim; ++i) {
            for (int j = 0; j < columnDim; ++j) {
                realData[i][j] = data[i][j].getReal();
            }
        }
        BlockRealMatrix realMatrix = new BlockRealMatrix(realData);
        AbsoluteDate realDate = this.epoch.toAbsoluteDate();
        if (this.frame == null) {
            return new StateCovariance((RealMatrix)realMatrix, realDate, this.lof);
        }
        return new StateCovariance((RealMatrix)realMatrix, realDate, this.frame, this.orbitType, this.angleType);
    }

    private FieldStateCovariance<T> changeTypeAndCreate(FieldOrbit<T> orbit, FieldAbsoluteDate<T> date, Frame covFrame, OrbitType inOrbitType, PositionAngleType inAngleType, OrbitType outOrbitType, PositionAngleType outAngleType, FieldMatrix<T> inputCov) {
        if (StateCovariance.inputAndOutputOrbitTypesAreCartesian(inOrbitType, outOrbitType) || StateCovariance.inputAndOutputAreIdentical(inOrbitType, inAngleType, outOrbitType, outAngleType)) {
            return new FieldStateCovariance<T>(inputCov, date, covFrame, inOrbitType, inAngleType);
        }
        Field<T> field = date.getField();
        CalculusFieldElement[][] aOC = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)6, (int)6);
        FieldOrbit<T> orbitInOutputType = outOrbitType.convertType(orbit);
        orbitInOutputType.getJacobianWrtCartesian(outAngleType, aOC);
        Array2DRowFieldMatrix dOdC = new Array2DRowFieldMatrix((FieldElement[][])aOC, false);
        CalculusFieldElement[][] aCI = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)6, (int)6);
        FieldOrbit<T> orbitInInputType = inOrbitType.convertType(orbit);
        orbitInInputType.getJacobianWrtParameters(inAngleType, aCI);
        Array2DRowFieldMatrix dCdI = new Array2DRowFieldMatrix((FieldElement[][])aCI, false);
        FieldMatrix dOdI = dOdC.multiply((FieldMatrix)dCdI);
        FieldMatrix outputCov = dOdI.multiply(inputCov.multiplyTransposed(dOdI));
        return new FieldStateCovariance<T>(outputCov, date, covFrame, outOrbitType, outAngleType);
    }

    private FieldStateCovariance<T> changeFrameAndCreate(FieldOrbit<T> orbit, FieldAbsoluteDate<T> date, LOF lofIn, LOF lofOut, FieldMatrix<T> inputCartesianCov) {
        FieldMatrix<T> jacobianFromLofInToLofOut = this.getJacobian(LOF.transformFromLOFInToLOFOut(lofIn, lofOut, date, orbit.getPVCoordinates()));
        FieldMatrix cartesianCovarianceOut = jacobianFromLofInToLofOut.multiply(inputCartesianCov.multiplyTransposed(jacobianFromLofInToLofOut));
        return new FieldStateCovariance<T>(cartesianCovarianceOut, date, lofOut);
    }

    private FieldStateCovariance<T> changeFrameAndCreate(FieldOrbit<T> orbit, FieldAbsoluteDate<T> date, Frame frameIn, LOF lofOut, FieldMatrix<T> inputCov, OrbitType covOrbitType, PositionAngleType covAngleType) {
        if (frameIn.isPseudoInertial()) {
            FieldMatrix<T> cartesianCovarianceIn = this.changeTypeAndCreate(orbit, date, frameIn, covOrbitType, covAngleType, OrbitType.CARTESIAN, PositionAngleType.MEAN, inputCov).getMatrix();
            FieldMatrix<T> jacobianFromFrameInToLofOut = this.getJacobian(lofOut.transformFromInertial(date, orbit.getPVCoordinates(frameIn)));
            FieldMatrix cartesianCovarianceOut = jacobianFromFrameInToLofOut.multiply(cartesianCovarianceIn.multiplyTransposed(jacobianFromFrameInToLofOut));
            return new FieldStateCovariance<T>(cartesianCovarianceOut, date, lofOut);
        }
        Frame orbitInertialFrame = orbit.getFrame();
        FieldMatrix<T> cartesianCovarianceInOrbitFrame = this.changeFrameAndCreate(orbit, date, frameIn, orbitInertialFrame, inputCov, OrbitType.CARTESIAN, PositionAngleType.MEAN).getMatrix();
        return this.changeFrameAndCreate(orbit, date, orbitInertialFrame, lofOut, cartesianCovarianceInOrbitFrame, OrbitType.CARTESIAN, PositionAngleType.MEAN);
    }

    private FieldStateCovariance<T> changeFrameAndCreate(FieldOrbit<T> orbit, FieldAbsoluteDate<T> date, LOF lofIn, Frame frameOut, FieldMatrix<T> inputCartesianCov) {
        if (frameOut.isPseudoInertial()) {
            FieldMatrix<T> jacobianFromLofInToFrameOut = this.getJacobian(lofIn.transformFromInertial(date, orbit.getPVCoordinates(frameOut)).getInverse());
            FieldMatrix transformedCovariance = jacobianFromLofInToFrameOut.multiply(inputCartesianCov.multiplyTransposed(jacobianFromLofInToFrameOut));
            return new FieldStateCovariance<T>(transformedCovariance, date, frameOut, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
        }
        FieldMatrix<T> jacobianFromLofInToOrbitFrame = this.getJacobian(lofIn.transformFromInertial(date, orbit.getPVCoordinates()).getInverse());
        FieldMatrix cartesianCovarianceInOrbitFrame = jacobianFromLofInToOrbitFrame.multiply(inputCartesianCov.multiplyTransposed(jacobianFromLofInToOrbitFrame));
        return this.changeFrameAndCreate(orbit, date, orbit.getFrame(), frameOut, cartesianCovarianceInOrbitFrame, OrbitType.CARTESIAN, PositionAngleType.MEAN);
    }

    private FieldStateCovariance<T> changeFrameAndCreate(FieldOrbit<T> orbit, FieldAbsoluteDate<T> date, Frame frameIn, Frame frameOut, FieldMatrix<T> inputCov, OrbitType covOrbitType, PositionAngleType covAngleType) {
        FieldKinematicTransform<T> inToOut = frameIn.getKinematicTransformTo(frameOut, orbit.getDate());
        FieldMatrix<T> j = this.getJacobian(inToOut);
        if (frameIn.isPseudoInertial()) {
            FieldMatrix<T> cartesianCovarianceIn = this.changeTypeAndCreate(orbit, date, frameIn, covOrbitType, covAngleType, OrbitType.CARTESIAN, PositionAngleType.MEAN, inputCov).getMatrix();
            FieldMatrix cartesianCovarianceOut = j.multiply(cartesianCovarianceIn.multiplyTransposed(j));
            if (frameOut.isPseudoInertial()) {
                return this.changeTypeAndCreate(orbit, date, frameOut, OrbitType.CARTESIAN, PositionAngleType.MEAN, covOrbitType, covAngleType, cartesianCovarianceOut);
            }
            return new FieldStateCovariance<T>(cartesianCovarianceOut, date, frameOut, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
        }
        FieldMatrix covInFrameOut = j.multiply(inputCov.multiplyTransposed(j));
        return new FieldStateCovariance<T>(covInFrameOut, date, frameOut, OrbitType.CARTESIAN, DEFAULT_POSITION_ANGLE);
    }

    private FieldMatrix<T> getJacobian(FieldKinematicTransform<T> transform) {
        return MatrixUtils.createFieldMatrix((FieldElement[][])transform.getPVJacobian());
    }

    private FieldMatrix<T> getStm(Field<T> field, FieldOrbit<T> initialOrbit, T dt) {
        FieldMatrix stm = MatrixUtils.createFieldIdentityMatrix(field, (int)6);
        T mu = initialOrbit.getMu();
        T sma = initialOrbit.getA();
        CalculusFieldElement contribution = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mu.divide((FieldElement)((CalculusFieldElement)sma.pow(5)))).sqrt()).multiply(dt)).multiply(-1.5);
        stm.setEntry(5, 0, (FieldElement)contribution);
        return stm;
    }
}

