/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.Pair;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.FieldAttitudeInterpolator;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.FieldOrbitHermiteInterpolator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.SpacecraftStateInterpolator;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolator;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.TimeStampedField;
import org.orekit.time.TimeStampedFieldHermiteInterpolator;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldAbsolutePVCoordinates;
import org.orekit.utils.FieldAbsolutePVCoordinatesHermiteInterpolator;
import org.orekit.utils.FieldArrayDictionary;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldAngularCoordinatesHermiteInterpolator;

public class FieldSpacecraftStateInterpolator<KK extends CalculusFieldElement<KK>>
extends AbstractFieldTimeInterpolator<FieldSpacecraftState<KK>, KK> {
    private final Frame outputFrame;
    private final FieldTimeInterpolator<FieldOrbit<KK>, KK> orbitInterpolator;
    private final FieldTimeInterpolator<FieldAbsolutePVCoordinates<KK>, KK> absPVAInterpolator;
    private final FieldTimeInterpolator<TimeStampedField<KK>, KK> massInterpolator;
    private final FieldTimeInterpolator<FieldAttitude<KK>, KK> attitudeInterpolator;
    private final FieldTimeInterpolator<TimeStampedField<KK>, KK> additionalStateInterpolator;

    public FieldSpacecraftStateInterpolator(Frame outputFrame) {
        this(2, outputFrame);
    }

    public FieldSpacecraftStateInterpolator(int interpolationPoints, Frame outputFrame) {
        this(interpolationPoints, outputFrame, outputFrame);
    }

    public FieldSpacecraftStateInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame) {
        this(interpolationPoints, extrapolationThreshold, outputFrame, outputFrame);
    }

    public FieldSpacecraftStateInterpolator(int interpolationPoints, Frame outputFrame, Frame attitudeReferenceFrame) {
        this(interpolationPoints, 0.001, outputFrame, attitudeReferenceFrame);
    }

    public FieldSpacecraftStateInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame, Frame attitudeReferenceFrame) {
        this(interpolationPoints, extrapolationThreshold, outputFrame, attitudeReferenceFrame, CartesianDerivativesFilter.USE_PVA, AngularDerivativesFilter.USE_RR);
    }

    public FieldSpacecraftStateInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame, Frame attitudeReferenceFrame, CartesianDerivativesFilter pvaFilter, AngularDerivativesFilter angularFilter) {
        this(interpolationPoints, extrapolationThreshold, outputFrame, new FieldOrbitHermiteInterpolator(interpolationPoints, extrapolationThreshold, outputFrame, pvaFilter), new FieldAbsolutePVCoordinatesHermiteInterpolator(interpolationPoints, extrapolationThreshold, outputFrame, pvaFilter), new TimeStampedFieldHermiteInterpolator(interpolationPoints, extrapolationThreshold), new FieldAttitudeInterpolator(attitudeReferenceFrame, new TimeStampedFieldAngularCoordinatesHermiteInterpolator(interpolationPoints, extrapolationThreshold, angularFilter)), new TimeStampedFieldHermiteInterpolator(interpolationPoints, extrapolationThreshold));
    }

    @Deprecated
    public FieldSpacecraftStateInterpolator(Frame outputFrame, FieldTimeInterpolator<FieldOrbit<KK>, KK> orbitInterpolator, FieldTimeInterpolator<FieldAbsolutePVCoordinates<KK>, KK> absPVAInterpolator, FieldTimeInterpolator<TimeStampedField<KK>, KK> massInterpolator, FieldTimeInterpolator<FieldAttitude<KK>, KK> attitudeInterpolator, FieldTimeInterpolator<TimeStampedField<KK>, KK> additionalStateInterpolator) {
        super(2, 0.001);
        this.checkAtLeastOneInterpolator(orbitInterpolator, absPVAInterpolator);
        this.outputFrame = outputFrame;
        this.orbitInterpolator = orbitInterpolator;
        this.absPVAInterpolator = absPVAInterpolator;
        this.massInterpolator = massInterpolator;
        this.attitudeInterpolator = attitudeInterpolator;
        this.additionalStateInterpolator = additionalStateInterpolator;
    }

    public FieldSpacecraftStateInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputFrame, FieldTimeInterpolator<FieldOrbit<KK>, KK> orbitInterpolator, FieldTimeInterpolator<FieldAbsolutePVCoordinates<KK>, KK> absPVAInterpolator, FieldTimeInterpolator<TimeStampedField<KK>, KK> massInterpolator, FieldTimeInterpolator<FieldAttitude<KK>, KK> attitudeInterpolator, FieldTimeInterpolator<TimeStampedField<KK>, KK> additionalStateInterpolator) {
        super(interpolationPoints, extrapolationThreshold);
        this.checkAtLeastOneInterpolator(orbitInterpolator, absPVAInterpolator);
        this.outputFrame = outputFrame;
        this.orbitInterpolator = orbitInterpolator;
        this.absPVAInterpolator = absPVAInterpolator;
        this.massInterpolator = massInterpolator;
        this.attitudeInterpolator = attitudeInterpolator;
        this.additionalStateInterpolator = additionalStateInterpolator;
    }

    @Override
    public FieldSpacecraftState<KK> interpolate(FieldAbsoluteDate<KK> interpolationDate, Collection<FieldSpacecraftState<KK>> sample) {
        ArrayList<FieldSpacecraftState<KK>> sampleList = new ArrayList<FieldSpacecraftState<KK>>(sample);
        List<SpacecraftState> nonFieldSampleList = sampleList.stream().map(FieldSpacecraftState::toSpacecraftState).collect(Collectors.toList());
        if (!sampleList.isEmpty()) {
            SpacecraftStateInterpolator.checkStatesDefinitionsConsistency(nonFieldSampleList);
            SpacecraftStateInterpolator.checkSampleAndInterpolatorConsistency(nonFieldSampleList, this.orbitInterpolator != null, this.absPVAInterpolator != null);
        }
        return super.interpolate(interpolationDate, sample);
    }

    @Override
    public List<FieldTimeInterpolator<? extends FieldTimeStamped<KK>, KK>> getSubInterpolators() {
        ArrayList<FieldTimeInterpolator<? extends FieldTimeStamped<KK>, KK>> subInterpolators = new ArrayList<FieldTimeInterpolator<? extends FieldTimeStamped<KK>, KK>>();
        this.addOptionalSubInterpolatorIfDefined(this.orbitInterpolator, subInterpolators);
        this.addOptionalSubInterpolatorIfDefined(this.absPVAInterpolator, subInterpolators);
        this.addOptionalSubInterpolatorIfDefined(this.massInterpolator, subInterpolators);
        this.addOptionalSubInterpolatorIfDefined(this.attitudeInterpolator, subInterpolators);
        this.addOptionalSubInterpolatorIfDefined(this.additionalStateInterpolator, subInterpolators);
        return subInterpolators;
    }

    @Override
    protected FieldSpacecraftState<KK> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        FieldArrayDictionary interpolatedAdditionalDot;
        FieldArrayDictionary interpolatedAdditional;
        FieldAbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        FieldSpacecraftState earliestState = (FieldSpacecraftState)interpolationData.getNeighborList().get(0);
        boolean areOrbitDefined = earliestState.isOrbitDefined();
        ArrayList<FieldAttitude<KK>> attitudes = new ArrayList<FieldAttitude<KK>>();
        ArrayList masses = new ArrayList();
        List<FieldArrayDictionary.Entry> additionalEntries = earliestState.getAdditionalStatesValues().getData();
        Map<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>> additionalSample = this.createAdditionalStateSample(additionalEntries);
        List<FieldArrayDictionary.Entry> additionalDotEntries = earliestState.getAdditionalStatesDerivatives().getData();
        Map<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>> additionalDotSample = this.createAdditionalStateSample(additionalDotEntries);
        List samples = interpolationData.getNeighborList();
        ArrayList orbitSample = new ArrayList();
        ArrayList absPVASample = new ArrayList();
        for (FieldSpacecraftState state : samples) {
            FieldAbsoluteDate currentDate = state.getDate();
            if (state.isOrbitDefined()) {
                orbitSample.add(state.getOrbit());
            } else {
                absPVASample.add(state.getAbsPVA());
            }
            if (this.massInterpolator != null) {
                masses.add(new TimeStampedField(state.getMass(), state.getDate()));
            }
            if (this.attitudeInterpolator != null) {
                attitudes.add(state.getAttitude());
            }
            if (this.additionalStateInterpolator == null) continue;
            for (Map.Entry<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>> entry : additionalSample.entrySet()) {
                entry.getValue().add(new Pair(currentDate, (Object)state.getAdditionalState(entry.getKey())));
            }
            for (Map.Entry<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>> entry : additionalDotSample.entrySet()) {
                entry.getValue().add(new Pair(currentDate, (Object)state.getAdditionalStateDerivative(entry.getKey())));
            }
        }
        Object one = interpolationData.getOne();
        Object interpolatedMass = this.massInterpolator != null ? this.massInterpolator.interpolate(interpolationDate, masses).getValue() : (CalculusFieldElement)one.newInstance(1000.0);
        if (this.additionalStateInterpolator != null) {
            interpolatedAdditional = this.interpolateAdditionalState(interpolationDate, additionalSample);
            interpolatedAdditionalDot = this.interpolateAdditionalState(interpolationDate, additionalDotSample);
        } else {
            interpolatedAdditional = null;
            interpolatedAdditionalDot = null;
        }
        if (areOrbitDefined && this.orbitInterpolator != null) {
            FieldOrbit<KK> interpolatedOrbit = this.orbitInterpolator.interpolate(interpolationDate, orbitSample);
            FieldAttitude interpolatedAttitude = this.interpolateAttitude(interpolationDate, attitudes, interpolatedOrbit);
            return new FieldSpacecraftState<CalculusFieldElement>((FieldOrbit<CalculusFieldElement>)interpolatedOrbit, (FieldAttitude<CalculusFieldElement>)interpolatedAttitude, (CalculusFieldElement)interpolatedMass, (FieldArrayDictionary<CalculusFieldElement>)interpolatedAdditional, (FieldArrayDictionary<CalculusFieldElement>)interpolatedAdditionalDot);
        }
        if (!areOrbitDefined && this.absPVAInterpolator != null) {
            FieldAbsolutePVCoordinates<KK> interpolatedAbsPva = this.absPVAInterpolator.interpolate(interpolationDate, absPVASample);
            FieldAttitude interpolatedAttitude = this.interpolateAttitude(interpolationDate, attitudes, interpolatedAbsPva);
            return new FieldSpacecraftState<CalculusFieldElement>((FieldAbsolutePVCoordinates<CalculusFieldElement>)interpolatedAbsPva, (FieldAttitude<CalculusFieldElement>)interpolatedAttitude, (CalculusFieldElement)interpolatedMass, (FieldArrayDictionary<CalculusFieldElement>)interpolatedAdditional, (FieldArrayDictionary<CalculusFieldElement>)interpolatedAdditionalDot);
        }
        throw new OrekitInternalError(null);
    }

    public Frame getOutputFrame() {
        return this.outputFrame;
    }

    public Optional<FieldTimeInterpolator<FieldOrbit<KK>, KK>> getOrbitInterpolator() {
        return Optional.ofNullable(this.orbitInterpolator);
    }

    public Optional<FieldTimeInterpolator<FieldAbsolutePVCoordinates<KK>, KK>> getAbsPVAInterpolator() {
        return Optional.ofNullable(this.absPVAInterpolator);
    }

    public Optional<FieldTimeInterpolator<TimeStampedField<KK>, KK>> getMassInterpolator() {
        return Optional.ofNullable(this.massInterpolator);
    }

    public Optional<FieldTimeInterpolator<FieldAttitude<KK>, KK>> getAttitudeInterpolator() {
        return Optional.ofNullable(this.attitudeInterpolator);
    }

    public Optional<FieldTimeInterpolator<TimeStampedField<KK>, KK>> getAdditionalStateInterpolator() {
        return Optional.ofNullable(this.additionalStateInterpolator);
    }

    private void checkAtLeastOneInterpolator(FieldTimeInterpolator<FieldOrbit<KK>, KK> orbitInterpolatorToCheck, FieldTimeInterpolator<FieldAbsolutePVCoordinates<KK>, KK> absPVAInterpolatorToCheck) {
        if (orbitInterpolatorToCheck == null && absPVAInterpolatorToCheck == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NO_INTERPOLATOR_FOR_STATE_DEFINITION, new Object[0]);
        }
    }

    private Map<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>> createAdditionalStateSample(List<FieldArrayDictionary.Entry> additionalEntries) {
        HashMap<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>> additionalSamples = new HashMap<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>>(additionalEntries.size());
        for (FieldArrayDictionary.Entry entry : additionalEntries) {
            additionalSamples.put(entry.getKey(), new ArrayList());
        }
        return additionalSamples;
    }

    private FieldArrayDictionary<KK> interpolateAdditionalState(FieldAbsoluteDate<KK> interpolationDate, Map<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>> additionalSamples) {
        FieldArrayDictionary<KK> interpolatedAdditional;
        Field<KK> field = interpolationDate.getField();
        if (additionalSamples.isEmpty()) {
            interpolatedAdditional = null;
        } else {
            interpolatedAdditional = new FieldArrayDictionary<KK>(field, additionalSamples.size());
            for (Map.Entry<String, List<Pair<FieldAbsoluteDate<KK>, KK[]>>> entry : additionalSamples.entrySet()) {
                List<Pair<FieldAbsoluteDate<KK>, KK[]>> currentAdditionalSamples = entry.getValue();
                int nbOfValues = ((CalculusFieldElement[])currentAdditionalSamples.get(0).getValue()).length;
                CalculusFieldElement[] currentInterpolatedAdditional = (CalculusFieldElement[])MathArrays.buildArray(field, (int)nbOfValues);
                for (int i = 0; i < nbOfValues; ++i) {
                    int currentIndex = i;
                    ArrayList currentValueSample = new ArrayList();
                    currentAdditionalSamples.forEach(currentSamples -> currentValueSample.add(new TimeStampedField<CalculusFieldElement>(((CalculusFieldElement[])currentSamples.getValue())[currentIndex], (FieldAbsoluteDate)currentSamples.getFirst())));
                    currentInterpolatedAdditional[i] = this.additionalStateInterpolator.interpolate(interpolationDate, currentValueSample).getValue();
                }
                interpolatedAdditional.put(entry.getKey(), currentInterpolatedAdditional);
            }
        }
        return interpolatedAdditional;
    }

    private FieldAttitude<KK> interpolateAttitude(FieldAbsoluteDate<KK> interpolationDate, List<FieldAttitude<KK>> attitudes, FieldPVCoordinatesProvider<KK> pvProvider) {
        if (attitudes.isEmpty()) {
            FrameAlignedProvider attitudeProvider = new FrameAlignedProvider(this.outputFrame);
            return attitudeProvider.getAttitude(pvProvider, interpolationDate, this.outputFrame);
        }
        return this.attitudeInterpolator.interpolate(interpolationDate, attitudes);
    }
}

