/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.FieldAbsolutePVCoordinates;
import org.orekit.utils.FieldArrayDictionary;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FieldSpacecraftState<T extends CalculusFieldElement<T>>
implements FieldTimeStamped<T>,
FieldTimeShiftable<FieldSpacecraftState<T>, T> {
    private static final double DEFAULT_MASS = 1000.0;
    private static final double DATE_INCONSISTENCY_THRESHOLD = 1.0E-7;
    private final FieldOrbit<T> orbit;
    private final FieldAbsolutePVCoordinates<T> absPva;
    private final FieldAttitude<T> attitude;
    private final T mass;
    private final FieldArrayDictionary<T> additional;
    private final FieldArrayDictionary<T> additionalDot;

    public FieldSpacecraftState(FieldOrbit<T> orbit) {
        this(orbit, SpacecraftState.getDefaultAttitudeProvider(orbit.getFrame()).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), (CalculusFieldElement)((CalculusFieldElement)orbit.getA().getField().getZero()).newInstance(1000.0), (FieldArrayDictionary)null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude) throws IllegalArgumentException {
        this(orbit, attitude, (CalculusFieldElement)((CalculusFieldElement)orbit.getA().getField().getZero()).newInstance(1000.0), (FieldArrayDictionary)null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, T mass) {
        this(orbit, SpacecraftState.getDefaultAttitudeProvider(orbit.getFrame()).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, (FieldArrayDictionary)null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass) throws IllegalArgumentException {
        this(orbit, attitude, mass, (FieldArrayDictionary)null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldArrayDictionary<T> additional) {
        this(orbit, SpacecraftState.getDefaultAttitudeProvider(orbit.getFrame()).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), (CalculusFieldElement)((CalculusFieldElement)orbit.getA().getField().getZero()).newInstance(1000.0), additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, FieldArrayDictionary<T> additional) throws IllegalArgumentException {
        this(orbit, attitude, (CalculusFieldElement)((CalculusFieldElement)orbit.getA().getField().getZero()).newInstance(1000.0), additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, T mass, FieldArrayDictionary<T> additional) {
        this(orbit, SpacecraftState.getDefaultAttitudeProvider(orbit.getFrame()).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass, FieldArrayDictionary<T> additional) {
        this(orbit, attitude, mass, additional, null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass, FieldArrayDictionary<T> additional, FieldArrayDictionary<T> additionalDot) throws IllegalArgumentException {
        this.checkConsistency(orbit, attitude);
        this.orbit = orbit;
        this.attitude = attitude;
        this.mass = mass;
        this.absPva = null;
        this.additional = additional == null ? new FieldArrayDictionary<T>(orbit.getDate().getField()) : new FieldArrayDictionary<T>(additional);
        this.additionalDot = additionalDot == null ? new FieldArrayDictionary<T>(orbit.getDate().getField()) : new FieldArrayDictionary<T>(additionalDot);
    }

    public FieldSpacecraftState(Field<T> field, SpacecraftState state) {
        if (state.isOrbitDefined()) {
            Orbit nonFieldOrbit = state.getOrbit();
            this.orbit = nonFieldOrbit.getType().convertToFieldOrbit(field, nonFieldOrbit);
            this.absPva = null;
        } else {
            TimeStampedPVCoordinates tspva = state.getPVCoordinates();
            FieldVector3D position = new FieldVector3D(field, tspva.getPosition());
            FieldVector3D velocity = new FieldVector3D(field, tspva.getVelocity());
            FieldVector3D acceleration = new FieldVector3D(field, tspva.getAcceleration());
            FieldPVCoordinates pva = new FieldPVCoordinates(position, velocity, acceleration);
            FieldAbsoluteDate<T> dateF = new FieldAbsoluteDate<T>(field, state.getDate());
            this.orbit = null;
            this.absPva = new FieldAbsolutePVCoordinates<T>(state.getFrame(), dateF, pva);
        }
        this.attitude = new FieldAttitude<T>(field, state.getAttitude());
        this.mass = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(state.getMass());
        DoubleArrayDictionary additionalD = state.getAdditionalStatesValues();
        if (additionalD.size() == 0) {
            this.additional = new FieldArrayDictionary<T>(field);
        } else {
            this.additional = new FieldArrayDictionary<T>(field, additionalD.size());
            for (DoubleArrayDictionary.Entry entry : additionalD.getData()) {
                this.additional.put(entry.getKey(), entry.getValue());
            }
        }
        DoubleArrayDictionary additionalDotD = state.getAdditionalStatesDerivatives();
        if (additionalDotD.size() == 0) {
            this.additionalDot = new FieldArrayDictionary<T>(field);
        } else {
            this.additionalDot = new FieldArrayDictionary<T>(field, additionalDotD.size());
            for (DoubleArrayDictionary.Entry entry : additionalDotD.getData()) {
                this.additionalDot.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva) {
        this(absPva, SpacecraftState.getDefaultAttitudeProvider(absPva.getFrame()).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), (CalculusFieldElement)((CalculusFieldElement)absPva.getDate().getField().getZero()).newInstance(1000.0), (FieldArrayDictionary)null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude) throws IllegalArgumentException {
        this(absPva, attitude, (CalculusFieldElement)((CalculusFieldElement)absPva.getDate().getField().getZero()).newInstance(1000.0), (FieldArrayDictionary)null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, T mass) {
        this(absPva, SpacecraftState.getDefaultAttitudeProvider(absPva.getFrame()).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), mass, (FieldArrayDictionary)null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude, T mass) throws IllegalArgumentException {
        this(absPva, attitude, mass, (FieldArrayDictionary)null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldArrayDictionary<T> additional) {
        this(absPva, SpacecraftState.getDefaultAttitudeProvider(absPva.getFrame()).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), (CalculusFieldElement)((CalculusFieldElement)absPva.getDate().getField().getZero()).newInstance(1000.0), additional);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude, FieldArrayDictionary<T> additional) throws IllegalArgumentException {
        this(absPva, attitude, (CalculusFieldElement)((CalculusFieldElement)absPva.getDate().getField().getZero()).newInstance(1000.0), additional);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, T mass, FieldArrayDictionary<T> additional) {
        this(absPva, SpacecraftState.getDefaultAttitudeProvider(absPva.getFrame()).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), mass, additional);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude, T mass, FieldArrayDictionary<T> additional) {
        this(absPva, attitude, mass, additional, null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude, T mass, FieldArrayDictionary<T> additional, FieldArrayDictionary<T> additionalDot) throws IllegalArgumentException {
        FieldSpacecraftState.checkConsistency(absPva, attitude);
        this.orbit = null;
        this.absPva = absPva;
        this.attitude = attitude;
        this.mass = mass;
        this.additional = additional == null ? new FieldArrayDictionary(absPva.getDate().getField()) : new FieldArrayDictionary<T>(additional);
        this.additionalDot = additionalDot == null ? new FieldArrayDictionary(absPva.getDate().getField()) : new FieldArrayDictionary<T>(additionalDot);
    }

    @SafeVarargs
    public final FieldSpacecraftState<T> addAdditionalState(String name, T ... value) {
        FieldArrayDictionary<T> newDict = new FieldArrayDictionary<T>(this.additional);
        newDict.put(name, (CalculusFieldElement[])value.clone());
        if (this.isOrbitDefined()) {
            return new FieldSpacecraftState<T>(this.orbit, this.attitude, this.mass, newDict, this.additionalDot);
        }
        return new FieldSpacecraftState<T>(this.absPva, this.attitude, this.mass, newDict, this.additionalDot);
    }

    @SafeVarargs
    public final FieldSpacecraftState<T> addAdditionalStateDerivative(String name, T ... value) {
        FieldArrayDictionary<T> newDict = new FieldArrayDictionary<T>(this.additionalDot);
        newDict.put(name, (CalculusFieldElement[])value.clone());
        if (this.isOrbitDefined()) {
            return new FieldSpacecraftState<T>(this.orbit, this.attitude, this.mass, this.additional, newDict);
        }
        return new FieldSpacecraftState<T>(this.absPva, this.attitude, this.mass, this.additional, newDict);
    }

    private void checkConsistency(FieldOrbit<T> orbitN, FieldAttitude<T> attitudeN) throws IllegalArgumentException {
        if (((CalculusFieldElement)orbitN.getDate().durationFrom(attitudeN.getDate()).abs()).getReal() > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, orbitN.getDate(), attitudeN.getDate());
        }
        if (orbitN.getFrame() != attitudeN.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, orbitN.getFrame().getName(), attitudeN.getReferenceFrame().getName());
        }
    }

    public boolean isOrbitDefined() {
        return this.orbit != null;
    }

    private static <T extends CalculusFieldElement<T>> void checkConsistency(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude) throws IllegalArgumentException {
        if (FastMath.abs(absPva.getDate().durationFrom(attitude.getDate())).getReal() > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, absPva.getDate(), attitude.getDate());
        }
        if (absPva.getFrame() != attitude.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, absPva.getFrame().getName(), attitude.getReferenceFrame().getName());
        }
    }

    @Override
    public FieldSpacecraftState<T> shiftedBy(double dt) {
        if (this.isOrbitDefined()) {
            return new FieldSpacecraftState<double>((FieldOrbit)this.orbit.shiftedBy(dt), (FieldAttitude<double>)this.attitude.shiftedBy(dt), (double)this.mass, this.shiftAdditional((T)dt), (FieldArrayDictionary<double>)this.additionalDot);
        }
        return new FieldSpacecraftState<double>((FieldAbsolutePVCoordinates<double>)this.absPva.shiftedBy(dt), (FieldAttitude<double>)this.attitude.shiftedBy(dt), (double)this.mass, this.shiftAdditional((T)dt), (FieldArrayDictionary<double>)this.additionalDot);
    }

    @Override
    public FieldSpacecraftState<T> shiftedBy(T dt) {
        if (this.isOrbitDefined()) {
            return new FieldSpacecraftState<T>(this.orbit.shiftedBy((CalculusFieldElement)dt), this.attitude.shiftedBy((CalculusFieldElement)dt), this.mass, this.shiftAdditional(dt), this.additionalDot);
        }
        return new FieldSpacecraftState<T>(this.absPva.shiftedBy((CalculusFieldElement)dt), this.attitude.shiftedBy((CalculusFieldElement)dt), this.mass, this.shiftAdditional(dt), this.additionalDot);
    }

    private FieldArrayDictionary<T> shiftAdditional(double dt) {
        if (this.additionalDot.size() == 0) {
            return this.additional;
        }
        FieldArrayDictionary<T> shifted = new FieldArrayDictionary<T>(this.additional);
        for (FieldArrayDictionary.Entry dotEntry : this.additionalDot.getData()) {
            FieldArrayDictionary.Entry entry = shifted.getEntry(dotEntry.getKey());
            if (entry == null) continue;
            entry.scaledIncrement(dt, dotEntry);
        }
        return shifted;
    }

    private FieldArrayDictionary<T> shiftAdditional(T dt) {
        if (this.additionalDot.size() == 0) {
            return this.additional;
        }
        FieldArrayDictionary<T> shifted = new FieldArrayDictionary<T>(this.additional);
        for (FieldArrayDictionary.Entry dotEntry : this.additionalDot.getData()) {
            FieldArrayDictionary.Entry entry = shifted.getEntry(dotEntry.getKey());
            if (entry == null) continue;
            entry.scaledIncrement(dt, dotEntry);
        }
        return shifted;
    }

    public FieldAbsolutePVCoordinates<T> getAbsPVA() throws OrekitIllegalStateException {
        if (this.isOrbitDefined()) {
            throw new OrekitIllegalStateException(OrekitMessages.UNDEFINED_ABSOLUTE_PVCOORDINATES, new Object[0]);
        }
        return this.absPva;
    }

    public FieldOrbit<T> getOrbit() throws OrekitIllegalStateException {
        if (this.orbit == null) {
            throw new OrekitIllegalStateException(OrekitMessages.UNDEFINED_ORBIT, new Object[0]);
        }
        return this.orbit;
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.isOrbitDefined() ? this.orbit.getDate() : this.absPva.getDate();
    }

    public Frame getFrame() {
        return this.isOrbitDefined() ? this.orbit.getFrame() : this.absPva.getFrame();
    }

    public boolean hasAdditionalState(String name) {
        return this.additional.getEntry(name) != null;
    }

    public boolean hasAdditionalStateDerivative(String name) {
        return this.additionalDot.getEntry(name) != null;
    }

    public void ensureCompatibleAdditionalStates(FieldSpacecraftState<T> state) throws MathIllegalArgumentException {
        CalculusFieldElement[] other;
        for (FieldArrayDictionary.Entry entry : this.additional.getData()) {
            other = state.additional.get(entry.getKey());
            if (other == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
            if (other.length == entry.getValue().length) continue;
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{other.length, entry.getValue().length});
        }
        for (FieldArrayDictionary.Entry entry : this.additionalDot.getData()) {
            other = state.additionalDot.get(entry.getKey());
            if (other == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
            if (other.length == entry.getValue().length) continue;
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{other.length, entry.getValue().length});
        }
        if (state.additional.size() > this.additional.size()) {
            for (FieldArrayDictionary.Entry entry : state.additional.getData()) {
                if (this.additional.getEntry(entry.getKey()) != null) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
        }
        if (state.additionalDot.size() > this.additionalDot.size()) {
            for (FieldArrayDictionary.Entry entry : state.additionalDot.getData()) {
                if (this.additionalDot.getEntry(entry.getKey()) != null) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
        }
    }

    public T[] getAdditionalState(String name) {
        FieldArrayDictionary.Entry entry = this.additional.getEntry(name);
        if (entry == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
        }
        return entry.getValue();
    }

    public T[] getAdditionalStateDerivative(String name) {
        FieldArrayDictionary.Entry entry = this.additionalDot.getEntry(name);
        if (entry == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
        }
        return entry.getValue();
    }

    public FieldArrayDictionary<T> getAdditionalStatesValues() {
        return this.additional.unmodifiableView();
    }

    public FieldArrayDictionary<T> getAdditionalStatesDerivatives() {
        return this.additionalDot.unmodifiableView();
    }

    public FieldTransform<T> toTransform() {
        TimeStampedFieldPVCoordinates<T> pv = this.getPVCoordinates();
        return new FieldTransform<T>(pv.getDate(), new FieldTransform<T>(pv.getDate(), pv.negate()), new FieldTransform<T>(pv.getDate(), this.attitude.getOrientation()));
    }

    public FieldStaticTransform<T> toStaticTransform() {
        return FieldStaticTransform.of(this.getDate(), this.getPosition().negate(), this.attitude.getRotation());
    }

    public T getMu() {
        return (T)(this.isOrbitDefined() ? this.orbit.getMu() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getKeplerianPeriod() {
        return (T)(this.isOrbitDefined() ? this.orbit.getKeplerianPeriod() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getKeplerianMeanMotion() {
        return (T)(this.isOrbitDefined() ? this.orbit.getKeplerianMeanMotion() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getA() {
        return (T)(this.isOrbitDefined() ? this.orbit.getA() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getEquinoctialEx() {
        return (T)(this.isOrbitDefined() ? this.orbit.getEquinoctialEx() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getEquinoctialEy() {
        return (T)(this.isOrbitDefined() ? this.orbit.getEquinoctialEy() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getHx() {
        return (T)(this.isOrbitDefined() ? this.orbit.getHx() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getHy() {
        return (T)(this.isOrbitDefined() ? this.orbit.getHy() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getLv() {
        return (T)(this.isOrbitDefined() ? this.orbit.getLv() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getLE() {
        return (T)(this.isOrbitDefined() ? this.orbit.getLE() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getLM() {
        return (T)(this.isOrbitDefined() ? this.orbit.getLM() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getE() {
        return (T)(this.isOrbitDefined() ? this.orbit.getE() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getI() {
        return (T)(this.isOrbitDefined() ? this.orbit.getI() : (CalculusFieldElement)((CalculusFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public FieldVector3D<T> getPosition() {
        return this.isOrbitDefined() ? this.orbit.getPosition() : this.absPva.getPosition();
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates() {
        return this.isOrbitDefined() ? this.orbit.getPVCoordinates() : this.absPva.getPVCoordinates();
    }

    public FieldVector3D<T> getPosition(Frame outputFrame) {
        return this.isOrbitDefined() ? this.orbit.getPosition(outputFrame) : this.absPva.getPosition(outputFrame);
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(Frame outputFrame) {
        return this.isOrbitDefined() ? this.orbit.getPVCoordinates(outputFrame) : this.absPva.getPVCoordinates(outputFrame);
    }

    public FieldAttitude<T> getAttitude() {
        return this.attitude;
    }

    public T getMass() {
        return this.mass;
    }

    public SpacecraftState toSpacecraftState() {
        DoubleArrayDictionary dictionaryDot;
        DoubleArrayDictionary dictionary;
        if (this.additional.size() == 0) {
            dictionary = new DoubleArrayDictionary();
        } else {
            dictionary = new DoubleArrayDictionary(this.additional.size());
            for (FieldArrayDictionary.Entry entry : this.additional.getData()) {
                double[] array = new double[entry.getValue().length];
                for (int k = 0; k < array.length; ++k) {
                    array[k] = entry.getValue()[k].getReal();
                }
                dictionary.put(entry.getKey(), array);
            }
        }
        if (this.additionalDot.size() == 0) {
            dictionaryDot = new DoubleArrayDictionary();
        } else {
            dictionaryDot = new DoubleArrayDictionary(this.additionalDot.size());
            for (FieldArrayDictionary.Entry entry : this.additionalDot.getData()) {
                double[] array = new double[entry.getValue().length];
                for (int k = 0; k < array.length; ++k) {
                    array[k] = entry.getValue()[k].getReal();
                }
                dictionaryDot.put(entry.getKey(), array);
            }
        }
        if (this.isOrbitDefined()) {
            return new SpacecraftState(this.orbit.toOrbit(), this.attitude.toAttitude(), this.mass.getReal(), dictionary, dictionaryDot);
        }
        return new SpacecraftState(this.absPva.toAbsolutePVCoordinates(), this.attitude.toAttitude(), this.mass.getReal(), dictionary, dictionaryDot);
    }

    public String toString() {
        return "FieldSpacecraftState{orbit=" + this.orbit + ", attitude=" + this.attitude + ", mass=" + this.mass + ", additional=" + this.additional + ", additionalDot=" + this.additionalDot + '}';
    }
}

