/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.StateCovariance;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.time.TimeInterpolator;
import org.orekit.time.TimeStampedPair;

public abstract class AbstractStateCovarianceInterpolator
extends AbstractTimeInterpolator<TimeStampedPair<Orbit, StateCovariance>> {
    public static final PositionAngleType DEFAULT_POSITION_ANGLE = PositionAngleType.MEAN;
    public static final int COLUMN_DIM = 6;
    public static final int ROW_DIM = 6;
    private final Frame outFrame;
    private final LOFType outLOF;
    private final OrbitType outOrbitType;
    private final PositionAngleType outPositionAngleType;
    private final TimeInterpolator<Orbit> orbitInterpolator;

    public AbstractStateCovarianceInterpolator(int interpolationPoints, double extrapolationThreshold, TimeInterpolator<Orbit> orbitInterpolator, LOFType outLOF) {
        super(interpolationPoints, extrapolationThreshold);
        this.orbitInterpolator = orbitInterpolator;
        this.outLOF = outLOF;
        this.outFrame = null;
        this.outOrbitType = OrbitType.CARTESIAN;
        this.outPositionAngleType = DEFAULT_POSITION_ANGLE;
    }

    public AbstractStateCovarianceInterpolator(int interpolationPoints, double extrapolationThreshold, TimeInterpolator<Orbit> orbitInterpolator, Frame outFrame, OrbitType outOrbitType, PositionAngleType outPositionAngleType) {
        super(interpolationPoints, extrapolationThreshold);
        this.orbitInterpolator = orbitInterpolator;
        this.outLOF = null;
        this.outFrame = outFrame;
        this.outOrbitType = outOrbitType;
        this.outPositionAngleType = outPositionAngleType;
    }

    @Override
    public TimeStampedPair<Orbit, StateCovariance> interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        Orbit interpolatedOrbit = this.interpolateOrbit(interpolationData.getInterpolationDate(), interpolationData.getNeighborList());
        StateCovariance covarianceInOrbitFrame = this.computeInterpolatedCovarianceInOrbitFrame(interpolationData.getNeighborList(), interpolatedOrbit);
        return this.expressCovarianceInDesiredOutput(interpolatedOrbit, covarianceInOrbitFrame);
    }

    public Frame getOutFrame() {
        return this.outFrame;
    }

    public LOFType getOutLOF() {
        return this.outLOF;
    }

    public OrbitType getOutOrbitType() {
        return this.outOrbitType;
    }

    public PositionAngleType getOutPositionAngleType() {
        return this.outPositionAngleType;
    }

    public TimeInterpolator<Orbit> getOrbitInterpolator() {
        return this.orbitInterpolator;
    }

    protected Orbit interpolateOrbit(AbsoluteDate interpolationDate, List<TimeStampedPair<Orbit, StateCovariance>> neighborList) {
        List<Orbit> orbits = this.buildOrbitList(neighborList);
        return this.orbitInterpolator.interpolate(interpolationDate, orbits);
    }

    protected abstract StateCovariance computeInterpolatedCovarianceInOrbitFrame(List<TimeStampedPair<Orbit, StateCovariance>> var1, Orbit var2);

    protected TimeStampedPair<Orbit, StateCovariance> expressCovarianceInDesiredOutput(Orbit interpolatedOrbit, StateCovariance covarianceInOrbitFrame) {
        StateCovariance covarianceOutput;
        if (this.outLOF == null) {
            if (this.outFrame.isPseudoInertial()) {
                StateCovariance covarianceInOutputFrame = covarianceInOrbitFrame.changeCovarianceFrame(interpolatedOrbit, this.outFrame);
                covarianceOutput = covarianceInOutputFrame.changeCovarianceType(interpolatedOrbit, this.outOrbitType, this.outPositionAngleType);
            } else {
                covarianceOutput = covarianceInOrbitFrame.changeCovarianceFrame(interpolatedOrbit, this.outFrame);
            }
        } else {
            covarianceOutput = covarianceInOrbitFrame.changeCovarianceFrame(interpolatedOrbit, this.outLOF);
        }
        return new TimeStampedPair<Orbit, StateCovariance>(interpolatedOrbit, covarianceOutput);
    }

    private List<Orbit> buildOrbitList(List<TimeStampedPair<Orbit, StateCovariance>> neighborList) {
        Stream uncertainStateStream = neighborList.stream();
        Stream<Orbit> orbitStream = uncertainStateStream.map(TimeStampedPair::getFirst);
        return orbitStream.collect(Collectors.toList());
    }
}

